/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.ws.addressing;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.eclipse.ebpm.common.util.URIResolver;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.interceptors.wsdl.WsdlOperationInInterceptor;
import org.eclipse.ebpm.soap.ws.addressing.AbstractWsAddressingInterceptor;
import org.eclipse.ebpm.soap.ws.addressing.WsAddressingPolicy;

public class WsAddressingInOperationInterceptor
extends AbstractWsAddressingInterceptor {
    public WsAddressingInOperationInterceptor(WsAddressingPolicy policy, boolean server) {
        super(policy, server);
        this.addBefore(WsdlOperationInInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) {
        String nsUri = null;
        for (QName qname : message.getSoapHeaders().keySet()) {
            String[] parts;
            if (!this.isWSANamespace(qname.getNamespaceURI())) continue;
            if (nsUri == null) {
                nsUri = qname.getNamespaceURI();
            } else if (!nsUri.equals(qname.getNamespaceURI())) {
                throw new SoapFault(SoapFault.SENDER, "Inconsistent use of wsa namespaces");
            }
            if ("Action".equals(qname.getLocalPart())) {
                String action = this.getHeaderText(message.getSoapHeaders().get(qname));
                parts = URIResolver.split3(action);
                new QName(parts[0], parts[1]);
                new QName(parts[0], parts[2]);
                continue;
            }
            if (!"To".equals(qname.getLocalPart())) continue;
            String to = this.getHeaderText(message.getSoapHeaders().get(qname));
            parts = URIResolver.split3(to);
            new QName(parts[0], parts[1]);
            String cfr_ignored_0 = parts[2];
        }
    }

    @Override
    public Collection<URI> getRoles() {
        return Collections.emptyList();
    }

    @Override
    public Collection<QName> getUnderstoodHeaders() {
        ArrayList<QName> h = new ArrayList<QName>();
        h.add(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2003/03/addressing", "To"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/03/addressing", "To"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Action"));
        h.add(new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", "To"));
        h.add(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        h.add(new QName("http://www.w3.org/2005/08/addressing", "To"));
        return h;
    }
}

