/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.SequenceInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPInputProtocolAdapter;
import org.eclipse.ebpm.connectors.http.adapters.util.HTTPConnectorUtil;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtendedPlainHTTPInputProtocolAdapter
implements IHTTPInputProtocolAdapter {
    public static final String MULTIPART_CONTENT = "multipart/";
    private static final String prmPrefix = "HTTP-PRM-";

    @Override
    public String getAdapterId() {
        return "ExtendedPlainHTTP";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Exchange createExchange(HttpServletRequest request, String mep, String sender, String target, PropertyConfigurator pc, Object binding) throws Exception {
        Logger logger = LoggerFactory.getLogger(ExtendedPlainHTTPInputProtocolAdapter.class);
        Exchange exchange = null;
        String bodyMessage = null;
        if (mep.equalsIgnoreCase("in-out")) {
            exchange = ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOut);
        } else if (mep.equalsIgnoreCase("in-only")) {
            exchange = ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOnly);
        }
        Message in = exchange.getIn();
        String reqMethod = request.getMethod();
        String reqContentType = request.getContentType();
        if (reqContentType == null || reqContentType.equals("")) {
            reqContentType = "application/octet-stream";
        }
        String reqUri = request.getRequestURL().toString();
        HashMap<String, Object> paramToHeader = new HashMap<String, Object>();
        paramToHeader.put("REQUEST_URI", reqUri);
        paramToHeader.put("CONTENT_TYPE", reqContentType == null ? "" : reqContentType);
        paramToHeader.put("REQUEST_METHOD", reqMethod);
        Enumeration e = request.getHeaderNames();
        while (e.hasMoreElements()) {
            String string = (String)e.nextElement();
            String value = request.getHeader(string);
            paramToHeader.put(string, value);
        }
        if (reqContentType != null && reqContentType.toLowerCase().startsWith(MULTIPART_CONTENT)) {
            Object is = request.getInputStream();
            is = new SequenceInputStream(new ByteArrayInputStream(new byte[]{13, 10}), (InputStream)is);
            Session session = Session.getDefaultInstance((Properties)new Properties());
            MimeMessage mime = new MimeMessage(session, (InputStream)is);
            mime.setHeader("Content-Type", reqContentType);
            bodyMessage = reqContentType.toLowerCase().indexOf("related") == -1 ? this.read(in, mime, paramToHeader) : this.read(in, mime);
        } else if (reqMethod.toLowerCase().equals("GET".toLowerCase())) {
            String queryString = request.getQueryString();
            if (queryString != null) {
                String[] stringArray;
                String[] stringArray2 = stringArray = queryString.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String param = stringArray2[n2];
                    String name = param.split("=")[0];
                    String value = param.split("=")[1];
                    paramToHeader.put(name, value);
                    ++n2;
                }
            }
            bodyMessage = this.createBodyMessage(request);
        } else if (reqMethod.toLowerCase().equals("POST".toLowerCase())) {
            if (reqContentType.toLowerCase().indexOf("application/x-www-form-urlencoded") != -1) {
                Enumeration enu = request.getParameterNames();
                boolean bl = false;
                Object name = "";
                String value = "";
                while (enu.hasMoreElements()) {
                    void var16_21;
                    name = (String)enu.nextElement();
                    value = request.getParameter((String)name);
                    paramToHeader.put((String)name, value);
                    ++var16_21;
                }
                bodyMessage = HTTPConnectorUtil.createXMLBody("");
            } else {
                bodyMessage = this.createBodyMessage(request);
            }
        }
        in.setHeaders(paramToHeader);
        in.setBody(bodyMessage);
        Map headers = in.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            logger.debug("Header " + (String)entry.getKey() + " ==> " + entry.getValue());
        }
        Map map = in.getAttachments();
        for (Map.Entry e3 : map.entrySet()) {
            logger.debug("Attach " + (String)e3.getKey() + " ==> " + e3.getValue());
        }
        logger.debug("Body " + in.getBody());
        exchange.setIn(in);
        return exchange;
    }

    @Override
    public void sendAccepted(Exchange exchange, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) {
        response.setStatus(202);
    }

    @Override
    public void sendError(Exchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        response.setStatus(500);
        XMLWriter responseWriter = new XMLWriter((Writer)response.getWriter());
        Document doc = DocumentHelper.createDocument();
        org.dom4j.Element root = doc.addElement("error");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        pw.close();
        root.addText(sw.toString());
        responseWriter.write(doc);
        responseWriter.flush();
        responseWriter.close();
    }

    @Override
    public void sendFault(Exchange exchange, Message fault, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        response.setStatus(400);
        XMLWriter responseWriter = new XMLWriter((Writer)response.getWriter());
        Document doc = DocumentHelper.parseText((String)fault.getBodyText());
        responseWriter.write(doc);
        responseWriter.flush();
        responseWriter.close();
    }

    @Override
    public void sendOut(Exchange exchange, Message out, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        byte[] byteBuffer = null;
        response.setStatus(200);
        Map headers = out.getHeaders();
        for (Map.Entry e : headers.entrySet()) {
            String aKey = (String)e.getKey();
            if (aKey == null || !aKey.startsWith(prmPrefix)) continue;
            String tmpPrmName = aKey.substring(prmPrefix.length());
            response.addHeader(tmpPrmName, (String)e.getValue());
        }
        if (out.getBody() != null) {
            String outbodyText = out.getBodyText();
            if (outbodyText.indexOf("HTTP-BODY") == -1) {
                byteBuffer = outbodyText.getBytes("UTF-8");
            } else {
                EXMLUtils eXMLUtils = new EXMLUtils();
                org.w3c.dom.Document bodyAsDOM = new SourceTransformer().toDOMDocument(out);
                Element httpBodyNode = eXMLUtils.selectNode((Node)bodyAsDOM, "//HTTP-BODY");
                String tmpCDATA = eXMLUtils.getText((Node)httpBodyNode);
                byteBuffer = tmpCDATA.getBytes("UTF-8");
            }
        }
        ServletOutputStream baos = response.getOutputStream();
        try {
            if (out.getAttachments() != null && out.getAttachments().size() > 0) {
                ExtendedPlainHTTPInputProtocolAdapter.writeMultipartAttachments(out, (OutputStream)baos, byteBuffer, response);
            } else {
                baos.write(byteBuffer);
            }
        }
        finally {
            baos.flush();
            baos.close();
        }
    }

    public static void writeMultipartAttachments(Message message, OutputStream out, byte[] data, HttpServletResponse response) throws MessagingException, IOException {
        MimeMultipart parts = new MimeMultipart("related; type=\"text/xml\"; start=\"<body-part>\"");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        MimeBodyPart soapPart = new MimeBodyPart();
        soapPart.setContentID("<body-part>");
        soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, "text/xml")));
        soapPart.setHeader("Content-Transfer-Encoding", "binary");
        soapPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
        parts.addBodyPart((BodyPart)soapPart);
        for (Map.Entry entry : message.getAttachments().entrySet()) {
            String id = (String)entry.getKey();
            DataHandler dh = (DataHandler)entry.getValue();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(dh);
            part.setContentID("<" + id + ">");
            part.setHeader("Content-Transfer-Encoding", "binary");
            part.setHeader("Content-Type", "application/octet-stream");
            parts.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)parts);
        mime.setHeader("Content-Type", parts.getContentType());
        response.setContentType(parts.getContentType());
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            String tmp = ((Header)headersEnum.nextElement()).getName();
            headersList.add(tmp);
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb = 0;

            @Override
            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }

    private String read(Message message, MimeMessage mime, Map<String, Object> paramToHeader) throws MessagingException, IOException {
        String bodyMessage = "";
        InputStream content = mime.getInputStream();
        if (!(content instanceof InputStream)) {
            throw new UnsupportedOperationException("Expected a InputStream object but found a " + content.getClass());
        }
        InputStream inputStream = content;
        ByteArrayDataSource inboundDataSource = new ByteArrayDataSource(inputStream, mime.getContentType());
        MimeMultipart multipart = new MimeMultipart((DataSource)inboundDataSource);
        int i = 0;
        while (i < multipart.getCount()) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            Header tmp = null;
            String name = "";
            String value = "";
            Enumeration enu1 = part.getAllHeaders();
            String partName = "";
            while (enu1.hasMoreElements()) {
                int idx1;
                tmp = (Header)enu1.nextElement();
                name = tmp.getName();
                value = tmp.getValue();
                if (!name.toLowerCase().equals("content-disposition") || (idx1 = value.indexOf("name=")) == -1) continue;
                String subStr = value.substring(idx1);
                int idx2 = subStr.indexOf(";");
                partName = idx2 == -1 ? subStr.substring(5).trim() : subStr.substring(5, idx2).trim();
                if (partName.startsWith("\"")) {
                    partName = partName.substring(1);
                }
                if (!partName.endsWith("\"")) continue;
                partName = partName.substring(0, partName.length() - 1);
            }
            if (part.getFileName() != null) {
                message.addAttachment(partName, (Object)part.getDataHandler());
            } else {
                InputStream isPart = part.getInputStream();
                String valuePart = HTTPConnectorUtil.convertStreamToString(isPart);
                if (partName.equals("")) {
                    ByteArrayInputStream js = new ByteArrayInputStream(valuePart.getBytes());
                    bodyMessage = HTTPConnectorUtil.isXML(js) ? valuePart : HTTPConnectorUtil.createXMLBody(valuePart);
                    ((InputStream)js).close();
                } else {
                    paramToHeader.put(partName, valuePart);
                }
            }
            ++i;
        }
        if (bodyMessage.equals("")) {
            bodyMessage = HTTPConnectorUtil.createXMLBody("");
        }
        return bodyMessage;
    }

    public String read(Message message, MimeMessage mime) throws MessagingException, IOException {
        Object content = mime.getContent();
        String bodyMessage = "";
        if (!(content instanceof MimeMultipart)) {
            throw new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object but found a " + content.getClass());
        }
        MimeMultipart multipart = (MimeMultipart)content;
        ContentType type = new ContentType(mime.getContentType());
        String contentId = type.getParameter("start");
        MimeBodyPart contentPart = null;
        if (contentId != null) {
            contentPart = (MimeBodyPart)multipart.getBodyPart(contentId);
        } else {
            int i = 0;
            while (i < multipart.getCount()) {
                MimeBodyPart contentPart2 = (MimeBodyPart)multipart.getBodyPart(i);
                String contentType = contentPart2.getContentType();
                if (contentType.indexOf("xml") >= 0) {
                    contentPart = contentPart2;
                    break;
                }
                ++i;
            }
        }
        InputStream is = contentPart.getInputStream();
        bodyMessage = is == null ? "" : HTTPConnectorUtil.convertStreamToString(is);
        ByteArrayInputStream js = new ByteArrayInputStream(bodyMessage.getBytes());
        if (!HTTPConnectorUtil.isXML(js)) {
            bodyMessage = HTTPConnectorUtil.createXMLBody(bodyMessage);
        }
        ((InputStream)js).close();
        int i = 0;
        while (i < multipart.getCount()) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            if (part != contentPart) {
                String id = part.getContentID();
                if (id == null) {
                    id = "Part" + i;
                } else if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                message.addAttachment(id, (Object)part.getDataHandler());
            }
            ++i;
        }
        return bodyMessage;
    }

    private String createBodyMessage(HttpServletRequest request) throws IOException {
        String res = "";
        Object is = request.getInputStream();
        is = new BufferedInputStream((InputStream)is);
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((InputStream)is);
            res = doc.asXML();
        }
        catch (DocumentException documentException) {
            String bodyString = HTTPConnectorUtil.convertStreamToString((InputStream)is);
            res = HTTPConnectorUtil.createXMLBody(bodyString);
        }
        return res;
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

