/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core.registry;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.core.registry.ISpagicRegistry;
import org.eclipse.ebpm.nodemanager.api.INodeManager;
import org.eclipse.ebpm.nodemanager.api.INodeManagerListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class SpagicRegistry
implements ISpagicRegistry,
EventHandler,
ServiceListener,
INodeManagerListener {
    public static String REGISTRY_EVENT_TYPE = "REGISTRY_EVENT_TYPE";
    public static String REGISTRY_EVENT_ADDED = "REGISTRY_EVENT_ADD";
    public static String REGISTRY_EVENT_REMOVED = "REGISTRY_EVENT_REMOVED";
    public static String REGISTRY_EVENT_SPAGIC_ID = "REGISTRY_EVENT_SPAGIC_ID";
    public static String REGISTRY_EVENT_FROM_NODE = "REGISTRY_EVENT_FROM_NODE";
    public static String REGISTRY_EVENT_NODE_UP = "REGISTRY_EVENT_NODE_UP";
    private CopyOnWriteArrayList<String> localServices = new CopyOnWriteArrayList();
    private ConcurrentHashMap<String, List<String>> nodes = new ConcurrentHashMap();
    private AtomicReference<EventAdmin> eventAdmin = new AtomicReference();
    private AtomicReference<INodeManager> nodeManager = new AtomicReference();

    protected void activate(ComponentContext componentContext) {
        componentContext.getBundleContext().addServiceListener((ServiceListener)this);
    }

    protected void deactivate(ComponentContext componentContext) {
        componentContext.getBundleContext().removeServiceListener((ServiceListener)this);
    }

    protected boolean isRegisteredRemotedOnNode(String spagicId, String node) {
        List<String> servicesOnNode = this.nodes.get(node);
        return servicesOnNode != null && !servicesOnNode.isEmpty() && servicesOnNode.contains(spagicId);
    }

    @Override
    public boolean isRegistered(String spagicId) {
        return this.isRelativeIdRegistered(spagicId);
    }

    public boolean isRelativeIdRegistered(String relativeId) {
        boolean localReg = this.localServices.contains(relativeId);
        if (!localReg) {
            for (String n : this.nodes.keySet()) {
                if (!this.isRegisteredRemotedOnNode(relativeId, n)) continue;
                return true;
            }
            return false;
        }
        return localReg;
    }

    public void bindNodeManager(INodeManager nodeManager) {
        this.nodeManager.set(nodeManager);
        if (SpagicNode.isClusteredEnabled()) {
            INodeManager lNodeManager = this.nodeManager.get();
            lNodeManager.registerListener((INodeManagerListener)this);
            lNodeManager.join("SpagicCluster", SpagicNode.id());
            lNodeManager.registerListener((INodeManagerListener)this);
        }
    }

    public void unbindNodeManager(INodeManager nodeManager) {
        INodeManager lNodeManager;
        if (SpagicNode.isClusteredEnabled() && (lNodeManager = this.nodeManager.get()) != null) {
            lNodeManager.disconnet();
        }
        this.nodeManager.compareAndSet(nodeManager, null);
    }

    public void bind(EventAdmin ea) {
        this.eventAdmin.set(ea);
        if (SpagicNode.isClusteredEnabled()) {
            this.nodeUp();
            this.snapshot();
        }
    }

    public void unbind(EventAdmin ea) {
        if (SpagicNode.isClusteredEnabled()) {
            INodeManager lNodeManager = this.nodeManager.get();
            if (this.nodeManager != null) {
                lNodeManager.disconnet();
            }
        }
        this.eventAdmin.compareAndSet(ea, null);
    }

    public void serviceChanged(ServiceEvent event) {
        String spagicId = this.getSpagicId(event);
        if (spagicId != null) {
            if (event.getType() == 1) {
                this.localServices.add(spagicId);
                this.notify(spagicId, REGISTRY_EVENT_ADDED);
            } else if (event.getType() == 4) {
                this.localServices.remove(spagicId);
                this.notify(spagicId, REGISTRY_EVENT_REMOVED);
            } else {
                event.getType();
            }
        }
    }

    private String getSpagicId(ServiceEvent event) {
        return (String)event.getServiceReference().getProperty("spagic.id");
    }

    public void snapshot() {
        for (String localString : this.localServices) {
            this.notify(localString, REGISTRY_EVENT_ADDED);
        }
    }

    public void notify(String spagicId, String evType) {
        EventAdmin ea = this.eventAdmin.get();
        if (ea != null) {
            Hashtable<String, String> evProperties = new Hashtable<String, String>();
            ((Dictionary)evProperties).put(REGISTRY_EVENT_TYPE, evType);
            ((Dictionary)evProperties).put(REGISTRY_EVENT_FROM_NODE, System.getProperty("SPAGIC_NODE_IDENTIFIER"));
            ((Dictionary)evProperties).put(REGISTRY_EVENT_SPAGIC_ID, spagicId);
            Event ev = new Event("SPAGIC/REGISTRY", evProperties);
            ea.postEvent(ev);
        }
    }

    public void nodeUp() {
        EventAdmin ea = this.eventAdmin.get();
        if (ea != null) {
            Hashtable<String, String> evProperties = new Hashtable<String, String>();
            ((Dictionary)evProperties).put(REGISTRY_EVENT_TYPE, REGISTRY_EVENT_NODE_UP);
            ((Dictionary)evProperties).put(REGISTRY_EVENT_FROM_NODE, System.getProperty("SPAGIC_NODE_IDENTIFIER"));
            Event ev = new Event("SPAGIC/REGISTRY", evProperties);
            ea.postEvent(ev);
        }
    }

    public boolean isFromMySelf(Event event) {
        String from = (String)event.getProperty(REGISTRY_EVENT_FROM_NODE);
        return SpagicNode.id().equals(from);
    }

    public void registeredServiceFromNode(String spagicId, String from) {
        if (!this.nodes.containsKey(from)) {
            ArrayList<String> servicesOnNode = new ArrayList<String>();
            servicesOnNode.add(spagicId);
            this.nodes.put(from, servicesOnNode);
        } else {
            this.nodes.get(from).add(spagicId);
        }
    }

    public void unregistered(String spagicId, String from) {
        if (this.nodes.containsKey(from)) {
            this.nodes.get(from).remove(spagicId);
            if (this.nodes.get(from).size() == 0) {
                this.nodes.remove(from);
            }
        }
    }

    public void handleEvent(Event event) {
        String evType = (String)event.getProperty(REGISTRY_EVENT_TYPE);
        String from = (String)event.getProperty(REGISTRY_EVENT_FROM_NODE);
        System.out.println("SPAGIC_REGISTRY ->  REGISTRY EVENT FROM [" + from + "] -> [" + evType + "]");
        if (!this.isFromMySelf(event)) {
            String spagicId = (String)event.getProperty(REGISTRY_EVENT_SPAGIC_ID);
            if (evType.equalsIgnoreCase(REGISTRY_EVENT_ADDED)) {
                this.registeredServiceFromNode(spagicId, from);
            } else if (evType.equalsIgnoreCase(REGISTRY_EVENT_REMOVED)) {
                this.unregistered(spagicId, from);
            } else if (evType.equalsIgnoreCase(REGISTRY_EVENT_NODE_UP)) {
                this.snapshot();
            }
        } else {
            System.out.println("SPAGIC_REGISTRY ->  FROM MYSELF IGNORE IT :-)");
        }
    }

    @Override
    public String getServiceNode(String spagicId) {
        if (this.localServices.contains(spagicId)) {
            return SpagicNode.id();
        }
        for (String node : this.nodes.keySet()) {
            if (!this.isRegisteredRemotedOnNode(spagicId, node)) continue;
            return node;
        }
        return null;
    }

    @Override
    public List<String> getSnaphshot() {
        ArrayList<String> snapshot = new ArrayList<String>();
        for (String local : this.localServices) {
            snapshot.add(String.valueOf(local) + "@" + System.getProperty("SPAGIC_NODE_IDENTIFIER"));
        }
        for (String key : this.nodes.keySet()) {
            List<String> services = this.nodes.get(key);
            for (String s : services) {
                snapshot.add(String.valueOf(s) + "@" + key);
            }
        }
        return snapshot;
    }

    @Override
    public boolean isRegisteredLocally(String spagicId) {
        return this.localServices.contains(spagicId);
    }

    public void onClusterChange(List<String> newMembers) {
        System.out.println("** New Member List Received: ");
        boolean newNodeAdded = false;
        for (String newNode : newMembers) {
            if (newNode.equals(SpagicNode.id()) || this.nodes.contains(newNode)) continue;
            this.nodes.put(newNode, new ArrayList());
            newNodeAdded = true;
        }
        if (newNodeAdded) {
            this.snapshot();
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        for (String node : this.nodes.keySet()) {
            if (newMembers.contains(node)) continue;
            toRemove.add(node);
        }
        for (String n : toRemove) {
            this.nodes.remove(n);
        }
    }
}

