/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * The persistent class for the event database table.
 * 
 */
@Entity
@Table(name="EBAM_EVENT")
public class Event implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@Column(name="EVENT_ID")
	private Double eventId;

    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="END_DATE")
	private Date endDate;

	@Column(name="EXPRESSION")
	private String expression;

	@Column(name="HANDLER_CLASS")
	private String handlerClass;

	@Column(name="NAME")
	private String name;
	
	@Column(name="PERSIST")
	private int persist;

    @Temporal( TemporalType.TIMESTAMP)
	@Column(name="START_DATE")
	private Date startDate;

	//bi-directional many-to-one association to CepRule
	@OneToMany(mappedBy="event",fetch=FetchType.LAZY)
	private Set<Rule> cepRules;

	//bi-directional many-to-one association to EventJournal
	@OneToMany(mappedBy="event",fetch=FetchType.LAZY)
	private Set<EventJournal> eventJournals;

    public Event() {
    }

	public double getEventId() {
		return this.eventId;
	}

	public void setEventId(double eventId) {
		this.eventId = eventId;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public String getExpression() {
		return this.expression;
	}

	public void setExpression(String expression) {
		this.expression = expression;
	}

	public String getHandlerClass() {
		return this.handlerClass;
	}

	public void setHandlerClass(String handlerClass) {
		this.handlerClass = handlerClass;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Set<Rule> getCepRules() {
		return this.cepRules;
	}

	public void setCepRules(Set<Rule> cepRules) {
		this.cepRules = cepRules;
	}
	
	public Set<EventJournal> getEventJournals() {
		return this.eventJournals;
	}

	public void setEventJournals(Set<EventJournal> eventJournals) {
		this.eventJournals = eventJournals;
	}

	public int getPersist() {
		return persist;
	}

	public void setPersist(int persist) {
		this.persist = persist;
	}
	
	
	
}