/*******************************************************************************
 * Copyright (c) 2004, 2009 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.LevelFilter;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinition;


public class DrillCubeQueryDefinition extends CubeQueryDefinition
{

	private List<LevelFilter> levelFilterList;
	private Collection<?> columnTuple = Collections.EMPTY_LIST,
			rowTuple = Collections.EMPTY_LIST;

	public DrillCubeQueryDefinition( String name )
	{
		super( name );
		levelFilterList = new ArrayList<LevelFilter>( );
	}

	public void setTupleOnColumn( Collection tuple )
	{
		this.columnTuple = tuple;
	}

	public void setTupleOnRow( Collection tuple )
	{
		this.rowTuple = tuple;
	}

	public Collection getTupleOnColumn( )
	{
		return this.columnTuple;
	}

	public Collection getTupleOnRow( )
	{
		return this.rowTuple;
	}

	public void addLevelFilter( LevelFilter filter )
	{
		levelFilterList.add( filter );
	}
	
	public List<LevelFilter> getLevelFilter( )
	{
		return levelFilterList;
	}
}
