/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import org.eclipse.jpt.utility.internal.model.ChangeSupport;
import org.eclipse.jpt.utility.internal.model.value.PropertyValueModelWrapper;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueAspectAdapter<V>
extends PropertyValueModelWrapper<V>
implements WritablePropertyValueModel<V> {
    protected V value = null;

    protected ValueAspectAdapter(WritablePropertyValueModel<V> valueHolder) {
        super(valueHolder);
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new ChangeSupport(this);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.getValueHolder().setValue(value);
    }

    @Override
    protected void valueChanged(PropertyChangeEvent event) {
        this.disengageValue();
        this.engageValue();
        this.firePropertyChanged(event.clone(this));
    }

    @Override
    public synchronized void addStateChangeListener(StateChangeListener listener) {
        if (this.hasNoListeners()) {
            this.engageModel();
        }
        super.addStateChangeListener(listener);
    }

    @Override
    public synchronized void removeStateChangeListener(StateChangeListener listener) {
        super.removeStateChangeListener(listener);
        if (this.hasNoListeners()) {
            this.disengageModel();
        }
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyStateChangeListeners() || super.hasListeners();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.engageValue();
    }

    @Override
    protected void disengageModel() {
        this.disengageValue();
        super.disengageModel();
    }

    protected void engageValue() {
        this.value = this.valueHolder.getValue();
        if (this.value != null) {
            this.engageValue_();
        }
    }

    protected abstract void engageValue_();

    protected void disengageValue() {
        if (this.value != null) {
            this.disengageValue_();
            this.value = null;
        }
    }

    protected abstract void disengageValue_();

    protected void valueAspectChanged() {
        this.fireStateChanged();
    }

    protected WritablePropertyValueModel<V> getValueHolder() {
        return (WritablePropertyValueModel)this.valueHolder;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.getValue());
    }
}

