/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.EventListener;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AspectListValueModelAdapter<S, E>
extends AspectAdapter<S>
implements ListValueModel<E> {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    protected AspectListValueModelAdapter(PropertyValueModel<? extends S> subjectHolder) {
        super(subjectHolder);
    }

    @Override
    public ListIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.subject == null ? EmptyListIterator.instance() : this.listIterator_();
    }

    protected ListIterator<E> listIterator_() {
        return this.getListIterable().iterator();
    }

    protected ListIterable<E> getListIterable() {
        throw new RuntimeException("This method was not overridden.");
    }

    @Override
    public E get(int index) {
        return CollectionTools.get(this.listIterator(), index);
    }

    @Override
    public int size() {
        return this.subject == null ? 0 : this.size_();
    }

    protected int size_() {
        return CollectionTools.size(this.listIterator());
    }

    @Override
    public Object[] toArray() {
        return this.subject == null ? EMPTY_ARRAY : this.toArray_();
    }

    protected Object[] toArray_() {
        return ArrayTools.array(this.listIterator(), this.size());
    }

    @Override
    protected List<E> getValue() {
        return this.buildValueList();
    }

    @Override
    protected Class<? extends EventListener> getListenerClass() {
        return ListChangeListener.class;
    }

    @Override
    protected String getListenerAspectName() {
        return "list values";
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyListChangeListeners("list values");
    }

    @Override
    protected void fireAspectChanged(Object oldValue, Object newValue) {
        List newList = (List)newValue;
        this.fireListChanged("list values", newList);
    }

    protected void listChanged() {
        this.fireListChanged("list values", this.buildValueList());
    }

    protected List<E> buildValueList() {
        return CollectionTools.list(this.iterator());
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.buildValueList());
    }
}

