/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;

public final class AWTCollectionChangeListenerWrapper
implements CollectionChangeListener {
    private final CollectionChangeListener listener;

    public AWTCollectionChangeListenerWrapper(CollectionChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void itemsAdded(CollectionAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsAddedRunnable(event));
        }
    }

    public void itemsRemoved(CollectionRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.itemsRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildItemsRemovedRunnable(event));
        }
    }

    public void collectionCleared(CollectionClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.collectionCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildCollectionClearedRunnable(event));
        }
    }

    public void collectionChanged(CollectionChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.collectionChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildCollectionChangedRunnable(event));
        }
    }

    private Runnable buildItemsAddedRunnable(final CollectionAddEvent event) {
        return new Runnable(){

            public void run() {
                AWTCollectionChangeListenerWrapper.this.itemsAdded_(event);
            }

            public String toString() {
                return "items added";
            }
        };
    }

    private Runnable buildItemsRemovedRunnable(final CollectionRemoveEvent event) {
        return new Runnable(){

            public void run() {
                AWTCollectionChangeListenerWrapper.this.itemsRemoved_(event);
            }

            public String toString() {
                return "items removed";
            }
        };
    }

    private Runnable buildCollectionClearedRunnable(final CollectionClearEvent event) {
        return new Runnable(){

            public void run() {
                AWTCollectionChangeListenerWrapper.this.collectionCleared_(event);
            }

            public String toString() {
                return "collection cleared";
            }
        };
    }

    private Runnable buildCollectionChangedRunnable(final CollectionChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTCollectionChangeListenerWrapper.this.collectionChanged_(event);
            }

            public String toString() {
                return "collection changed";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void itemsAdded_(CollectionAddEvent event) {
        this.listener.itemsAdded(event);
    }

    void itemsRemoved_(CollectionRemoveEvent event) {
        this.listener.itemsRemoved(event);
    }

    void collectionCleared_(CollectionClearEvent event) {
        this.listener.collectionCleared(event);
    }

    void collectionChanged_(CollectionChangeEvent event) {
        this.listener.collectionChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }
}

