/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.Serializable;
import org.eclipse.jpt.utility.internal.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectReference<V>
implements Cloneable,
Serializable {
    private volatile V value;
    private static final long serialVersionUID = 1L;

    public ObjectReference(V value) {
        this.value = value;
    }

    public ObjectReference() {
        this(null);
    }

    public V getValue() {
        return this.value;
    }

    public boolean valueEquals(V v) {
        return Tools.valuesAreEqual(this.value, v);
    }

    public boolean valueNotEqual(V v) {
        return Tools.valuesAreDifferent(this.value, v);
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isNotNull() {
        return this.value != null;
    }

    public V setValue(V value) {
        V old = this.value;
        this.value = value;
        return old;
    }

    public V setNull() {
        return this.setValue(null);
    }

    public ObjectReference<V> clone() {
        try {
            ObjectReference clone = (ObjectReference)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ObjectReference && Tools.valuesAreEqual(this.value, ((ObjectReference)obj).value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

