/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.examples.radar.render;

import com.ibm.icu.util.ULocale;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.computation.withoutaxes.SeriesRenderingHints;
import org.eclipse.birt.chart.datafeed.IDataSetProcessor;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.event.EventObjectCache;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.examples.radar.i18n.Messages;
import org.eclipse.birt.chart.examples.radar.model.type.RadarSeries;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.layout.ClientArea;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.render.BaseRenderer;
import org.eclipse.birt.chart.render.ISeriesRenderingHints;
import org.eclipse.birt.chart.script.AbstractScriptHandler;
import org.eclipse.birt.chart.script.ScriptHandler;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public class Radar
extends BaseRenderer {
    public static final String TYPE_LITERAL = "Radar Chart";
    public static final String STANDARD_SUBTYPE_LITERAL = "Standard Radar Chart";
    public static final String SPIDER_SUBTYPE_LITERAL = "Spider Radar Chart";
    public static final String BULLSEYE_SUBTYPE_LITERAL = "Bullseye Radar Chart";
    static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.examples/render");
    private int scaleCount = 6;
    private double percentReduce = 0.2;
    private double dSafeSpacing = 10.0;
    private DataPointHints[] dpha = null;
    private double axisMin = Double.MAX_VALUE;
    private double axisMax = Double.MIN_VALUE;

    double getAxisMin() {
        return this.axisMin;
    }

    double getAxisMax() {
        return this.axisMax;
    }

    private void getDsMinMax() {
        PluginSettings ps = PluginSettings.instance();
        IDataSetProcessor iDSP = null;
        EList el = ((ChartWithoutAxes)this.getModel()).getSeriesDefinitions();
        ArrayList al = new ArrayList();
        ((ChartWithoutAxesImpl)this.getModel()).recursivelyGetSeries(el, al, 0, 0);
        Series[] sea = al.toArray(new Series[al.size()]);
        int i = 0;
        while (i < sea.length) {
            try {
                iDSP = ps.getDataSetProcessor(sea[i].getClass());
                DataSet dst = sea[i].getDataSet();
                Double min = (Double)iDSP.getMinimum(dst);
                Double max = (Double)iDSP.getMaximum(dst);
                if (min != null && min < this.axisMin) {
                    this.axisMin = min;
                }
                if (max != null && max > this.axisMax) {
                    this.axisMax = max;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void compute(Bounds bo, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesRenderingHints srh = (SeriesRenderingHints)isrh;
        try {
            this.validateDataSetCount(isrh);
        }
        catch (ChartException vex) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)vex);
        }
        try {
            this.dpha = srh.getDataPoints();
            double[] da = srh.asPrimitiveDoubleValues();
            if (this.dpha == null || da == null || this.dpha.length < 1 || da.length < 1) {
                throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.invalid.datapoint.dial", org.eclipse.birt.chart.engine.extension.i18n.Messages.getResourceBundle((ULocale)this.getRunTimeContext().getULocale()));
            }
            RadarSeries rsd = this.getFirstSeries();
            int psc = rsd.getPlotSteps().intValue();
            if (psc > 20) {
                psc = 20;
            }
            if (psc < 1) {
                psc = 1;
            }
            this.scaleCount = psc;
            double cvr = ((ChartWithoutAxes)this.getModel()).getCoverage();
            if (cvr <= 0.0) {
                cvr = 0.8;
            }
            this.percentReduce = 1.0 - cvr;
            this.dSafeSpacing *= this.getDeviceScale();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 3, (Throwable)ex);
        }
    }

    public void renderSeries(IPrimitiveRenderer ipr, Plot p, ISeriesRenderingHints isrh) throws ChartException {
        SeriesDefinition sd = this.getSeriesDefinition();
        ChartWithoutAxes cwoa = (ChartWithoutAxes)this.getModel();
        if (cwoa.getDimension() != ChartDimension.TWO_DIMENSIONAL_LITERAL) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.dial.dimension", new Object[]{cwoa.getDimension().getName()}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        logger.log(1, String.valueOf(Messages.getString("info.render.series", this.getRunTimeContext().getULocale())) + ((Object)((Object)this)).getClass().getName() + (this.iSeriesIndex + 1) + this.iSeriesCount);
        this.getDsMinMax();
        this.render(this.getDevice(), this.srh.getClientAreaBounds(true), (RadarSeries)this.getSeries(), sd);
    }

    public void renderLegendGraphic(IPrimitiveRenderer ipr, Legend lg, Fill fPaletteEntry, Bounds bo) throws ChartException {
        double height;
        int iThisSeriesIndex;
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0) {
            return;
        }
        ClientArea ca = lg.getClientArea();
        LineAttributes lia = ca.getOutline();
        RadarSeries ls = (RadarSeries)this.getSeries();
        if (fPaletteEntry == null) {
            fPaletteEntry = ColorDefinitionImpl.RED();
        }
        RectangleRenderEvent rre = (RectangleRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), RectangleRenderEvent.class);
        rre.setBackground(ca.getBackground());
        rre.setOutline(lia);
        rre.setBounds(bo);
        ipr.fillRectangle(rre);
        LineAttributes liaMarker = ls.getLineAttributes();
        if (!liaMarker.isSetVisible()) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.unspecified.marker.linestyle.visibility", Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        if (liaMarker.isVisible()) {
            LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)ipr).getEventObject((Object)StructureSource.createLegend((Legend)lg), LineRenderEvent.class);
            if (fPaletteEntry instanceof ColorDefinition && ls.isSetPaletteLineColor() && ls.isPaletteLineColor()) {
                liaMarker = goFactory.copyOf(liaMarker);
                liaMarker.setColor(goFactory.copyOf(FillUtil.getColor((Fill)fPaletteEntry)));
            }
            lre.setLineAttributes(liaMarker);
            lre.setStart(LocationImpl.create((double)(bo.getLeft() + 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            lre.setEnd(LocationImpl.create((double)(bo.getLeft() + bo.getWidth() - 1.0), (double)(bo.getTop() + bo.getHeight() / 2.0)));
            ipr.drawLine(lre);
        }
        SeriesDefinition sd = this.getSeriesDefinition();
        boolean bPaletteByCategory = this.isPaletteByCategory();
        if (bPaletteByCategory && ls.eContainer() instanceof SeriesDefinition) {
            sd = (SeriesDefinition)ls.eContainer();
        }
        if ((iThisSeriesIndex = sd.getRunTimeSeries().indexOf(ls)) < 0) {
            throw new ChartException("org.eclipse.birt.chart.engine.extension", 11, "exception.missing.series.for.palette.index", new Object[]{ls, sd}, Messages.getResourceBundle(this.getRunTimeContext().getULocale()));
        }
        Marker m = null;
        m = ls.getMarker();
        double width = bo.getWidth() / this.getDeviceScale();
        int markerSize = (int)(((width > (height = bo.getHeight() / this.getDeviceScale()) ? height : width) - 2.0) / 2.0);
        if (markerSize <= 0) {
            markerSize = 1;
        }
        if (m != null && m.isVisible()) {
            this.renderMarker(lg, ipr, m, LocationImpl.create((double)(bo.getLeft() + bo.getWidth() / 2.0), (double)(bo.getTop() + bo.getHeight() / 2.0)), ls.getLineAttributes(), fPaletteEntry, null, new Integer(markerSize), false, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderPolys(IDeviceRenderer idr, Location[] prelo, Series se, SeriesDefinition sd) {
        int iThisSeriesIndex = sd.getRunTimeSeries().indexOf(se);
        if (iThisSeriesIndex == -1) {
            iThisSeriesIndex = this.getSeriesIndex();
        }
        EList elPalette = sd.getSeriesPalette().getEntries();
        Fill fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
        LineAttributes llia = ((RadarSeries)se).getLineAttributes();
        PolygonRenderEvent pre = (PolygonRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), PolygonRenderEvent.class);
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), LineRenderEvent.class);
        if (se.isSetTranslucent() && se.isTranslucent() && fPaletteEntry instanceof ColorDefinition) {
            fPaletteEntry = goFactory.translucent((ColorDefinition)fPaletteEntry);
        }
        if (!((RadarSeries)se).isConnectEndpoints()) {
            lre.setLineAttributes(llia);
            int i = 0;
            while (i < prelo.length - 1) {
                lre.setStart(prelo[i]);
                lre.setEnd(prelo[i + 1]);
                try {
                    idr.drawLine(lre);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            return;
        }
        pre.setBackground(fPaletteEntry);
        pre.setPoints(prelo);
        pre.setOutline(llia);
        try {
            idr.drawPolygon(pre);
            if (!((RadarSeries)se).isFillPolys()) return;
            idr.fillPolygon(pre);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderAxes(IDeviceRenderer idr, PolarCoordinate pc, Series se, double magnitude) {
        Location center = pc.getCenter();
        int iSeriesCount = this.getSeriesCount() - 1;
        int iCount = pc.getCount() * iSeriesCount;
        pc = new PolarCoordinate(center, iCount, 1, 0);
        Location lo = center.copyInstance();
        LineAttributes lia = null;
        LineAttributes wlia = null;
        RadarSeries rsd = this.getFirstSeries();
        wlia = rsd.getWebLineAttributes();
        lia = wlia == null ? LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1) : wlia;
        LineRenderEvent lre = (LineRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), LineRenderEvent.class);
        OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), OvalRenderEvent.class);
        lre.setLineAttributes(lia);
        lre.setStart(center);
        try {
            int i = 0;
            while (i < iCount) {
                pc.computeLocation(lo, i, magnitude);
                lre.setEnd(lo);
                idr.drawLine(lre);
                ++i;
            }
            String subType = this.getModel().getSubType();
            if (STANDARD_SUBTYPE_LITERAL.equals(subType) || BULLSEYE_SUBTYPE_LITERAL.equals(subType)) {
                ore.setBackground((Fill)lia.getColor());
                ore.setOutline(lia);
                Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)0.0, (double)0.0);
                int sc = 1;
                while (sc <= this.scaleCount) {
                    double spiderMag = magnitude * (double)sc / (double)this.scaleCount;
                    ore.setBounds(pc.computeBounds(bo, spiderMag));
                    idr.drawOval(ore);
                    ++sc;
                }
            } else if (SPIDER_SUBTYPE_LITERAL.equals(subType)) {
                Location lo1 = lo.copyInstance();
                int sc = 1;
                while (sc < this.scaleCount + 1) {
                    double spiderMag = magnitude * (double)sc / (double)this.scaleCount;
                    pc.computeLocation(lo1, 0, spiderMag);
                    int index = 1;
                    while (index < iCount + 1) {
                        lo.set(lo1.getX(), lo1.getY());
                        pc.computeLocation(lo1, index, spiderMag);
                        lre.setStart(lo);
                        lre.setEnd(lo1);
                        idr.drawLine(lre);
                        ++index;
                    }
                    ++sc;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderOvalBackgrounds(IDeviceRenderer idr, Location center, Series se, double magnitude) {
        OvalRenderEvent ore = (OvalRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), OvalRenderEvent.class);
        LineAttributes lia = null;
        LineAttributes wlia = ((RadarSeries)se).getWebLineAttributes();
        lia = wlia == null ? LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.GREY(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1) : wlia;
        ore.setBackground((Fill)lia.getColor());
        ore.setOutline(lia);
        int sc = this.scaleCount;
        while (sc >= 1) {
            RadarSeries rsd;
            double spiderMag = magnitude * (double)sc / (double)this.scaleCount;
            ore.setBounds(goFactory.createBounds(center.getX() - spiderMag, center.getY() - spiderMag, spiderMag * 2.0, spiderMag * 2.0));
            Fill wPaletteEntry = null;
            Palette pa = this.sd.getSeriesPalette();
            int ps = pa.getEntries().size();
            int tscnt = this.getSeriesCount();
            int palcnt = ps + tscnt + sc;
            if (palcnt > ps) {
                palcnt = 1;
            }
            if ((wPaletteEntry = FillUtil.getPaletteFill((EList)pa.getEntries(), (int)(sc + 1))) instanceof ColorDefinition && (rsd = this.getFirstSeries()).isBackgroundOvalTransparent()) {
                wPaletteEntry = goFactory.translucent((ColorDefinition)wPaletteEntry);
            }
            ore.setBackground(wPaletteEntry);
            try {
                idr.fillOval(ore);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --sc;
        }
    }

    private final void drawSeriesLabel(IDeviceRenderer idr, PolarCoordinate pc, DataPointHints dph, Location lo) throws ChartException {
        if (this.se.getLabel().isVisible()) {
            double space = this.dSafeSpacing / 2.0;
            Label la = goFactory.copyOf(this.se.getLabel());
            la.getCaption().setValue(dph.getDisplayValue());
            Location loLabel = lo;
            TextRenderEvent tre = (TextRenderEvent)((EventObjectCache)idr).getEventObject((Object)WrappedStructureSource.createSeriesDataPoint((Series)this.se, (DataPointHints)dph), TextRenderEvent.class);
            tre.setLabel(la);
            tre.setAction(2);
            int degree = pc.getDegree(dph.getIndex());
            if (Math.abs(degree) > 90) {
                tre.setTextPosition(1);
            } else {
                tre.setTextPosition(2);
            }
            double dX = (double)(-Math.signum(Math.abs(degree) - 90)) * space;
            double dY = (double)(-Math.signum(degree)) * space;
            loLabel.translate(dX, dY);
            tre.setLocation(loLabel);
            this.dc.addLabel(tre);
        }
    }

    private final void render(IDeviceRenderer idr, Bounds bo, RadarSeries se, SeriesDefinition sd) throws ChartException {
        List rts = sd.getRunTimeSeries();
        int iThisSeriesIndex = rts.indexOf(se);
        if (iThisSeriesIndex == -1) {
            iThisSeriesIndex = this.getSeriesIndex();
        }
        int totalSeriesCnt = this.getSeriesCount();
        int currSeriesIdx = this.getSeriesIndex();
        EList elPalette = sd.getSeriesPalette().getEntries();
        AbstractScriptHandler sh = this.getRunTimeContext().getScriptHandler();
        this.dc = this.getDeferredCache();
        Bounds boCA = goFactory.copyOf(bo);
        double dh = boCA.getHeight() - boCA.getHeight() * this.percentReduce;
        double dl = boCA.getLeft() + boCA.getWidth() * this.percentReduce / 2.0;
        double dt = boCA.getTop() + boCA.getHeight() * this.percentReduce / 2.0;
        double dw = boCA.getWidth() - boCA.getWidth() * this.percentReduce;
        double centrePointX = Math.round(dl + dw / 2.0);
        double centrePointY = Math.round(dt + dh / 2.0);
        double mag = dh / 2.0;
        Location cntpt = LocationImpl.create((double)centrePointX, (double)centrePointY);
        if (currSeriesIdx == 1 && BULLSEYE_SUBTYPE_LITERAL.equals(this.getModel().getSubType())) {
            this.renderOvalBackgrounds(idr, cntpt, se, mag);
        }
        PolarCoordinate pc = new PolarCoordinate(cntpt, this.dpha.length, this.getSeriesCount() - 1, this.getSeriesIndex() - 1);
        boolean bPaletteByCategory = this.isPaletteByCategory();
        Fill fPaletteEntry = null;
        if (!bPaletteByCategory) {
            fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)iThisSeriesIndex);
            this.updateTranslucency(fPaletteEntry, se);
        }
        Location loAxis = LocationImpl.create((double)centrePointX, (double)centrePointY);
        LinkedList<Location> loList = new LinkedList<Location>();
        int index = 0;
        while (index < this.dpha.length) {
            double currval;
            DataPointHints dph = this.dpha[index];
            if (!Radar.isNaN((Object)dph.getOrthogonalValue()) && !((currval = ((Double)dph.getOrthogonalValue()).doubleValue()) < 0.0)) {
                Marker m;
                pc.computeLocation(loAxis, index, mag);
                Location lo = pc.createLocation(index, mag * (currval / this.getAxisMax()));
                loList.add(lo);
                if (bPaletteByCategory) {
                    fPaletteEntry = FillUtil.getPaletteFill((EList)elPalette, (int)index);
                    this.updateTranslucency(fPaletteEntry, se);
                }
                LineAttributes llia = se.getLineAttributes();
                if (se.isPaletteLineColor() && index == 0) {
                    llia.setColor(goFactory.copyOf(FillUtil.getColor((Fill)fPaletteEntry)));
                }
                if ((m = se.getMarker()) != null) {
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"beforeDrawDataPoint", (Object)dph, (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("beforeDrawDataPoint", (Object)dph);
                    this.renderMarker(se, (IPrimitiveRenderer)idr, m, lo, llia, fPaletteEntry, dph, m.getSize(), true, false);
                    ScriptHandler.callFunction((AbstractScriptHandler)sh, (String)"afterDrawDataPoint", (Object)dph, (Object)fPaletteEntry, (Object)this.getRunTimeContext().getScriptContext());
                    this.getRunTimeContext().notifyStructureChange("afterDrawDataPoint", (Object)dph);
                }
                this.drawSeriesLabel(idr, pc, dph, loAxis);
            }
            ++index;
        }
        this.renderPolys(idr, loList.toArray(new Location[loList.size()]), se, sd);
        if (currSeriesIdx == totalSeriesCnt - 1) {
            RadarSeries rsd;
            if (se.getWebLineAttributes() != null && se.getWebLineAttributes().isVisible()) {
                this.renderAxes(idr, pc, se, mag);
            }
            if ((rsd = this.getFirstSeries()).isShowWebLabels()) {
                Location loLabel = LocationImpl.create((double)0.0, (double)0.0);
                int sc = 0;
                while (sc <= this.scaleCount) {
                    TextRenderEvent stre = (TextRenderEvent)((EventObjectCache)idr).getEventObject((Object)StructureSource.createSeries((Series)se), TextRenderEvent.class);
                    Label la = goFactory.copyOf(rsd.getLabel());
                    la.setVisible(true);
                    stre.setTextPosition(2);
                    double lblperc = (double)sc / (double)this.scaleCount * 100.0;
                    DecimalFormat decform = new DecimalFormat("#.##");
                    lblperc = Double.valueOf(decform.format(lblperc));
                    la.getCaption().setValue(String.valueOf(lblperc) + "%");
                    stre.setLabel(la);
                    stre.setAction(2);
                    double ycord = mag * (double)sc / (double)this.scaleCount;
                    ycord = Math.round(centrePointY - ycord);
                    double xcord = Math.round(centrePointX - 10.0);
                    loLabel.set(xcord, ycord);
                    stre.setLocation(loLabel);
                    this.dc.addLabel(stre);
                    ++sc;
                }
            }
        }
    }

    private RadarSeries getFirstSeries() {
        return (RadarSeries)((SeriesDefinition)((SeriesDefinition)((ChartWithoutAxes)this.getModel()).getSeriesDefinitions().get(0)).getSeriesDefinitions().get(0)).getSeries().get(0);
    }

    private static class PolarCoordinate {
        private final Location center;
        private final int iSeriesCount;
        private final int iSeriesIndex;
        private final int iCount;
        private final double delta;

        public PolarCoordinate(Location center, int iCount, int iSeriesCount, int iSeriesIndex) {
            this.center = center;
            this.iSeriesCount = iSeriesCount;
            this.iSeriesIndex = iSeriesIndex;
            this.iCount = iCount;
            this.delta = Math.PI * 2 / (double)iCount;
        }

        public Location getCenter() {
            return this.center;
        }

        public int getCount() {
            return this.iCount;
        }

        public double getAngle(int index, int iSeriesIndex) {
            return (double)index * this.delta + (double)iSeriesIndex * this.delta / (double)this.iSeriesCount;
        }

        public double getAngle(int index) {
            return this.getAngle(index, this.iSeriesIndex);
        }

        public int getDegree(int index) {
            double degree = Math.toDegrees(this.getAngle(index)) % 360.0;
            if (degree < 0.0) {
                degree += 360.0;
            }
            if (degree > 180.0) {
                degree -= 360.0;
            }
            return (int)Math.round(degree);
        }

        public Location computeLocation(Location lo, int index, double magnitude) {
            double angle = this.getAngle(index, this.iSeriesIndex);
            double x = Math.cos(angle) * magnitude;
            double y = Math.sin(angle) * magnitude;
            lo.set(this.center.getX() + x, this.center.getY() - y);
            return lo;
        }

        public Location createLocation(int index, double magnitude) {
            double angle = this.getAngle(index);
            double x = Math.cos(angle) * magnitude;
            double y = Math.sin(angle) * magnitude;
            return LocationImpl.create((double)(this.center.getX() + x), (double)(this.center.getY() - y));
        }

        public Bounds computeBounds(Bounds bo, double magnitude) {
            bo.set(this.center.getX() - magnitude, this.center.getY() - magnitude, magnitude * 2.0, magnitude * 2.0);
            return bo;
        }
    }
}

