/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jst.jsf.common.internal.JSPUtil;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.internal.CompositeTagRegistryFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.DesignerPaletteCustomizationsHelper;
import org.eclipse.jst.pagedesigner.editors.palette.IEntryChangeListener;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteConstants;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteContext;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteHelper;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaletteItemManager
implements IPaletteItemManager,
IPaletteConstants,
ITagRegistry.ITagRegistryListener {
    private static final boolean DEBUG = false;
    private static Map<CompositeTagRegistryFactory.TagRegistryIdentifier, PaletteItemManager> _managers = new HashMap<CompositeTagRegistryFactory.TagRegistryIdentifier, PaletteItemManager>();
    private static ReentrantLock MANAGER_LOCK = new ReentrantLock();
    private static long MANAGER_LOCK_TIMEOUT = 120L;
    private Set<IFile> _files = new HashSet<IFile>();
    private CompositeTagRegistryFactory.TagRegistryIdentifier _tagRegId;
    private List<PaletteDrawer> _paletteCategories = new ArrayList<PaletteDrawer>();
    private CopyOnWriteArrayList<IEntryChangeListener> _listeners = new CopyOnWriteArrayList();
    private AtomicBoolean IS_DISPOSED = new AtomicBoolean();
    private PaletteHelper _paletteHelper = new PaletteHelper(this);
    private ITagRegistry _tagRegistry;

    public static PaletteItemManager getInstance(IProject project) {
        if (project == null) {
            return PaletteItemManager.getInstance(PaletteItemManager.createPaletteContext(null));
        }
        return PaletteItemManager.getInstance(PaletteItemManager.createPaletteContext(project.getFile("dummy.jsp")));
    }

    public static PaletteItemManager getInstance(IPaletteContext paletteContext) {
        boolean hasLock = false;
        try {
            if (MANAGER_LOCK.tryLock(MANAGER_LOCK_TIMEOUT, TimeUnit.SECONDS)) {
                hasLock = true;
                CompositeTagRegistryFactory.TagRegistryIdentifier regId = PaletteItemManager.getTagRegistryIdentifier(paletteContext);
                PaletteItemManager manager = _managers.get(regId);
                if (manager == null) {
                    manager = new PaletteItemManager(regId);
                    _managers.put(regId, manager);
                    manager.init();
                }
                manager.addFile(paletteContext.getFile());
                PaletteItemManager paletteItemManager = manager;
                return paletteItemManager;
            }
            try {
                PDPlugin.log((IStatus)new Status(4, PDPlugin.getPluginId(), "(getInstance()) Failed to get managers lock for" + paletteContext.getFile().toString()));
            }
            catch (InterruptedException e) {
                PDPlugin.log("Failed in PaletteItemManager.getInstance(PaletteContext", e);
            }
        }
        finally {
            if (hasLock) {
                MANAGER_LOCK.unlock();
            }
        }
        return null;
    }

    private static CompositeTagRegistryFactory.TagRegistryIdentifier getTagRegistryIdentifier(IPaletteContext paletteContext) {
        IFile file = paletteContext.getFile();
        if (file != null) {
            IContentTypeManager typeManager = Platform.getContentTypeManager();
            IContentType contentType = typeManager.findContentTypeFor(file.getName());
            if (contentType != null) {
                return new CompositeTagRegistryFactory.TagRegistryIdentifier(file.getProject(), contentType);
            }
            return null;
        }
        return new CompositeTagRegistryFactory.TagRegistryIdentifier(null, org.eclipse.jst.pagedesigner.utils.JSPUtil.JSP_CONTENTTYPE);
    }

    public static IPaletteContext createPaletteContext(final IFile file) {
        return new IPaletteContext(){

            public IFile getFile() {
                return file;
            }

            public Object getAdapter(Class adapter) {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(IFile file) {
        Set<IFile> set = this._files;
        synchronized (set) {
            this._files.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(IPaletteContext paletteContext) {
        block14: {
            IFile file = paletteContext.getFile();
            boolean isEmpty = false;
            Set<IFile> set = this._files;
            synchronized (set) {
                if (this._files.contains(file)) {
                    this._files.remove(file);
                    if (this._files.isEmpty()) {
                        isEmpty = true;
                    }
                }
            }
            if (isEmpty && this.IS_DISPOSED.compareAndSet(false, true)) {
                PaletteItemManager.removeTagRegistryListeners(this);
                boolean hasLock = false;
                try {
                    try {
                        if (MANAGER_LOCK.tryLock(MANAGER_LOCK_TIMEOUT, TimeUnit.SECONDS)) {
                            hasLock = true;
                            _managers.remove(this._tagRegId);
                            break block14;
                        }
                        PDPlugin.log((IStatus)new Status(4, PDPlugin.getPluginId(), "(Release) Failed to get managers lock for" + paletteContext.getFile().toString()));
                    }
                    catch (InterruptedException e) {
                        PDPlugin.log("Failed to release paletteItemManager for" + paletteContext.getFile().toString(), e);
                        if (hasLock) {
                            MANAGER_LOCK.unlock();
                        }
                    }
                }
                finally {
                    if (hasLock) {
                        MANAGER_LOCK.unlock();
                    }
                }
            }
        }
    }

    private static void removeTagRegistryListeners(PaletteItemManager manager) {
        if (manager.getTagRegistry() != null) {
            manager.getTagRegistry().removeListener((ITagRegistry.ITagRegistryListener)manager);
        }
    }

    private ITagRegistry getTagRegistry() {
        return this._tagRegistry;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void clearPaletteItemManager() {
        hasLock = false;
        try {
            block9: {
                if (!PaletteItemManager.MANAGER_LOCK.tryLock(PaletteItemManager.MANAGER_LOCK_TIMEOUT, TimeUnit.SECONDS)) ** GOTO lbl9
                hasLock = true;
                if (PaletteItemManager._managers == null) {
                    return;
                }
                break block9;
lbl9:
                // 1 sources

                PDPlugin.log((IStatus)new Status(4, PDPlugin.getPluginId(), "(clear) Failed to get managers lock"));
                return;
            }
            var2_1 = PaletteItemManager._managers.values().iterator();
            if (true) ** GOTO lbl25
        }
        catch (InterruptedException e) {
            PDPlugin.log("Failed in clearPaletteItemManager", e);
            return;
        }
        finally {
            if (hasLock) {
                PaletteItemManager.MANAGER_LOCK.unlock();
            }
        }
        do {
            manager = var2_1.next();
            PaletteItemManager.removeTagRegistryListeners(manager);
            manager._files.clear();
lbl25:
            // 2 sources

        } while (var2_1.hasNext());
        PaletteItemManager._managers.clear();
    }

    private PaletteItemManager(CompositeTagRegistryFactory.TagRegistryIdentifier regId) {
        if (regId != null) {
            this._tagRegId = regId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllCategories() {
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            ArrayList<PaletteDrawer> readOnlyCategories = new ArrayList<PaletteDrawer>(this._paletteCategories);
            return Collections.unmodifiableList(readOnlyCategories);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void init() {
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            this._paletteCategories.clear();
        }
        this.initTagRegistry();
        DesignerPaletteCustomizationsHelper.loadUserCustomizations(this);
        this.sortCategories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortCategories() {
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            Collections.sort(this._paletteCategories, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String label1 = ((PaletteEntry)o1).getLabel();
                    String label2 = ((PaletteEntry)o2).getLabel();
                    return label1.compareTo(label2);
                }
            });
        }
    }

    public void reset() {
        this.init();
        this.fireModelChanged(null, null);
    }

    private void initTagRegistry() {
        this.registerHTMLCategory();
        if (this.isJSP(this._tagRegId)) {
            this.registerJSPCategory();
        }
        this.registerTagsFromTagRegistry();
    }

    private boolean isJSP(CompositeTagRegistryFactory.TagRegistryIdentifier tagRegistryId) {
        IContentType ct = tagRegistryId.getContentType();
        return JSPUtil.isJSPContentType((String)ct.getId());
    }

    private void registerTagsFromTagRegistry() {
        this._tagRegistry = this.getTagRegistry(this._tagRegId);
        if (this._tagRegistry != null) {
            for (Namespace ns : this._tagRegistry.getAllTagLibraries()) {
                this._paletteHelper.configPaletteItemsByNamespace(this, ns);
            }
        }
    }

    private ITagRegistry getTagRegistry(CompositeTagRegistryFactory.TagRegistryIdentifier regId) {
        ITagRegistry reg = null;
        if (regId.getProject() != null && (reg = CompositeTagRegistryFactory.getInstance().getRegistry(regId)) != null) {
            reg.addListener((ITagRegistry.ITagRegistryListener)this);
        }
        return reg;
    }

    private void registerHTMLCategory() {
        CMDocument doc = HTMLCMDocumentFactory.getCMDocument((String)"HTML");
        this._paletteHelper.getOrCreateTaglibPaletteDrawer(this, doc, "HTML");
    }

    private void registerJSPCategory() {
        CMDocument doc = HTMLCMDocumentFactory.getCMDocument((String)"JSP11");
        this._paletteHelper.getOrCreateTaglibPaletteDrawer(this, doc, "JSP11");
    }

    @Override
    public TaglibPaletteDrawer findOrCreateCategory(String id, String label) {
        TaglibPaletteDrawer category = this.getTaglibPalletteDrawer(id);
        if (category == null) {
            category = this.createTaglibPaletteDrawer(id, label);
        }
        return category;
    }

    public TaglibPaletteDrawer findCategoryByURI(String uri) {
        for (TaglibPaletteDrawer category : this.getAllCategories()) {
            if (!uri.equals(category.getURI())) continue;
            return category;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaglibPaletteDrawer createTaglibPaletteDrawer(String uri, String label) {
        TaglibPaletteDrawer r = new TaglibPaletteDrawer(uri, label);
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            this._paletteCategories.add(r);
        }
        return r;
    }

    @Override
    public TaglibPaletteDrawer getTaglibPalletteDrawer(String uri) {
        for (TaglibPaletteDrawer cat : this.getAllCategories()) {
            if (!uri.equalsIgnoreCase(cat.getId())) continue;
            return cat;
        }
        return null;
    }

    @Override
    public void addEntryChangeListener(IEntryChangeListener listener) {
        this._listeners.addIfAbsent(listener);
    }

    @Override
    public void removeEntryChangeListener(IEntryChangeListener listener) {
        this._listeners.remove(listener);
    }

    private void fireModelChanged(List oldDefinitions, List newDefinitions) {
        if (this._listeners == null) {
            return;
        }
        for (IEntryChangeListener listener : this._listeners) {
            listener.modelChanged(oldDefinitions, newDefinitions);
        }
    }

    public static void notifyPaletteItemManagersOfCustomizationsUpdate(IPaletteItemManager notifyingManager) {
        boolean hasLock = false;
        try {
            try {
                if (MANAGER_LOCK.tryLock(MANAGER_LOCK_TIMEOUT, TimeUnit.SECONDS)) {
                    hasLock = true;
                    for (PaletteItemManager mgr : _managers.values()) {
                        if (mgr == null || notifyingManager == mgr) continue;
                        mgr.reset();
                    }
                } else {
                    PDPlugin.log((IStatus)new Status(4, PDPlugin.getPluginId(), "Failed to get managers lock in notifyPaletteItemManagersOfCustomizationsUpdate"));
                }
            }
            catch (InterruptedException e) {
                PDPlugin.log("Failed in notifyPaletteItemManagersOfCustomizationsUpdate", e);
                if (hasLock) {
                    MANAGER_LOCK.unlock();
                }
            }
        }
        finally {
            if (hasLock) {
                MANAGER_LOCK.unlock();
            }
        }
    }

    public void registryChanged(ITagRegistry.TagRegistryChangeEvent event) {
        ITagRegistry.TagRegistryChangeEvent.EventType eventType = event.getType();
        switch (eventType) {
            case ADDED_NAMESPACE: {
                this.addNamespaces(event.getAffectedObjects());
                break;
            }
            case REMOVED_NAMESPACE: {
                this.removeNamespaces(event.getAffectedObjects());
                break;
            }
            case CHANGED_NAMESPACE: {
                this.changeNamespaces(event.getAffectedObjects());
                break;
            }
            case REGISTRY_DISPOSED: {
                break;
            }
        }
        DesignerPaletteCustomizationsHelper.loadUserCustomizations(this);
        this.sortCategories();
        this.fireModelChanged(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNamespaces(List<? extends Namespace> affectedObjects) {
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            for (Namespace namespace : affectedObjects) {
                this._paletteHelper.configPaletteItemsByNamespace(this, namespace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNamespaces(List<? extends Namespace> affectedObjects) {
        ArrayList<Integer> drawersToRemove = new ArrayList<Integer>();
        List<PaletteDrawer> list = this._paletteCategories;
        synchronized (list) {
            for (Namespace namespace : affectedObjects) {
                int i = this._paletteCategories.size() - 1;
                while (i >= 0) {
                    PaletteDrawer drawer = this._paletteCategories.get(i);
                    if (drawer.getId().equals(namespace.getNSUri())) {
                        drawersToRemove.add(new Integer(i));
                    }
                    --i;
                }
            }
            if (!drawersToRemove.isEmpty()) {
                Collections.sort(drawersToRemove, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        if (o1 > o2) {
                            return -1;
                        }
                        if (o1 < o2) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (Integer n : drawersToRemove) {
                    this._paletteCategories.remove(n);
                }
            }
        }
    }

    private void changeNamespaces(List<? extends Namespace> affectedObjects) {
        this.removeNamespaces(affectedObjects);
        this.addNamespaces(affectedObjects);
    }

    @Override
    public CompositeTagRegistryFactory.TagRegistryIdentifier getTagRegistryIdentifier() {
        return this._tagRegId;
    }

    public PaletteHelper getPaletteHelper() {
        return this._paletteHelper;
    }
}

