/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AttrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CommentType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CtrType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.DocType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.PIType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.TextType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDate;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInt;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSLong;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public abstract class NodeType
extends AnyType {
    protected static final String SCHEMA_TYPE_IDREF = "IDREF";
    protected static final String SCHEMA_TYPE_ID = "ID";
    private Node _node;

    public NodeType(Node node) {
        this._node = node;
    }

    public Node node_value() {
        return this._node;
    }

    public abstract ResultSequence typed_value();

    public abstract QName node_name();

    public ResultSequence nilled() {
        return ResultSequenceFactory.create_new();
    }

    public static NodeType dom_to_xpath(Node node) {
        assert (node != null);
        switch (node.getNodeType()) {
            case 1: {
                return new ElementType((Element)node);
            }
            case 8: {
                return new CommentType((Comment)node);
            }
            case 2: {
                return new AttrType((Attr)node);
            }
            case 3: {
                return new TextType((Text)node);
            }
            case 9: {
                return new DocType((Document)node);
            }
            case 7: {
                return new PIType((ProcessingInstruction)node);
            }
        }
        assert (false);
        return null;
    }

    public static ResultSequence eliminate_dups(ResultSequence rs) {
        Hashtable<Node, Boolean> added = new Hashtable<Node, Boolean>(rs.size());
        ListIterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            Node n = node.node_value();
            if (added.containsKey(n)) {
                i.remove();
                continue;
            }
            added.put(n, Boolean.TRUE);
        }
        return rs;
    }

    public static ResultSequence sort_document_order(ResultSequence rs) {
        ArrayList<NodeType> res = new ArrayList<NodeType>(rs.size());
        Iterator i = rs.iterator();
        while (i.hasNext()) {
            NodeType node = (NodeType)i.next();
            boolean added = false;
            int j = 0;
            while (j < res.size()) {
                NodeType x = (NodeType)res.get(j);
                if (NodeType.before(node, x)) {
                    res.add(j, node);
                    added = true;
                    break;
                }
                ++j;
            }
            if (added) continue;
            res.add(node);
        }
        rs = ResultSequenceFactory.create_new();
        for (NodeType node : res) {
            rs.add(node);
        }
        return rs;
    }

    public static boolean same(NodeType a, NodeType b) {
        return a.node_value().isSameNode(b.node_value());
    }

    public boolean before(NodeType two) {
        return NodeType.before(this, two);
    }

    public static boolean before(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) < 0;
    }

    public boolean after(NodeType two) {
        return NodeType.after(this, two);
    }

    public static boolean after(NodeType a, NodeType b) {
        return NodeType.compare_node(a, b) > 0;
    }

    private static int compare_node(NodeType a, NodeType b) {
        Document docB;
        Node nodeB;
        Node nodeA = a.node_value();
        if (nodeA == (nodeB = b.node_value()) || nodeA.isSameNode(nodeB)) {
            return 0;
        }
        Document docA = NodeType.getDocument(nodeA);
        if (docA != (docB = NodeType.getDocument(nodeB)) && !docA.isSameNode(docB)) {
            return NodeType.compareDocuments(docA, docB);
        }
        short relation = nodeA.compareDocumentPosition(nodeB);
        if ((relation & 2) != 0) {
            return 1;
        }
        if ((relation & 4) != 0) {
            return -1;
        }
        throw new RuntimeException("Unexpected result from node comparison: " + relation);
    }

    private static int compareDocuments(Document docA, Document docB) {
        if (docB.getDocumentURI() == null && docA.getDocumentURI() == null) {
            return 0;
        }
        return docB.getDocumentURI().compareTo(docA.getDocumentURI());
    }

    private static Document getDocument(Node nodeA) {
        return nodeA instanceof Document ? (Document)nodeA : nodeA.getOwnerDocument();
    }

    protected Object getTypedValueForPrimitiveType(XSTypeDefinition typeDef) {
        CtrType schemaTypeValue = null;
        if (typeDef == null) {
            return new XSUntypedAtomic(this.string_value());
        }
        String typeName = typeDef.getName();
        if ("date".equals(typeName)) {
            schemaTypeValue = XSDate.parse_date(this.string_value());
        } else if ("int".equals(typeName)) {
            schemaTypeValue = new XSInt(new BigInteger(this.string_value()));
        } else if ("long".equals(typeName)) {
            schemaTypeValue = new XSLong(new BigInteger(this.string_value()));
        } else if ("integer".equals(typeName)) {
            schemaTypeValue = new XSInteger(new BigInteger(this.string_value()));
        } else if ("double".equals(typeName)) {
            schemaTypeValue = new XSDouble(Double.parseDouble(this.string_value()));
        } else if ("float".equals(typeName)) {
            schemaTypeValue = new XSFloat(Float.parseFloat(this.string_value()));
        } else if ("decimal".equals(typeName)) {
            schemaTypeValue = new XSDecimal(new BigDecimal(this.string_value()));
        } else if ("dateTime".equals(typeName)) {
            schemaTypeValue = XSDateTime.parseDateTime(this.string_value());
        } else if ("time".equals(typeName)) {
            schemaTypeValue = XSTime.parse_time(this.string_value());
        } else if ("date".equals(typeName)) {
            schemaTypeValue = XSDate.parse_date(this.string_value());
        } else if ("boolean".equals(typeName)) {
            schemaTypeValue = new XSBoolean(Boolean.valueOf(this.string_value()));
        } else if ("NOTATION".equals(typeName)) {
            schemaTypeValue = new XSString(this.string_value());
        }
        return schemaTypeValue;
    }

    public abstract boolean isID();

    public abstract boolean isIDREF();

    protected boolean isType(TypeInfo typeInfo, String typeName) {
        String typeInfoName;
        return typeInfo != null && (typeInfoName = typeInfo.getTypeName()) != null && typeInfo.getTypeName().equalsIgnoreCase(typeName);
    }
}

