/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence.logging;

import java.util.Map;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.eclipselink.core.context.persistence.logging.Logger;
import org.eclipse.jpt.eclipselink.core.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.context.persistence.logging.LoggingLevel;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.EclipseLinkPersistenceUnitProperties;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkLogging
extends EclipseLinkPersistenceUnitProperties
implements Logging {
    private LoggingLevel level;
    private Boolean timestamp;
    private Boolean thread;
    private Boolean session;
    private Boolean exceptions;
    private String logFileLocation;
    private String logger;

    public EclipseLinkLogging(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.level = (LoggingLevel)this.getEnumValue("eclipselink.logging.level", LoggingLevel.values());
        this.timestamp = this.getBooleanValue("eclipselink.logging.timestamp");
        this.thread = this.getBooleanValue("eclipselink.logging.thread");
        this.session = this.getBooleanValue("eclipselink.logging.session");
        this.exceptions = this.getBooleanValue("eclipselink.logging.exceptions");
        this.logFileLocation = this.getStringValue("eclipselink.logging.file");
        this.logger = this.getLoggerProtertyValue();
    }

    private String getLoggerProtertyValue() {
        String value = this.getStringValue("eclipselink.logging.logger");
        if (value == null) {
            return null;
        }
        Logger standardLogger = (Logger)this.getEnumValue("eclipselink.logging.logger", Logger.values());
        return standardLogger == null ? value : EclipseLinkLogging.getPropertyStringValueOf((Object)((Object)standardLogger));
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("eclipselink.logging.level")) {
            this.levelChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.timestamp")) {
            this.timestampChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.thread")) {
            this.threadChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.session")) {
            this.sessionChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.exceptions")) {
            this.exceptionsChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.file")) {
            this.logFileLocationChanged(newValue);
        } else if (propertyName.equals("eclipselink.logging.logger")) {
            this.loggerChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("eclipselink.logging.level")) {
            this.levelChanged(null);
        } else if (propertyName.equals("eclipselink.logging.timestamp")) {
            this.timestampChanged(null);
        } else if (propertyName.equals("eclipselink.logging.thread")) {
            this.threadChanged(null);
        } else if (propertyName.equals("eclipselink.logging.session")) {
            this.sessionChanged(null);
        } else if (propertyName.equals("eclipselink.logging.exceptions")) {
            this.exceptionsChanged(null);
        } else if (propertyName.equals("eclipselink.logging.file")) {
            this.logFileLocationChanged(null);
        } else if (propertyName.equals("eclipselink.logging.logger")) {
            this.loggerChanged(null);
        }
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("eclipselink.logging.level", "level");
        propertyNames.put("eclipselink.logging.timestamp", "timestamp");
        propertyNames.put("eclipselink.logging.thread", "thread");
        propertyNames.put("eclipselink.logging.session", "session");
        propertyNames.put("eclipselink.logging.exceptions", "exceptions");
        propertyNames.put("eclipselink.logging.file", "logFileLocation");
        propertyNames.put("eclipselink.logging.logger", "logger");
    }

    @Override
    public LoggingLevel getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(LoggingLevel newLevel) {
        LoggingLevel old = this.level;
        this.level = newLevel;
        this.putProperty("level", (Object)newLevel);
        this.firePropertyChanged("level", (Object)old, (Object)newLevel);
    }

    private void levelChanged(String stringValue) {
        LoggingLevel newValue = (LoggingLevel)EclipseLinkLogging.getEnumValueOf((String)stringValue, (Enum[])LoggingLevel.values());
        LoggingLevel old = this.level;
        this.level = newValue;
        this.firePropertyChanged("level", (Object)old, (Object)newValue);
    }

    @Override
    public LoggingLevel getDefaultLevel() {
        return DEFAULT_LEVEL;
    }

    @Override
    public Boolean getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Boolean newTimestamp) {
        Boolean old = this.timestamp;
        this.timestamp = newTimestamp;
        this.putProperty("timestamp", newTimestamp);
        this.firePropertyChanged("timestamp", old, newTimestamp);
    }

    private void timestampChanged(String stringValue) {
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf((String)stringValue);
        Boolean old = this.timestamp;
        this.timestamp = newValue;
        this.firePropertyChanged("timestamp", old, newValue);
    }

    @Override
    public Boolean getDefaultTimestamp() {
        return DEFAULT_TIMESTAMP;
    }

    @Override
    public Boolean getThread() {
        return this.thread;
    }

    @Override
    public void setThread(Boolean newThread) {
        Boolean old = this.thread;
        this.thread = newThread;
        this.putProperty("thread", newThread);
        this.firePropertyChanged("thread", old, newThread);
    }

    private void threadChanged(String stringValue) {
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf((String)stringValue);
        Boolean old = this.thread;
        this.thread = newValue;
        this.firePropertyChanged("thread", old, newValue);
    }

    @Override
    public Boolean getDefaultThread() {
        return DEFAULT_THREAD;
    }

    @Override
    public Boolean getSession() {
        return this.session;
    }

    @Override
    public void setSession(Boolean newSession) {
        Boolean old = this.session;
        this.session = newSession;
        this.putProperty("session", newSession);
        this.firePropertyChanged("session", old, newSession);
    }

    private void sessionChanged(String stringValue) {
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf((String)stringValue);
        Boolean old = this.session;
        this.session = newValue;
        this.firePropertyChanged("session", old, newValue);
    }

    @Override
    public Boolean getDefaultSession() {
        return DEFAULT_SESSION;
    }

    @Override
    public Boolean getExceptions() {
        return this.exceptions;
    }

    @Override
    public void setExceptions(Boolean newExceptions) {
        Boolean old = this.exceptions;
        this.exceptions = newExceptions;
        this.putProperty("exceptions", newExceptions);
        this.firePropertyChanged("exceptions", old, newExceptions);
    }

    private void exceptionsChanged(String stringValue) {
        Boolean newValue = EclipseLinkLogging.getBooleanValueOf((String)stringValue);
        Boolean old = this.exceptions;
        this.exceptions = newValue;
        this.firePropertyChanged("exceptions", old, newValue);
    }

    @Override
    public Boolean getDefaultExceptions() {
        return DEFAULT_EXCEPTIONS;
    }

    @Override
    public String getLogFileLocation() {
        return this.logFileLocation;
    }

    @Override
    public void setLogFileLocation(String newLogFileLocation) {
        String old = this.logFileLocation;
        this.logFileLocation = StringTools.stringIsNotEmpty((String)newLogFileLocation) ? newLogFileLocation : this.getDefaultLogFileLocation();
        this.putProperty("logFileLocation", this.logFileLocation);
        this.firePropertyChanged("logFileLocation", old, this.logFileLocation);
    }

    private void logFileLocationChanged(String newValue) {
        String old = this.logFileLocation;
        this.logFileLocation = newValue;
        this.firePropertyChanged("logFileLocation", old, newValue);
    }

    @Override
    public String getDefaultLogFileLocation() {
        return DEFAULT_LOG_FILE_LOCATION;
    }

    @Override
    public String getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger newLogger) {
        if (newLogger == null) {
            this.setLogger_(null);
            return;
        }
        this.setLogger_(EclipseLinkLogging.getPropertyStringValueOf((Object)((Object)newLogger)));
    }

    @Override
    public void setLogger(String newLogger) {
        if (newLogger == null) {
            this.setLogger_(null);
            return;
        }
        Logger l = Logger.getLoggerFor(newLogger);
        if (l == null) {
            this.setLogger_(newLogger);
        } else {
            this.setLogger(l);
        }
    }

    private void setLogger_(String newLogger) {
        String old = this.logger;
        this.logger = newLogger;
        this.putProperty("logger", newLogger);
        this.firePropertyChanged("logger", old, newLogger);
    }

    private void loggerChanged(String newValue) {
        String old = this.logger;
        this.logger = newValue;
        this.firePropertyChanged("logger", old, newValue);
    }

    @Override
    public String getDefaultLogger() {
        return DEFAULT_LOGGER;
    }
}

