/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.context.persistence.AbstractPersistenceUnit;
import org.eclipse.jpt.core.internal.jpa1.context.persistence.ImpliedMappingFileRef;
import org.eclipse.jpt.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.eclipselink.core.context.persistence.EclipseLinkPersistenceXmlContextNodeFactory;
import org.eclipse.jpt.eclipselink.core.context.persistence.caching.Caching;
import org.eclipse.jpt.eclipselink.core.context.persistence.connection.Connection;
import org.eclipse.jpt.eclipselink.core.context.persistence.customization.Customization;
import org.eclipse.jpt.eclipselink.core.context.persistence.general.GeneralProperties;
import org.eclipse.jpt.eclipselink.core.context.persistence.logging.Logging;
import org.eclipse.jpt.eclipselink.core.context.persistence.options.Options;
import org.eclipse.jpt.eclipselink.core.context.persistence.schema.generation.SchemaGeneration;
import org.eclipse.jpt.eclipselink.core.internal.DefaultEclipseLinkJpaValidationMessages;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.caching.EclipseLinkCaching;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.customization.EclipseLinkCustomization;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.general.EclipseLinkGeneralProperties;
import org.eclipse.jpt.eclipselink.core.internal.context.persistence.schema.generation.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkPersistenceUnit
extends AbstractPersistenceUnit {
    protected MappingFileRef impliedEclipseLinkMappingFileRef;
    private GeneralProperties generalProperties;
    private Customization customization;
    private Caching caching;
    private Logging logging;
    private SchemaGeneration schemaGeneration;
    protected final List<EclipseLinkConverter> converters = new ArrayList<EclipseLinkConverter>();
    public static final String IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY = "impliedEclipseLinkMappingFileRef";
    public static final String CONVERTERS_LIST = "converters";

    public EclipseLinkPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent, xmlPersistenceUnit);
    }

    public EclipseLinkPersistenceXmlContextNodeFactory getContextNodeFactory() {
        return (EclipseLinkPersistenceXmlContextNodeFactory)super.getContextNodeFactory();
    }

    protected void initializeProperties() {
        super.initializeProperties();
        this.generalProperties = this.buildEclipseLinkGeneralProperties();
        this.customization = this.buildEclipseLinkCustomization();
        this.caching = this.buildEclipseLinkCaching();
        this.logging = this.buildEclipseLinkLogging();
        this.schemaGeneration = this.buildEclipseLinkSchemaGeneration();
    }

    protected void addNonUpdateAspectNamesTo(Set<String> nonUpdateAspectNames) {
        super.addNonUpdateAspectNamesTo(nonUpdateAspectNames);
        nonUpdateAspectNames.add(CONVERTERS_LIST);
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        super.propertyValueChanged(propertyName, newValue);
        this.generalProperties.propertyValueChanged(propertyName, newValue);
        this.customization.propertyValueChanged(propertyName, newValue);
        this.caching.propertyValueChanged(propertyName, newValue);
        this.logging.propertyValueChanged(propertyName, newValue);
        this.schemaGeneration.propertyValueChanged(propertyName, newValue);
    }

    public void propertyRemoved(String propertyName) {
        super.propertyRemoved(propertyName);
        this.generalProperties.propertyRemoved(propertyName);
        this.customization.propertyRemoved(propertyName);
        this.caching.propertyRemoved(propertyName);
        this.logging.propertyRemoved(propertyName);
        this.schemaGeneration.propertyRemoved(propertyName);
    }

    protected SharedCacheMode buildDefaultSharedCacheMode() {
        return SharedCacheMode.DISABLE_SELECTIVE;
    }

    public boolean calculateDefaultCacheable() {
        switch (this.getSharedCacheMode()) {
            case NONE: 
            case ENABLE_SELECTIVE: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return true;
            }
        }
        return true;
    }

    protected ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedEclipseLinkMappingFileRef == null ? super.getMappingFileRefs() : this.getCombinedEclipseLinkMappingFileRefs();
    }

    protected ListIterable<MappingFileRef> getCombinedEclipseLinkMappingFileRefs() {
        return new CompositeListIterable(super.getMappingFileRefs(), (Object)this.impliedEclipseLinkMappingFileRef);
    }

    public int mappingFileRefsSize() {
        return this.impliedEclipseLinkMappingFileRef == null ? super.mappingFileRefsSize() : this.combinedEclipseLinkMappingFileRefsSize();
    }

    protected int combinedEclipseLinkMappingFileRefsSize() {
        return super.mappingFileRefsSize() + 1;
    }

    public MappingFileRef getImpliedEclipseLinkMappingFileRef() {
        return this.impliedEclipseLinkMappingFileRef;
    }

    protected MappingFileRef setImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef != null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already set.");
        }
        ImpliedMappingFileRef mappingFileRef = this.buildEclipseLinkImpliedMappingFileRef();
        this.impliedEclipseLinkMappingFileRef = mappingFileRef;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, null, mappingFileRef);
        return mappingFileRef;
    }

    protected void unsetImpliedEclipseLinkMappingFileRef() {
        if (this.impliedEclipseLinkMappingFileRef == null) {
            throw new IllegalStateException("The implied eclipselink mapping file ref is already unset.");
        }
        MappingFileRef mappingFileRef = this.impliedEclipseLinkMappingFileRef;
        this.impliedEclipseLinkMappingFileRef.dispose();
        this.impliedEclipseLinkMappingFileRef = null;
        this.firePropertyChanged(IMPLIED_ECLIPSELINK_MAPPING_FILE_REF_PROPERTY, mappingFileRef, null);
    }

    protected GeneralProperties buildEclipseLinkGeneralProperties() {
        return new EclipseLinkGeneralProperties((PersistenceUnit)this);
    }

    protected Connection buildEclipseLinkConnection() {
        return (Connection)this.getContextNodeFactory().buildConnection((PersistenceUnit)this);
    }

    protected Customization buildEclipseLinkCustomization() {
        return new EclipseLinkCustomization((PersistenceUnit)this);
    }

    protected Caching buildEclipseLinkCaching() {
        return new EclipseLinkCaching((PersistenceUnit)this);
    }

    protected Logging buildEclipseLinkLogging() {
        return (Logging)this.getContextNodeFactory().buildLogging((PersistenceUnit)this);
    }

    protected Options buildEclipseLinkOptions() {
        return (Options)this.getContextNodeFactory().buildOptions((PersistenceUnit)this);
    }

    protected SchemaGeneration buildEclipseLinkSchemaGeneration() {
        return new EclipseLinkSchemaGeneration((PersistenceUnit)this);
    }

    public GeneralProperties getGeneralProperties() {
        return this.generalProperties;
    }

    public Connection getConnection() {
        return (Connection)super.getConnection();
    }

    public Customization getCustomization() {
        return this.customization;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public Options getOptions() {
        return (Options)super.getOptions();
    }

    public SchemaGeneration getSchemaGeneration() {
        return this.schemaGeneration;
    }

    public void addConverter(EclipseLinkConverter converter) {
        this.converters.add(converter);
    }

    public ListIterator<EclipseLinkConverter> allConverters() {
        return new CloneListIterator(this.converters);
    }

    public int convertersSize() {
        return this.converters.size();
    }

    public String[] uniqueConverterNames() {
        HashSet names = CollectionTools.set(this.allNonNullConverterNames());
        return names.toArray(new String[names.size()]);
    }

    protected Iterator<String> allNonNullConverterNames() {
        return new FilteringIterator<String>(this.allConverterNames()){

            protected boolean accept(String converterName) {
                return converterName != null;
            }
        };
    }

    protected Iterator<String> allConverterNames() {
        return new TransformationIterator<EclipseLinkConverter, String>(this.allConverters()){

            protected String transform(EclipseLinkConverter converter) {
                return converter.getName();
            }
        };
    }

    public void update(XmlPersistenceUnit persistenceUnit) {
        this.converters.clear();
        super.update(persistenceUnit);
        this.convertersUpdated();
    }

    public void postUpdate() {
        super.postUpdate();
        if (this.impliedEclipseLinkMappingFileRef != null) {
            this.impliedEclipseLinkMappingFileRef.postUpdate();
        }
    }

    protected void initializeMappingFileRefs() {
        super.initializeMappingFileRefs();
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            this.impliedEclipseLinkMappingFileRef = this.buildEclipseLinkImpliedMappingFileRef();
        }
    }

    private ImpliedMappingFileRef buildEclipseLinkImpliedMappingFileRef() {
        return new ImpliedMappingFileRef((PersistenceUnit)this, "META-INF/eclipselink-orm.xml");
    }

    protected void updateMappingFileRefs() {
        super.updateMappingFileRefs();
        if (!this.impliedEclipseLinkMappingFileIsExcluded() && !this.impliedEclipseLinkMappingFileIsSpecified() && this.impliedEclipseLinkMappingFileExists()) {
            if (this.impliedEclipseLinkMappingFileRef == null) {
                this.setImpliedEclipseLinkMappingFileRef();
            }
            this.getImpliedEclipseLinkMappingFileRef().update(null);
        } else if (this.impliedEclipseLinkMappingFileRef != null) {
            this.unsetImpliedEclipseLinkMappingFileRef();
        }
    }

    protected boolean impliedEclipseLinkMappingFileIsExcluded() {
        return this.getGeneralProperties().getExcludeEclipselinkOrm() == Boolean.TRUE;
    }

    protected boolean impliedEclipseLinkMappingFileIsSpecified() {
        String impliedMappingFile = "META-INF/eclipselink-orm.xml";
        ListIterator stream = this.specifiedMappingFileRefs();
        while (stream.hasNext()) {
            if (!impliedMappingFile.equals(((MappingFileRef)stream.next()).getFileName())) continue;
            return true;
        }
        return false;
    }

    public EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    protected boolean impliedEclipseLinkMappingFileExists() {
        return this.getJpaProject().getDefaultEclipseLinkOrmXmlResource() != null;
    }

    protected void convertersUpdated() {
        this.fireListChanged(CONVERTERS_LIST, this.converters);
    }

    protected void validateProperties(List<IMessage> messages, IReporter reporter) {
        if (this.isJpa2_0Compatible()) {
            for (PersistenceUnit.Property property : this.getLegacyEntityCachingProperties()) {
                messages.add(DefaultEclipseLinkJpaValidationMessages.buildMessage(2, "PERSISTENCE_UNIT_LEGACY_ENTITY_CACHING", new String[]{property.getName()}, this.getPersistenceUnit(), property.getValidationTextRange()));
            }
        }
    }

    protected ArrayList<PersistenceUnit.Property> getLegacyEntityCachingProperties() {
        ArrayList<PersistenceUnit.Property> result = new ArrayList<PersistenceUnit.Property>();
        CollectionTools.addAll(result, this.getSharedCacheProperties());
        CollectionTools.addAll(result, this.getEntityCacheTypeProperties());
        CollectionTools.addAll(result, this.getEntityCacheSizeProperties());
        return result;
    }

    private Iterable<PersistenceUnit.Property> getSharedCacheProperties() {
        return CollectionTools.iterable((Iterator)this.propertiesWithNamePrefix("eclipselink.cache.shared."));
    }

    private Iterable<PersistenceUnit.Property> getEntityCacheSizeProperties() {
        return this.getEntityPropertiesWithPrefix("eclipselink.cache.size.");
    }

    private Iterable<PersistenceUnit.Property> getEntityCacheTypeProperties() {
        return this.getEntityPropertiesWithPrefix("eclipselink.cache.type.");
    }

    private Iterable<PersistenceUnit.Property> getEntityPropertiesWithPrefix(String prefix) {
        return new FilteringIterable<PersistenceUnit.Property>(CollectionTools.iterable((Iterator)this.propertiesWithNamePrefix(prefix))){

            protected boolean accept(PersistenceUnit.Property next) {
                return !next.getName().endsWith("default");
            }
        };
    }
}

