/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.config.wpml;

import java.util.Locale;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.eclipse.birt.report.engine.emitter.config.AbstractConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.AbstractEmitterDescriptor;
import org.eclipse.birt.report.engine.emitter.config.ConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOption;
import org.eclipse.birt.report.engine.emitter.config.IConfigurableOptionObserver;
import org.eclipse.birt.report.engine.emitter.config.IOptionValue;
import org.eclipse.birt.report.engine.emitter.config.wpml.i18n.Messages;

public class WordEmitterDescriptor
extends AbstractEmitterDescriptor {
    protected static final String CHART_DPI = "ChartDpi";
    protected IConfigurableOption[] options;
    private Locale locale;

    public WordEmitterDescriptor() {
        this.initOptions();
    }

    public void setLocale(Locale locale) {
        if (this.locale != locale) {
            this.locale = locale;
            this.initOptions();
        }
    }

    private void initOptions() {
        ConfigurableOption chartDpi = new ConfigurableOption(CHART_DPI);
        chartDpi.setDisplayName(this.getMessage("OptionDisplayValue.ChartDpi"));
        chartDpi.setDataType(IConfigurableOption.DataType.INTEGER);
        chartDpi.setDisplayType(IConfigurableOption.DisplayType.TEXT);
        chartDpi.setDefaultValue((Object)new Integer(192));
        chartDpi.setToolTip("The DPI which chart engine uses to generate charts. For example, 192.");
        chartDpi.setDescription(this.getMessage("OptionDescription.ChartDpi"));
        this.options = new IConfigurableOption[]{chartDpi};
    }

    private String getMessage(String key) {
        return Messages.getString(key, this.locale);
    }

    public IConfigurableOptionObserver createOptionObserver() {
        return new WordOptionObserver();
    }

    public String getDescription() {
        return this.getMessage("WordEmitter.Description");
    }

    public String getDisplayName() {
        return this.getMessage("WordEmitter.DisplayName");
    }

    public String getID() {
        return "org.eclipse.birt.report.engine.emitter.word";
    }

    public String getRenderOptionName(String name) {
        assert (name != null);
        if (CHART_DPI.equals(name)) {
            return CHART_DPI;
        }
        return name;
    }

    class WordOptionObserver
    extends AbstractConfigurableOptionObserver {
        WordOptionObserver() {
        }

        public IConfigurableOption[] getOptions() {
            return WordEmitterDescriptor.this.options;
        }

        public IRenderOption getPreferredRenderOption() {
            RenderOption renderOption = new RenderOption();
            renderOption.setEmitterID(WordEmitterDescriptor.this.getID());
            renderOption.setOutputFormat("doc");
            if (this.values != null && this.values.length > 0) {
                IOptionValue[] iOptionValueArray = this.values;
                int n = this.values.length;
                int n2 = 0;
                while (n2 < n) {
                    IOptionValue optionValue = iOptionValueArray[n2];
                    if (optionValue != null) {
                        renderOption.setOption(WordEmitterDescriptor.this.getRenderOptionName(optionValue.getName()), optionValue.getValue());
                    }
                    ++n2;
                }
            }
            return renderOption;
        }
    }
}

