/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeNode;
import org.eclipse.birt.core.btree.BTreeValue;
import org.eclipse.birt.core.btree.IndexEntry;
import org.eclipse.birt.core.btree.LeafEntry;
import org.eclipse.birt.core.btree.LeafNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexNode<K, V>
extends BTreeNode<K, V> {
    static final int EMPTY_NODE_SIZE = 20;
    private int nodeSize = 20;
    private int prevNodeId = -1;
    private int nextNodeId = -1;
    private int entryCount = 0;
    private int firstChild = -1;
    private IndexEntry<K, V> firstEntry;
    private IndexEntry<K, V> lastEntry;

    IndexNode(BTree<K, V> btree, int nodeId) {
        super(btree, 1, nodeId);
    }

    public int getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(int firstChild) {
        this.firstChild = firstChild;
    }

    public int getPrevNodeId() {
        return this.prevNodeId;
    }

    public void setPrevNodeId(int prevNodeId) {
        this.prevNodeId = prevNodeId;
    }

    public int getNextNodeId() {
        return this.nextNodeId;
    }

    public void setNextNodeId(int nextNodeId) {
        this.nextNodeId = nextNodeId;
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public IndexEntry<K, V> getFirstEntry() {
        return this.firstEntry;
    }

    public IndexEntry<K, V> getLastEntry() {
        return this.lastEntry;
    }

    public LeafEntry<K, V> find(BTreeValue<K> key) throws IOException {
        int childNodeId = this.findChildNode(key);
        if (childNodeId != -1) {
            BTreeNode node = this.btree.loadBTreeNode(childNodeId);
            try {
                if (node.nodeType == 1) {
                    LeafEntry<K, V> leafEntry = ((IndexNode)node).find(key);
                    return leafEntry;
                }
                if (node.nodeType == 2) {
                    LeafEntry leafEntry = ((LeafNode)node).find(key);
                    return leafEntry;
                }
                throw new IOException("unsupport node type" + node.nodeType);
            }
            finally {
                node.unlock();
            }
        }
        return null;
    }

    private int findChildNode(BTreeValue<K> key) throws IOException {
        int childNodeId = this.firstChild;
        IndexEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            int result = this.btree.compare(entry.getKey(), key);
            if (result == 0) {
                childNodeId = entry.childNodeId;
                break;
            }
            if (result > 0) break;
            childNodeId = entry.childNodeId;
            entry = entry.next;
        }
        return childNodeId;
    }

    public LeafEntry<K, V> insert(BTreeValue<K> key, BTreeValue<V> value) throws IOException {
        int childNodeId = this.findChildNode(key);
        if (childNodeId != -1) {
            BTreeNode node = this.btree.loadBTreeNode(childNodeId);
            try {
                if (node.nodeType == 1) {
                    IndexEntry<K, V> splitEntry;
                    IndexNode indexNode = (IndexNode)node;
                    LeafEntry<K, V> insertEntry = indexNode.insert(key, value);
                    if (indexNode.needSplit() && (splitEntry = indexNode.split()) != null) {
                        this.insertIndex(splitEntry.getKey(), splitEntry.getChildNodeId());
                    }
                    LeafEntry<K, V> leafEntry = insertEntry;
                    return leafEntry;
                }
                if (node.nodeType == 2) {
                    IndexEntry splitEntry;
                    LeafNode leafNode = (LeafNode)node;
                    LeafEntry<K, V> insertEntry = leafNode.insert(key, value);
                    if (leafNode.needSplit() && (splitEntry = leafNode.split()) != null) {
                        this.insertIndex(splitEntry.getKey(), splitEntry.getChildNodeId());
                    }
                    LeafEntry<K, V> leafEntry = insertEntry;
                    return leafEntry;
                }
                throw new IOException("unsupport node type" + node.nodeType + " for node " + childNodeId);
            }
            finally {
                node.unlock();
            }
        }
        return null;
    }

    private void insertBefore(IndexEntry<K, V> insertPoint, IndexEntry<K, V> entry) {
        entry.setNode(this);
        if (insertPoint == null) {
            if (this.lastEntry == null) {
                entry.setPrev(null);
                entry.setNext(null);
                this.firstEntry = entry;
                this.lastEntry = entry;
            } else {
                entry.setPrev(this.lastEntry);
                entry.setNext(null);
                this.lastEntry.setNext(entry);
                this.lastEntry = entry;
            }
        } else {
            IndexEntry prev = insertPoint.getPrev();
            entry.setNext(insertPoint);
            entry.setPrev(prev);
            insertPoint.setPrev(entry);
            if (prev != null) {
                prev.setNext(entry);
            } else {
                this.firstEntry = entry;
            }
        }
        this.nodeSize += this.getEntrySize(entry);
        ++this.entryCount;
    }

    protected void insertIndex(BTreeValue<K> insertKey, int childNodeId) throws IOException {
        IndexEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            int result = this.btree.compare(entry.getKey(), insertKey);
            if (result == 0) {
                throw new IOException("unexpected equal keys");
            }
            if (result > 0) break;
            entry = entry.next;
        }
        IndexEntry newEntry = new IndexEntry(this, insertKey, childNodeId);
        this.insertBefore(entry, newEntry);
        this.dirty = true;
    }

    public boolean needSplit() {
        return this.nodeSize > 4092 && this.entryCount > 13;
    }

    public IndexEntry<K, V> split() throws IOException {
        this.entryCount /= 2;
        this.nodeSize = 20;
        IndexEntry<K, V> splitEntry = this.firstEntry;
        int i = 0;
        while (i < this.entryCount) {
            this.nodeSize += this.getEntrySize(splitEntry);
            splitEntry = splitEntry.getNext();
            ++i;
        }
        this.lastEntry = splitEntry.getPrev();
        this.lastEntry.setNext(null);
        IndexNode newNode = this.btree.createIndexNode();
        try {
            newNode.setFirstChild(splitEntry.childNodeId);
            IndexEntry entry = splitEntry.getNext();
            while (entry != null) {
                IndexEntry<K, V> nextEntry = entry.getNext();
                entry.setPrev(null);
                entry.setNext(null);
                super.insertBefore(null, entry);
                entry = nextEntry;
            }
            newNode.setPrevNodeId(this.nodeId);
            newNode.setNextNodeId(this.nextNodeId);
            if (this.nextNodeId != -1) {
                IndexNode nextNode = this.btree.loadIndexNode(this.nextNodeId);
                try {
                    nextNode.setPrevNodeId(newNode.getNodeId());
                    nextNode.setDirty(true);
                }
                finally {
                    nextNode.unlock();
                }
            }
            this.nextNodeId = newNode.getNodeId();
            IndexEntry indexEntry = new IndexEntry(this, splitEntry.getKey(), newNode.getNodeId());
            return indexEntry;
        }
        finally {
            newNode.unlock();
        }
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.nodeSize = in.readInt();
        this.prevNodeId = in.readInt();
        this.nextNodeId = in.readInt();
        this.entryCount = in.readInt();
        this.firstChild = in.readInt();
        int i = 0;
        while (i < this.entryCount) {
            IndexEntry<K, V> entry = this.readEntry(in);
            if (this.firstEntry == null) {
                this.firstEntry = entry;
                this.lastEntry = entry;
            } else {
                this.lastEntry.setNext(entry);
                entry.setPrev(this.lastEntry);
                this.lastEntry = entry;
            }
            ++i;
        }
    }

    @Override
    protected void write(DataOutput out) throws IOException {
        out.writeInt(this.nodeSize);
        out.writeInt(this.prevNodeId);
        out.writeInt(this.nextNodeId);
        out.writeInt(this.entryCount);
        out.writeInt(this.firstChild);
        IndexEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            this.writeEntry(out, entry);
            entry = entry.getNext();
        }
    }

    private IndexEntry<K, V> readEntry(DataInput in) throws IOException {
        BTreeValue key = this.btree.readKey(in);
        int childNodeId = in.readInt();
        return new IndexEntry(this, key, childNodeId);
    }

    private void writeEntry(DataOutput out, IndexEntry<K, V> entry) throws IOException {
        this.btree.writeKey(out, entry.getKey());
        out.writeInt(entry.getChildNodeId());
    }

    private int getEntrySize(IndexEntry<K, V> entry) {
        return 4 + this.btree.getKeySize(entry.getKey());
    }

    @Override
    public void dumpNode() throws IOException {
        System.out.println("INDEX:" + this.nodeId);
        System.out.println("nodeSize:" + this.nodeSize);
        System.out.println("prevNodeId:" + this.prevNodeId);
        System.out.println("nextNodeId :" + this.nextNodeId);
        System.out.println("entryCount:" + this.entryCount);
        System.out.print(this.firstChild);
        IndexEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            System.out.print("<<[");
            System.out.print(this.btree.getKey(entry.getKey()));
            System.out.print("]<<");
            System.out.print(entry.getChildNodeId());
            entry = entry.getNext();
        }
        System.out.println();
    }

    @Override
    public void dumpAll() throws IOException {
        this.dumpNode();
        BTreeNode node = this.btree.loadBTreeNode(this.firstChild);
        try {
            node.dumpAll();
        }
        finally {
            node.unlock();
        }
        IndexEntry<K, V> entry = this.firstEntry;
        while (entry != null) {
            node = this.btree.loadBTreeNode(entry.getChildNodeId());
            try {
                node.dumpAll();
            }
            finally {
                node.unlock();
            }
            entry = entry.getNext();
        }
    }
}

