/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegionList;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.XMLGeneratorImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifier;
import org.eclipse.wst.xml.core.internal.document.XMLModelNotifierImpl;
import org.eclipse.wst.xml.core.internal.document.XMLModelParser;
import org.eclipse.wst.xml.core.internal.document.XMLModelUpdater;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMModelImpl
extends AbstractStructuredModel
implements IStructuredDocumentListener,
IDOMModel,
DOMImplementation {
    private static String TRACE_PARSER_MANAGEMENT_EXCEPTION = "parserManagement";
    private Object active = null;
    private DocumentImpl document = (DocumentImpl)this.internalCreateDocument();
    private ISourceGenerator generator = null;
    private XMLModelNotifier notifier = null;
    private XMLModelParser parser = null;
    private boolean refresh = false;
    private XMLModelUpdater updater = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void aboutToChangeModel() {
        super.aboutToChangeModel();
        this.getModelNotifier().beginChanging();
    }

    public void aboutToReinitializeModel() {
        XMLModelNotifier notifier = this.getModelNotifier();
        notifier.cancelPending();
        super.aboutToReinitializeModel();
    }

    protected void attrReplaced(Element element, Attr newAttr, Attr oldAttr) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceAttr(element, newAttr, oldAttr);
            this.setActive(null);
        }
        this.getModelNotifier().attrReplaced(element, newAttr, oldAttr);
    }

    public void changedModel() {
        if (this.isModelChangeStateOnVergeOfEnding()) {
            this.endLock();
            this.fLockObject = null;
            this.getModelNotifier().endChanging();
        }
        super.changedModel();
        this.handleRefresh();
    }

    protected void childReplaced(Node parentNode, Node newChild, Node oldChild) {
        if (parentNode == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.replaceChild(parentNode, newChild, oldChild);
            this.setActive(null);
        }
        this.getModelNotifier().childReplaced(parentNode, newChild, oldChild);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        return null;
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) throws DOMException {
        DocumentTypeImpl documentType = new DocumentTypeImpl();
        documentType.setName(qualifiedName);
        documentType.setPublicId(publicId);
        documentType.setSystemId(systemId);
        return documentType;
    }

    protected void documentTypeChanged() {
        if (this.refresh) {
            return;
        }
        if (this.active != null || this.getModelNotifier().isChanging()) {
            return;
        }
        this.handleRefresh();
    }

    protected void editableChanged(Node node) {
        if (node != null) {
            this.getModelNotifier().editableChanged(node);
        }
    }

    protected void endTagChanged(Element element) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeEndTag(element);
            this.setActive(null);
        }
        this.getModelNotifier().endTagChanged(element);
    }

    private XMLModelParser getActiveParser() {
        if (this.parser == null) {
            return null;
        }
        if (this.parser != this.active) {
            return null;
        }
        return this.parser;
    }

    private XMLModelUpdater getActiveUpdater() {
        if (this.updater == null) {
            return null;
        }
        if (this.updater != this.active) {
            return null;
        }
        return this.updater;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.w3c.dom.Document");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return this.getDocument();
        }
        return super.getAdapter(adapter);
    }

    public IDOMDocument getDocument() {
        return this.document;
    }

    public ISourceGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = XMLGeneratorImpl.getInstance();
        }
        return this.generator;
    }

    public IndexedRegion getIndexedRegion(int offset) {
        if (this.document == null) {
            return null;
        }
        IDOMNode parent = null;
        int length = this.document.getEndOffset();
        if (offset * 2 < length) {
            IDOMNode child = (IDOMNode)this.document.getFirstChild();
            while (child != null) {
                if (child.getEndOffset() <= offset) {
                    child = (IDOMNode)child.getNextSibling();
                    continue;
                }
                if (child.getStartOffset() <= offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        return child;
                    }
                    parent = child;
                    child = (IDOMNode)parent.getFirstChild();
                    continue;
                }
                break;
            }
        } else {
            IDOMNode child = (IDOMNode)this.document.getLastChild();
            while (child != null) {
                if (child.getStartOffset() > offset) {
                    child = (IDOMNode)child.getPreviousSibling();
                    continue;
                }
                if (child.getEndOffset() > offset) {
                    IStructuredDocumentRegion startStructuredDocumentRegion = child.getStartStructuredDocumentRegion();
                    if (startStructuredDocumentRegion != null && startStructuredDocumentRegion.getEnd() > offset) {
                        return child;
                    }
                    IStructuredDocumentRegion endStructuredDocumentRegion = child.getEndStructuredDocumentRegion();
                    if (endStructuredDocumentRegion != null && endStructuredDocumentRegion.getStart() <= offset) {
                        return child;
                    }
                    parent = child;
                    child = (IDOMNode)parent.getLastChild();
                    continue;
                }
                break;
            }
        }
        return parent;
    }

    public XMLModelNotifier getModelNotifier() {
        if (this.notifier == null) {
            this.notifier = new XMLModelNotifierImpl();
        }
        return this.notifier;
    }

    private XMLModelParser getModelParser() {
        if (this.parser == null) {
            this.parser = this.createModelParser();
        }
        return this.parser;
    }

    protected XMLModelParser createModelParser() {
        return new XMLModelParser(this);
    }

    private XMLModelUpdater getModelUpdater() {
        if (this.updater == null) {
            this.updater = this.createModelUpdater();
        }
        return this.updater;
    }

    protected XMLModelUpdater createModelUpdater() {
        return new XMLModelUpdater(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleRefresh() {
        if (!this.refresh) {
            return;
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging(true);
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                parser.replaceStructuredDocumentRegions(this.getStructuredDocument().getRegionList(), null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
            }
            this.refresh = false;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.setActive(null);
            if (!isChanging) {
                notifier.endChanging();
            }
            this.refresh = false;
            return;
        }
    }

    public boolean hasFeature(String feature, String version) {
        if (feature == null) {
            return false;
        }
        if (version != null && !version.equals("1.0") && !version.equals("2.0")) {
            return false;
        }
        if (feature.equalsIgnoreCase("Core")) {
            return true;
        }
        return feature.equalsIgnoreCase("XML");
    }

    protected Document internalCreateDocument() {
        DocumentImpl document = new DocumentImpl();
        document.setModel(this);
        return document;
    }

    boolean isReparsing() {
        return this.active != null;
    }

    protected void nameChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeName(node);
            this.setActive(null);
        }
    }

    public void newModel(NewDocumentEvent structuredDocumentEvent) {
        if (structuredDocumentEvent == null) {
            return;
        }
        IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (this.fStructuredDocument != null && this.fStructuredDocument != structuredDocument) {
            this.setStructuredDocument(structuredDocument);
        }
        this.internalSetNewDocument(structuredDocument);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalSetNewDocument(IStructuredDocument structuredDocument) {
        if (structuredDocument == null) {
            return;
        }
        IStructuredDocumentRegionList flatNodes = structuredDocument.getRegionList();
        if (flatNodes == null) return;
        if (flatNodes.getLength() == 0) {
            return;
        }
        if (this.document == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(flatNodes, null);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.setActive(null);
                throw throwable;
            }
            {
                Object var5_9 = null;
                this.setActive(null);
                return;
            }
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        this.getModelNotifier().beginChanging(true);
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        this.document.removeChildNodes();
        try {
            try {
                parser.replaceStructuredDocumentRegions(flatNodes, null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.setActive(null);
            if (!isChanging) {
                this.getModelNotifier().endChanging();
            }
            this.refresh = false;
            throw throwable;
        }
        {
            Object var8_14 = null;
            this.setActive(null);
            if (!isChanging) {
                this.getModelNotifier().endChanging();
            }
            this.refresh = false;
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void noChange(NoChangeEvent event) {
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater == null) {
            return;
        }
        try {
            try {
                updater.replaceStructuredDocumentRegions(null, null);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setActive(null);
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.setActive(null);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegionList oldStructuredDocumentRegions = event.getOldStructuredDocumentRegions();
        IStructuredDocumentRegionList newStructuredDocumentRegions = event.getNewStructuredDocumentRegions();
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
                }
                catch (Exception ex) {
                    Class<?> clazz = ex.getClass();
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("org.eclipse.wst.xml.core.internal.document.StructuredDocumentRegionManagementException");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz2 = class$1 = clazz3;
                    }
                    if (clazz.equals(clazz2)) {
                        Logger.traceException(TRACE_PARSER_MANAGEMENT_EXCEPTION, ex);
                    } else {
                        Logger.logException(ex);
                    }
                    this.refresh = true;
                    this.handleRefresh();
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.setActive(null);
                throw throwable;
            }
            {
                Object var6_10 = null;
                this.setActive(null);
                return;
            }
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.replaceStructuredDocumentRegions(newStructuredDocumentRegions, oldStructuredDocumentRegions);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.setActive(null);
            if (isChanging) throw throwable;
            notifier.endChanging();
            this.handleRefresh();
            throw throwable;
        }
        {
            Object var9_15 = null;
            this.setActive(null);
            if (isChanging) return;
            notifier.endChanging();
            this.handleRefresh();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void regionChanged(RegionChangedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegion region = event.getRegion();
        if (region == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.changeRegion(event, flatNode, region);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.setActive(null);
                throw throwable;
            }
            {
                Object var6_10 = null;
                this.setActive(null);
                return;
            }
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.changeRegion(event, flatNode, region);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.setActive(null);
            if (isChanging) throw throwable;
            notifier.endChanging();
            this.handleRefresh();
            throw throwable;
        }
        {
            Object var9_15 = null;
            this.setActive(null);
            if (isChanging) return;
            notifier.endChanging();
            this.handleRefresh();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void regionsReplaced(RegionsReplacedEvent event) {
        if (event == null) {
            return;
        }
        IStructuredDocumentRegion flatNode = event.getStructuredDocumentRegion();
        if (flatNode == null) {
            return;
        }
        ITextRegionList oldRegions = event.getOldRegions();
        ITextRegionList newRegions = event.getNewRegions();
        if (oldRegions == null && newRegions == null) {
            return;
        }
        XMLModelUpdater updater = this.getActiveUpdater();
        if (updater != null) {
            try {
                try {
                    updater.replaceRegions(flatNode, newRegions, oldRegions);
                }
                catch (Exception ex) {
                    Logger.logException(ex);
                    this.refresh = true;
                    this.handleRefresh();
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.setActive(null);
                throw throwable;
            }
            {
                Object var7_11 = null;
                this.setActive(null);
                return;
            }
        }
        XMLModelNotifier notifier = this.getModelNotifier();
        boolean isChanging = notifier.isChanging();
        if (!isChanging) {
            notifier.beginChanging();
        }
        XMLModelParser parser = this.getModelParser();
        this.setActive(parser);
        try {
            try {
                parser.replaceRegions(flatNode, newRegions, oldRegions);
            }
            catch (Exception ex) {
                Logger.logException(ex);
                this.refresh = true;
                this.handleRefresh();
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.setActive(null);
            if (isChanging) throw throwable;
            notifier.endChanging();
            this.handleRefresh();
            throw throwable;
        }
        {
            Object var10_16 = null;
            this.setActive(null);
            if (isChanging) return;
            notifier.endChanging();
            this.handleRefresh();
            return;
        }
    }

    public void releaseFromEdit() {
        this.isShared();
        super.releaseFromEdit();
    }

    public void releaseFromRead() {
        this.isShared();
        super.releaseFromRead();
    }

    private void setActive(Object active) {
        this.active = active;
        if (active == null) {
            this.document.activateTagNameCache(true);
        } else {
            this.document.activateTagNameCache(false);
        }
    }

    public void setGenerator(ISourceGenerator generator) {
        this.generator = generator;
    }

    public void setModelNotifier(XMLModelNotifier notifier) {
        this.notifier = notifier;
    }

    public void setModelParser(XMLModelParser parser) {
        this.parser = parser;
    }

    public void setModelUpdater(XMLModelUpdater updater) {
        this.updater = updater;
    }

    public void setStructuredDocument(IStructuredDocument structuredDocument) {
        IStructuredDocument oldStructuredDocument = super.getStructuredDocument();
        if (structuredDocument == oldStructuredDocument) {
            return;
        }
        if (oldStructuredDocument != null) {
            oldStructuredDocument.removeDocumentChangingListener((IStructuredDocumentListener)this);
        }
        super.setStructuredDocument(structuredDocument);
        if (structuredDocument != null) {
            this.internalSetNewDocument(structuredDocument);
            structuredDocument.addDocumentChangingListener((IStructuredDocumentListener)this);
        }
    }

    protected void startTagChanged(Element element) {
        if (element == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeStartTag(element);
            this.setActive(null);
        }
        this.getModelNotifier().startTagChanged(element);
    }

    protected void valueChanged(Node node) {
        if (node == null) {
            return;
        }
        if (this.getActiveParser() == null) {
            XMLModelUpdater updater = this.getModelUpdater();
            this.setActive(updater);
            updater.initialize();
            updater.changeValue(node);
            this.setActive(null);
        }
        this.getModelNotifier().valueChanged(node);
    }

    public Object getFeature(String feature, String version) {
        throw new DOMException(9, "Not implemented in this version.");
    }
}

