/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.designers.wizards.pages.contactwidgets;

import java.util.List;
import org.eclipse.ebam.designers.exception.DatabaseConnectionException;
import org.eclipse.ebam.designers.swtutils.ImageDescriptors;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactWizardPage;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.ContactsDetailComposite;
import org.eclipse.ebam.designers.wizards.pages.contactwidgets.detailtabs.ContactDetailTabItem;
import org.eclipse.ebam.emf.SbiAlarmContactsTransactions;
import org.eclipse.ebam.model.entities.SbiAlarmContact;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsListComposite
extends Composite {
    private ContactWizardPage contactWizardPage = null;
    private Table contactsTable = null;
    public static final int NAME = 0;
    private static Logger logger = LoggerFactory.getLogger(ContactsListComposite.class);

    public ContactsListComposite(Composite parent, int style, ContactWizardPage page) {
        super(parent, style);
        this.contactWizardPage = page;
    }

    public void drawComp() {
        logger.debug("in");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        try {
            this.setLayout((Layout)gridLayout);
            Label label = new Label((Composite)this, 0);
            label.setText("Contacts List: ");
            label.setLayoutData((Object)new GridData(32));
            Label empty = new Label((Composite)this, 0);
            empty.setText("");
            empty.setLayoutData((Object)new GridData(128));
            Button buttonAdd = new Button((Composite)this, 8);
            buttonAdd.setToolTipText("Add an contact");
            buttonAdd.setLayoutData((Object)new GridData(32));
            Image addImage = ImageDescriptors.getAddIcon().createImage();
            buttonAdd.setImage(addImage);
            buttonAdd.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ContactsListComposite.this.contactWizardPage.getDetailComposite().getButtonSave().setEnabled(true);
                    ContactsListComposite.this.addAddButtonPush();
                }
            });
            Button buttonErase = new Button((Composite)this, 8);
            buttonErase.setToolTipText("Erase selected contact");
            buttonErase.setLayoutData((Object)new GridData(128));
            Image eraseImage = ImageDescriptors.getEraseIcon().createImage();
            buttonErase.setImage(eraseImage);
            buttonErase.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ContactsListComposite.this.eraseButtonPush();
                        ContactsListComposite.this.contactWizardPage.getDetailComposite().getButtonSave().setEnabled(false);
                    }
                    catch (DatabaseConnectionException databaseConnectionException) {
                        logger.error("database connection exception");
                        MessageDialog.openError((Shell)ContactsListComposite.this.contactsTable.getShell(), (String)"Error", (String)"Error in removing contact");
                    }
                }
            });
            List<SbiAlarmContact> contactsList = null;
            contactsList = this.retrieveContacts();
            this.contactsTable = new Table((Composite)this, 68100);
            this.contactsTable.setLinesVisible(true);
            this.contactsTable.setHeaderVisible(true);
            GridData g = new GridData(1808);
            g.horizontalSpan = 2;
            this.contactsTable.setLayoutData((Object)g);
            String[] titles = new String[]{"                                Name                                    "};
            int i = 0;
            while (i < titles.length) {
                TableColumn column = new TableColumn(this.contactsTable, 0);
                column.setText(titles[i]);
                ++i;
            }
            i = 0;
            while (i < contactsList.size()) {
                SbiAlarmContact sbiContact = contactsList.get(i);
                TableItem item = new TableItem(this.contactsTable, 0);
                String nameVal = "";
                if (sbiContact.getName() != null) {
                    nameVal = sbiContact.getName();
                }
                item.setText(0, nameVal);
                item.setData((Object)sbiContact.getAlarmContactId());
                ++i;
            }
            i = 0;
            while (i < titles.length) {
                this.contactsTable.getColumn(i).pack();
                ++i;
            }
            this.contactsTable.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        ContactsListComposite.this.addContactSelection();
                        ContactsListComposite.this.contactWizardPage.getDetailComposite().getButtonSave().setEnabled(true);
                    }
                    catch (Exception exception) {
                        logger.error("database connectionexception");
                        MessageDialog.openError((Shell)ContactsListComposite.this.contactsTable.getShell(), (String)"Error", (String)"Error in preparing page for selected allarm");
                    }
                }
            });
        }
        catch (Exception exception) {
            logger.error("Generic exception database");
        }
        this.contactsTable.redraw();
        logger.debug("OUT");
    }

    private void addContactSelection() throws Exception {
        logger.debug("IN");
        int indexSelected = this.contactsTable.getSelectionIndex();
        TableItem tableItem = this.contactsTable.getItem(indexSelected);
        Integer id = (Integer)tableItem.getData();
        SbiAlarmContact sbiContact = new SbiAlarmContactsTransactions().getSbiAlarmContactById(id);
        if (sbiContact == null) {
            logger.error("could not find contact with id " + id);
            MessageDialog.openError((Shell)this.contactsTable.getShell(), (String)"Error", (String)("Could not find contact with id " + id));
        }
        logger.debug("fill detail page with selected contact " + id);
        ContactsDetailComposite alDetailComposite = this.getContactWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        ContactDetailTabItem contactDetailTabItem = (ContactDetailTabItem)tabFolder.getItem(0);
        contactDetailTabItem.fillContactValues(sbiContact);
        tabFolder.setSelection(0);
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private void addAddButtonPush() {
        logger.debug("IN");
        ContactsDetailComposite alDetailComposite = this.getContactWizardPage().getDetailComposite();
        CTabFolder tabFolder = alDetailComposite.getTabFolder();
        this.contactsTable.setSelection(-1);
        ContactDetailTabItem contactDetailTabItem = (ContactDetailTabItem)tabFolder.getItem(0);
        contactDetailTabItem.fillEmptyValues();
        tabFolder.setEnabled(true);
        tabFolder.setSelection(0);
        logger.debug("OUT");
    }

    private List<SbiAlarmContact> retrieveContacts() throws DatabaseConnectionException {
        List contacts = null;
        try {
            contacts = new SbiAlarmContactsTransactions().getSbiAlarmContactList();
        }
        catch (Exception e) {
            logger.error("error in retrieving contacts list", (Throwable)e);
            throw new DatabaseConnectionException(e, "error in retrieving contacts list");
        }
        return contacts;
    }

    private void eraseButtonPush() throws DatabaseConnectionException {
        logger.debug("IN");
        int indexSelected = this.contactsTable.getSelectionIndex();
        if (indexSelected != -1) {
            TableItem tableItem = this.contactsTable.getItem(indexSelected);
            Integer id = (Integer)tableItem.getData();
            SbiAlarmContact sbiContact = null;
            try {
                sbiContact = new SbiAlarmContactsTransactions().getSbiAlarmContactById(id);
                new SbiAlarmContactsTransactions().deleteSbiAlarmContact(sbiContact);
            }
            catch (Exception e) {
                logger.error("error in erasing contact with id " + id, (Throwable)e);
                throw new DatabaseConnectionException(e, "error in erasing contact with id " + id);
            }
            this.contactsTable.remove(indexSelected);
            this.contactsTable.setSelection(-1);
            ContactsDetailComposite alDetailComposite = this.getContactWizardPage().getDetailComposite();
            CTabFolder tabFolder = alDetailComposite.getTabFolder();
            ContactDetailTabItem contactDetailTabItem = (ContactDetailTabItem)tabFolder.getItem(0);
            contactDetailTabItem.fillEmptyValues();
            tabFolder.setSelection(0);
            tabFolder.setEnabled(false);
            this.contactsTable.redraw();
        }
        logger.debug("OUT");
    }

    public ContactWizardPage getContactWizardPage() {
        return this.contactWizardPage;
    }

    public void setContactWizardPage(ContactWizardPage contactWizardPage) {
        this.contactWizardPage = contactWizardPage;
    }

    public Table getContactsTable() {
        return this.contactsTable;
    }

    public void setContactsTable(Table contactsTable) {
        this.contactsTable = contactsTable;
    }
}

