/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.birt.core.data.DateFormatISO8601;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.script.JSDocumentProvider;
import org.eclipse.birt.report.designer.internal.ui.script.JSEditorInput;
import org.eclipse.birt.report.designer.internal.ui.script.JSSourceViewerConfiguration;
import org.eclipse.birt.report.designer.internal.ui.script.ScriptValidator;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ColumnBindingDialog;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.Operator;
import org.eclipse.birt.report.designer.ui.expressions.ISortableExpressionProvider;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.TabularDimensionHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.TabularMeasureHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BidiSegmentEvent;
import org.eclipse.swt.custom.BidiSegmentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class ExpressionBuilder
extends BaseTitleAreaDialog {
    private static final String DIALOG_TITLE = Messages.getString((String)"ExpressionBuidler.Dialog.Title");
    private static final String TITLE = Messages.getString((String)"ExpressionBuidler.Title");
    private static final String PROMRT_MESSAGE = Messages.getString((String)"ExpressionBuilder.Message.Prompt");
    private static final String LABEL_FUNCTIONS = Messages.getString((String)"ExpressionBuilder.Label.Functions");
    private static final String LABEL_SUB_CATEGORY = Messages.getString((String)"ExpressionBuilder.Label.SubCategory");
    private static final String LABEL_CATEGORY = Messages.getString((String)"ExpressionBuilder.Label.Category");
    private static final String LABEL_OPERATORS = Messages.getString((String)"ExpressionBuilder.Label.Operators");
    private static final String TOOL_TIP_TEXT_REDO = Messages.getString((String)"TextEditDialog.toolTipText.redo");
    private static final String TOOL_TIP_TEXT_UNDO = Messages.getString((String)"TextEditDialog.toolTipText.undo");
    private static final String TOOL_TIP_TEXT_DELETE = Messages.getString((String)"TextEditDialog.toolTipText.delete");
    private static final String TOOL_TIP_TEXT_PASTE = Messages.getString((String)"TextEditDialog.toolTipText.paste");
    private static final String TOOL_TIP_TEXT_CUT = Messages.getString((String)"TextEditDialog.toolTipText.cut");
    private static final String TOOL_TIP_TEXT_COPY = Messages.getString((String)"TextEditDialog.toolTipText.copy");
    private static final String TOOL_TIP_TEXT_VALIDATE = Messages.getString((String)"ExpressionBuilder.toolTipText.validate");
    private static final String TOOL_TIP_TEXT_CALENDAR = Messages.getString((String)"ExpressionBuilder.toolTipText.calendar");
    private static final Object[] EMPTY = new Object[0];
    private static final String SORTING_PREFERENCE_KEY = "ExpressionBuilder.preference.enable.sorting";
    private TableViewer categoryTable;
    private TableViewer functionTable;
    private TreeViewer subCategoryTable;
    private IExpressionProvider provider;
    private SourceViewer sourceViewer;
    private JSSourceViewerConfiguration sourceViewerConfiguration = new JSSourceViewerConfiguration();
    private IPreferenceStore preferenceStore;
    private Color backgroundColor;
    private Color foregroundColor;
    private FormText messageLine;
    protected String expression = null;
    protected String title;
    private boolean useSorting = false;
    private Object[] defaultSelection;
    private Map<ToolItem, Integer> toolItemType = new HashMap<ToolItem, Integer>();
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            TreeViewer target = null;
            if (event.getSource() == ExpressionBuilder.this.categoryTable) {
                target = ExpressionBuilder.this.subCategoryTable;
            } else if (event.getSource() == ExpressionBuilder.this.subCategoryTable) {
                target = ExpressionBuilder.this.functionTable;
            }
            if (target != null) {
                target.setInput(selection == null ? null : selection.getFirstElement());
            }
            if (event.getSource() == ExpressionBuilder.this.functionTable) {
                Table table = ExpressionBuilder.this.functionTable.getTable();
                if (table.getSelectionCount() == 1) {
                    ExpressionBuilder.this.messageLine.getParent().setVisible(true);
                    String message = ExpressionBuilder.this.provider.getDisplayText(table.getSelection()[0].getData());
                    message = message.replaceAll("&", "&amp;");
                    message = message.replaceAll("<", "&lt;");
                    message = message.replaceAll(">", "&gt;");
                    ExpressionBuilder.this.messageLine.setText("<form><p> <b>" + Messages.getString((String)"ExpressionBuilder.Label.Hint") + "</b>: " + message + "</p></form>", true, false);
                    ExpressionBuilder.this.messageLine.getParent().layout();
                } else {
                    ExpressionBuilder.this.messageLine.getParent().setVisible(false);
                }
            }
        }
    };
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            if (event.getSource() == ExpressionBuilder.this.functionTable) {
                ExpressionBuilder.this.insertSelection(selection);
                return;
            }
        }
    };
    private boolean isEditModel = false;

    public ExpressionBuilder(Shell parentShell, String initExpression) {
        super(parentShell);
        this.title = DIALOG_TITLE;
        this.expression = UIUtil.convertToGUIString(initExpression);
        this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.ui.editors");
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle |= 0x410);
    }

    public ExpressionBuilder(String initExpression) {
        this(UIUtil.getDefaultShell(), initExpression);
    }

    public ExpressionBuilder() {
        this((String)null);
    }

    private void insertSelection(IStructuredSelection selection) {
        Object[] inputArray;
        if (selection.getFirstElement() instanceof Object[] && (inputArray = (Object[])selection.getFirstElement()).length == 2 && inputArray[1] instanceof ReportItemHandle) {
            ReportItemHandle handle = (ReportItemHandle)inputArray[1];
            handle.getModuleHandle().getCommandStack().startTrans(Messages.getString((String)"DataEditPart.stackMsg.edit"));
            ColumnBindingDialog dialog = new ColumnBindingDialog(handle, Messages.getString((String)"DataColumBindingDialog.title.EditDataBinding"));
            if (dialog.open() == 0) {
                handle.getModuleHandle().getCommandStack().commit();
                this.functionTable.refresh();
            } else {
                handle.getModuleHandle().getCommandStack().rollback();
            }
            return;
        }
        String insertText = this.provider.getInsertText(selection.getFirstElement());
        if (insertText != null) {
            this.insertText(insertText);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createExpressionField(composite);
        if (this.provider == null) {
            this.provider = new ExpressionProvider();
        }
        this.createOperatorsBar(composite);
        this.createMessageLine(composite);
        this.createListArea(composite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ExpressionBuilder_ID");
        return composite;
    }

    private void createMessageLine(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.messageLine = new FormText(container, 0);
        new FormToolkit(Display.getDefault()){
            private BorderPainter borderPainter;

            public void paintBordersFor(Composite parent) {
                if (this.borderPainter == null) {
                    this.borderPainter = new BorderPainter();
                }
                parent.addPaintListener((PaintListener)this.borderPainter);
            }

            class BorderPainter
            implements PaintListener {
                BorderPainter() {
                }

                public void paintControl(PaintEvent event) {
                    Composite composite = (Composite)event.widget;
                    Control[] children = composite.getChildren();
                    int i = 0;
                    while (i < children.length) {
                        Control c = children[i];
                        if (c.isVisible() && c instanceof FormText) {
                            Rectangle b = c.getBounds();
                            GC gc = event.gc;
                            gc.setForeground(c.getBackground());
                            gc.drawRectangle(b.x - 2, b.y - 2, b.width + 4, b.height + 4);
                            gc.setForeground(this.getColors().getBorderColor());
                            gc.drawRectangle(b.x - 2, b.y - 2, b.width + 4, b.height + 4);
                        }
                        ++i;
                    }
                }
            }
        }.paintBordersFor(container);
        this.messageLine.setText("<form><p></p></form>", true, false);
        container.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 6;
        this.messageLine.setLayoutData((Object)gridData);
    }

    private void createToolbar(Composite parent) {
        final ToolBar toolBar = new ToolBar(parent, 0x800000);
        toolBar.setLayoutData((Object)new GridData());
        ToolItem copy = this.createToolItem(toolBar, 4);
        copy.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_COPY"));
        copy.setToolTipText(TOOL_TIP_TEXT_COPY);
        ToolItem cut = this.createToolItem(toolBar, 3);
        cut.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_CUT"));
        cut.setToolTipText(TOOL_TIP_TEXT_CUT);
        ToolItem paste = this.createToolItem(toolBar, 5);
        paste.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_PASTE"));
        paste.setToolTipText(TOOL_TIP_TEXT_PASTE);
        ToolItem delete = this.createToolItem(toolBar, 6);
        delete.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_DELETE"));
        delete.setToolTipText(TOOL_TIP_TEXT_DELETE);
        ToolItem undo = this.createToolItem(toolBar, 1);
        undo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_UNDO"));
        undo.setToolTipText(TOOL_TIP_TEXT_UNDO);
        ToolItem redo = this.createToolItem(toolBar, 2);
        redo.setImage(ReportPlatformUIImages.getImage("IMG_TOOL_REDO"));
        redo.setToolTipText(TOOL_TIP_TEXT_REDO);
        ToolItem validate = new ToolItem(toolBar, 0);
        validate.setImage(ReportPlatformUIImages.getImage("Validate Expression"));
        validate.setToolTipText(TOOL_TIP_TEXT_VALIDATE);
        validate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.validateScript();
            }
        });
        final ToolItem calendar = new ToolItem(toolBar, 0);
        calendar.setImage(ReportPlatformUIImages.getImage("Calendar"));
        calendar.setToolTipText(TOOL_TIP_TEXT_CALENDAR);
        calendar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.generateDate(toolBar, calendar);
            }
        });
    }

    private ToolItem createToolItem(ToolBar toolBar, final int operationType) {
        ToolItem item = new ToolItem(toolBar, 0);
        this.toolItemType.put(item, operationType);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.sourceViewer.doOperation(operationType);
                ExpressionBuilder.this.updateToolItems();
            }
        });
        return item;
    }

    private void createExpressionField(Composite parent) {
        Composite expressionArea = new Composite(parent, 0);
        expressionArea.setLayout((Layout)new GridLayout());
        expressionArea.setLayoutData((Object)new GridData(1808));
        this.createToolbar(expressionArea);
        this.sourceViewer = this.createSourceViewer(expressionArea);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.sourceViewer.getControl().setLayoutData((Object)gd);
        if (Platform.getOS().equals("win32")) {
            Font font = this.sourceViewer.getTextWidget().getFont();
            FontData data = font.getFontData()[0];
            Font newFont = FontManager.getFont((String)data.getName(), (int)(data.getHeight() + 1), (int)data.getStyle());
            this.sourceViewer.getTextWidget().setFont(newFont);
        }
        this.sourceViewer.getTextWidget().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ExpressionBuilder.this.updateToolItems();
                if (this.isUndoKeyPress(e)) {
                    ExpressionBuilder.this.sourceViewer.doOperation(1);
                } else if (this.isRedoKeyPress(e)) {
                    ExpressionBuilder.this.sourceViewer.doOperation(2);
                }
            }

            private boolean isUndoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 122 || e.keyCode == 90);
            }

            private boolean isRedoKeyPress(KeyEvent e) {
                return (e.stateMask & 0x40000) > 0 && (e.keyCode == 121 || e.keyCode == 89);
            }
        });
        this.sourceViewer.getTextWidget().addBidiSegmentListener(new BidiSegmentListener(){

            public void lineGetSegments(BidiSegmentEvent event) {
                event.segments = UIUtil.getExpressionBidiSegments(event.lineText);
            }
        });
        this.sourceViewer.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpressionBuilder.this.resetOkButtonStatus(true);
            }
        });
        this.sourceViewer.getTextWidget().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.updateToolItems();
            }
        });
        this.updateToolItems();
    }

    protected void updateToolItems() {
        for (ToolItem item : this.toolItemType.keySet()) {
            if (item.isDisposed()) continue;
            item.setEnabled(this.sourceViewer.canDoOperation(this.toolItemType.get(item).intValue()));
        }
    }

    private void createOperatorsBar(Composite parent) {
        Operator[] operators = this.provider.getOperators();
        if (operators == null || operators.length == 0) {
            return;
        }
        Composite operatorsBar = new Composite(parent, 0);
        operatorsBar.setLayout((Layout)new GridLayout(2, false));
        operatorsBar.setLayoutData((Object)new GridData(768));
        Label lable = new Label(operatorsBar, 0);
        lable.setText(LABEL_OPERATORS);
        int width = lable.computeSize((int)-1, (int)-1).x;
        width = width > 70 ? width : 70;
        GridData gd = new GridData();
        gd.widthHint = width;
        lable.setLayoutData((Object)gd);
        Composite operatorsArea = new Composite(operatorsBar, 0);
        operatorsArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(operators.length, true));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ExpressionBuilder.this.insertText((String)button.getData());
            }
        };
        int i = 0;
        while (i < operators.length) {
            Button button = new Button(operatorsArea, 8);
            button.setLayoutData((Object)new GridData(768));
            if (operators[i] != IExpressionProvider.OPERATOR_SEPARATOR) {
                button.setData((Object)operators[i].insertString);
                String text = operators[i].symbol;
                if (text.indexOf("&") != -1) {
                    text = text.replaceAll("&", "&&");
                }
                button.setText(text);
                button.addSelectionListener((SelectionListener)selectionAdapter);
            } else {
                button.setVisible(false);
            }
            ++i;
        }
    }

    private void initSorting() {
        this.useSorting = PreferenceFactory.getInstance().getPreferences(ReportPlugin.getDefault()).getBoolean(SORTING_PREFERENCE_KEY);
    }

    private void toggleSorting(boolean sorted) {
        this.useSorting = sorted;
        PreferenceFactory.getInstance().getPreferences(ReportPlugin.getDefault()).setValue(SORTING_PREFERENCE_KEY, this.useSorting);
        this.functionTable.refresh();
    }

    private void createListArea(Composite parent) {
        Composite listArea = new Composite(parent, 0);
        listArea.setLayout((Layout)new GridLayout(3, true));
        listArea.setLayoutData((Object)new GridData(1808));
        Label categoryLabel = new Label(listArea, 0);
        categoryLabel.setText(LABEL_CATEGORY);
        categoryLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ExpressionBuilder.this.categoryTable.getControl().setFocus();
                }
            }
        });
        Label subCategoryLabel = new Label(listArea, 0);
        subCategoryLabel.setText(LABEL_SUB_CATEGORY);
        subCategoryLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ExpressionBuilder.this.subCategoryTable.getControl().setFocus();
                }
            }
        });
        Composite functionHeader = new Composite(listArea, 0);
        functionHeader.setLayout((Layout)new GridLayout(2, false));
        functionHeader.setLayoutData((Object)new GridData(768));
        Label functionLabel = new Label(functionHeader, 0);
        functionLabel.setText(LABEL_FUNCTIONS);
        functionLabel.setLayoutData((Object)new GridData(768));
        functionLabel.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128 && e.doit) {
                    e.detail = 0;
                    ExpressionBuilder.this.functionTable.getControl().setFocus();
                }
            }
        });
        ToolBar toolBar = new ToolBar(functionHeader, 0x800000);
        toolBar.setLayoutData((Object)new GridData(128));
        final ToolItem sortBtn = new ToolItem(toolBar, 32);
        sortBtn.setImage(ReportPlatformUIImages.getImage("AlphabeticSort"));
        sortBtn.setToolTipText(Messages.getString((String)"ExpressionBuilder.tooltip.Sort"));
        sortBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExpressionBuilder.this.toggleSorting(sortBtn.getSelection());
            }
        });
        if (this.provider instanceof ISortableExpressionProvider) {
            this.initSorting();
            sortBtn.setSelection(this.useSorting);
        } else {
            sortBtn.setEnabled(false);
        }
        int style = 67588;
        this.categoryTable = new TableViewer(listArea, style);
        this.subCategoryTable = new TreeViewer(listArea, style);
        this.functionTable = new TableViewer(listArea, style);
        this.functionTable.getControl().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                IStructuredSelection selection;
                if (e.character == ' ' && !(selection = (IStructuredSelection)ExpressionBuilder.this.functionTable.getSelection()).isEmpty()) {
                    ExpressionBuilder.this.insertSelection(selection);
                }
            }
        });
        this.initTable(this.categoryTable);
        this.initTree(this.subCategoryTable);
        this.initTable(this.functionTable);
    }

    private void handleDefaultSelection() {
        if (this.defaultSelection == null || this.defaultSelection.length == 0) {
            return;
        }
        if (this.defaultSelection.length > 0 && this.defaultSelection[0] != null) {
            this.categoryTable.setSelection((ISelection)new StructuredSelection(this.defaultSelection[0]), true);
            if (this.defaultSelection.length > 1 && this.defaultSelection[1] != null) {
                this.subCategoryTable.setSelection((ISelection)new StructuredSelection(this.defaultSelection[1]), true);
                if (this.defaultSelection.length > 2 && this.defaultSelection[2] != null) {
                    this.functionTable.setSelection((ISelection)new StructuredSelection(this.defaultSelection[2]), true);
                }
            }
        }
    }

    private void initTree(TreeViewer treeViewer) {
        Tree tree = treeViewer.getTree();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        tree.setLayoutData((Object)gd);
        tree.setToolTipText(null);
        treeViewer.setLabelProvider((IBaseLabelProvider)new ExpressionLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return ExpressionBuilder.this.provider.getChildren(parentElement);
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return ExpressionBuilder.this.provider.hasChildren(element);
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        treeViewer.addSelectionChangedListener(this.selectionListener);
        treeViewer.addDoubleClickListener(this.doubleClickListener);
    }

    private void initTable(TableViewer tableViewer) {
        final Table table = tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        table.setLayoutData((Object)gd);
        table.setToolTipText(null);
        final TableColumn column = new TableColumn(table, 0);
        column.setWidth(200);
        table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        if (!column.isDisposed()) {
                            column.setWidth(table.getSize().x > 204 ? table.getSize().x - 4 : 200);
                        }
                    }
                });
            }
        });
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == table) {
                    Point pt = new Point(event.x, event.y);
                    TableItem item = table.getItem(pt);
                    if (item == null) {
                        table.setToolTipText(null);
                    } else {
                        table.setToolTipText(ExpressionBuilder.this.provider.getTooltipText(item.getData()));
                    }
                }
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ExpressionLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new TableContentProvider((Viewer)tableViewer));
        tableViewer.addSelectionChangedListener(this.selectionListener);
        tableViewer.addDoubleClickListener(this.doubleClickListener);
    }

    protected void setButtonLayoutData(Button button) {
        GridData gridData;
        if (button.getText().equals(IDialogConstants.HELP_LABEL)) {
            gridData = new GridData(72);
            gridData.grabExcessVerticalSpace = true;
        } else {
            gridData = new GridData(2);
        }
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gridData.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)gridData);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getShell().setText(this.title);
        this.setTitle(TITLE);
        this.setMessage(PROMRT_MESSAGE);
        this.categoryTable.setInput((Object)"Dummy");
        this.handleDefaultSelection();
        this.getShell().setDefaultButton(null);
        this.sourceViewer.getTextWidget().setFocus();
        return control;
    }

    protected void okPressed() {
        MessageDialog dialog;
        if (!this.validateScript() && (dialog = new MessageDialog(this.getShell(), Messages.getString((String)"ExpressionBuilder.Script.Warning"), null, Messages.getString((String)"ExpressionBuilder.Script.Confirm"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1)).open() != 0) {
            return;
        }
        this.expression = this.sourceViewer.getTextWidget().getText().trim();
        super.okPressed();
    }

    public String getResult() {
        return this.expression;
    }

    public void setExpressionProvider(IExpressionProvider provider) {
        this.provider = provider;
    }

    public void setExpressionProvier(IExpressionProvider provider) {
        this.setExpressionProvider(provider);
    }

    public void setDefaultSelection(Object ... selection) {
        this.defaultSelection = selection;
    }

    public void setDialogTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getDialogTitle() {
        return this.title;
    }

    protected void insertText(String text) {
        StyledText textWidget = this.sourceViewer.getTextWidget();
        if (!textWidget.isEnabled()) {
            return;
        }
        int selectionStart = textWidget.getSelection().x;
        textWidget.insert(text);
        textWidget.setSelection(selectionStart + text.length());
        textWidget.setFocus();
        if (text.endsWith("()")) {
            textWidget.setCaretOffset(textWidget.getCaretOffset() - 1);
        }
    }

    protected SourceViewer createSourceViewer(Composite parent) {
        IVerticalRuler ruler = this.createVerticalRuler();
        Composite composite = new Composite(parent, 0x2000800);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        int styles = 68354;
        SourceViewer viewer = new SourceViewer(composite, ruler, styles);
        viewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.updateStyledTextColors(viewer.getTextWidget());
        JSEditorInput editorInput = new JSEditorInput(this.expression, this.getEncoding());
        JSDocumentProvider documentProvider = new JSDocumentProvider();
        try {
            documentProvider.connect(editorInput);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e);
        }
        viewer.setDocument(documentProvider.getDocument(editorInput), ruler == null ? null : ruler.getModel());
        return viewer;
    }

    private void updateStyledTextColors(StyledText styledText) {
        if (this.preferenceStore != null) {
            styledText.setForeground(this.getForegroundColor(this.preferenceStore));
            styledText.setBackground(this.getBackgroundColor(this.preferenceStore));
        }
    }

    private Color getForegroundColor(IPreferenceStore preferenceStore) {
        Color color;
        this.foregroundColor = color = preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(preferenceStore, "AbstractTextEditor.Color.Foreground", Display.getCurrent());
        return color;
    }

    private Color getBackgroundColor(IPreferenceStore preferenceStore) {
        Color color;
        this.backgroundColor = color = preferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault") ? null : this.createColor(preferenceStore, "AbstractTextEditor.Color.Background", Display.getCurrent());
        return color;
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    private IVerticalRulerColumn createLineNumberRulerColumn() {
        LineNumberRulerColumn column = new LineNumberRulerColumn();
        column.setForeground(JSSourceViewerConfiguration.getColorByCategory("linenumberColor"));
        return column;
    }

    private CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.setModel((IAnnotationModel)new AnnotationModel());
        return ruler;
    }

    private IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        if (ruler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = ruler;
            compositeRuler.addDecorator(0, this.createLineNumberRulerColumn());
        }
        return ruler;
    }

    protected boolean validateScript() {
        if (this.sourceViewer == null) {
            return false;
        }
        String errorMessage = null;
        try {
            new ScriptValidator((ISourceViewer)this.sourceViewer).validate(true, true);
            this.setMessage(Messages.getString((String)"ExpressionBuilder.Script.NoError"), 1);
        }
        catch (ParseException e) {
            try {
                int offset = e.getErrorOffset();
                int row = this.sourceViewer.getTextWidget().getLineAtOffset(offset) + 1;
                int column = offset - this.sourceViewer.getTextWidget().getOffsetAtLine(row - 1) + 1;
                errorMessage = Messages.getFormattedString((String)"ExpressionBuilder.Script.Error", (Object[])new Object[]{Integer.toString(row), Integer.toString(column), e.getLocalizedMessage()});
            }
            catch (Throwable throwable) {
                this.setErrorMessage(errorMessage);
                throw throwable;
            }
            this.setErrorMessage(errorMessage);
            return false;
        }
        this.setErrorMessage(errorMessage);
        return true;
    }

    private void generateDate(ToolBar toolBar, ToolItem calendar) {
        final Shell shell = new Shell(UIUtil.getDefaultShell(), 524288);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                shell.close();
            }

            public void shellIconified(ShellEvent e) {
                shell.close();
            }
        });
        Point point = toolBar.toDisplay(0, 0);
        point.y += toolBar.getBounds().height;
        int i = 0;
        while (i < toolBar.getItemCount()) {
            ToolItem item = toolBar.getItem(i);
            if (item == calendar) break;
            point.x += item.getWidth();
            ++i;
        }
        shell.setLocation(point);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        shell.setLayout((Layout)layout);
        final DateTime colorDialog = new DateTime((Composite)shell, 0x800400);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 1;
        colorDialog.setLayoutData((Object)gd);
        new Label((Composite)shell, 258).setLayoutData((Object)new GridData(768));
        Composite container = new Composite((Composite)shell, 0);
        container.setLayoutData((Object)new GridData(768));
        layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        new Label(container, 0).setLayoutData((Object)new GridData(768));
        Button okBtn = new Button(container, 0x800000);
        okBtn.setText(Messages.getString((String)"ExpressionBuilder.Calendar.Button.OK"));
        gd = new GridData();
        gd.widthHint = okBtn.computeSize((int)-1, (int)-1).x < 60 ? 60 : okBtn.computeSize((int)-1, (int)-1).x;
        okBtn.setLayoutData((Object)gd);
        okBtn.setFocus();
        okBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Calendar cal = Calendar.getInstance();
                    cal.set(colorDialog.getYear(), colorDialog.getMonth(), colorDialog.getDay());
                    ExpressionBuilder.this.insertText(DEUtil.addQuote((String)DateFormatISO8601.format((Date)cal.getTime())));
                    if (!shell.isDisposed()) {
                        shell.close();
                    }
                    if (ExpressionBuilder.this.sourceViewer != null && !ExpressionBuilder.this.sourceViewer.getTextWidget().isDisposed()) {
                        ExpressionBuilder.this.sourceViewer.getTextWidget().setFocus();
                    }
                }
                catch (BirtException e1) {
                    ExceptionHandler.handle(e1);
                }
            }
        });
        shell.pack();
        shell.open();
    }

    private String getEncoding() {
        String encoding = "";
        ModuleHandle module = SessionHandleAdapter.getInstance().getReportDesignHandle();
        encoding = module != null ? module.getFileEncoding() : "UTF-8";
        return encoding;
    }

    public boolean close() {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        if (this.backgroundColor != null) {
            this.backgroundColor.dispose();
        }
        return super.close();
    }

    public void setEditModal(boolean isEditModel) {
        this.isEditModel = isEditModel;
    }

    public boolean isEditModal() {
        return this.isEditModel;
    }

    protected void resetOkButtonStatus(Boolean enabled) {
        Button okButton = this.getButton(0);
        if (okButton != null && okButton.isEnabled() != enabled.booleanValue()) {
            okButton.setEnabled(enabled.booleanValue());
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.isEditModal()) {
            this.resetOkButtonStatus(false);
        }
    }

    private class ExpressionLabelProvider
    implements ITableLabelProvider,
    ILabelProvider {
        private ExpressionLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ExpressionBuilder.this.provider.getImage(element);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ExpressionBuilder.this.provider.getDisplayText(element);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return ExpressionBuilder.this.provider.getImage(element);
        }

        public String getText(Object element) {
            return ExpressionBuilder.this.provider.getDisplayText(element);
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        private Viewer viewer;

        public TableContentProvider(Viewer viewer) {
            this.viewer = viewer;
        }

        public Object[] getElements(Object inputElement) {
            if (this.viewer == ExpressionBuilder.this.categoryTable) {
                return ExpressionBuilder.this.provider.getCategory();
            }
            if (inputElement instanceof IAdaptable) {
                inputElement = DNDUtil.unwrapToModel((Object)inputElement);
            }
            if (inputElement instanceof PropertyHandle || inputElement instanceof TabularMeasureGroupHandle || inputElement instanceof TabularDimensionHandle) {
                return EMPTY;
            }
            if (inputElement instanceof LevelHandle) {
                ArrayList<Object> childrenList = new ArrayList<Object>();
                childrenList.add(inputElement);
                ArrayList<LevelAttributeHandle> attribs = new ArrayList<LevelAttributeHandle>();
                Iterator iterator = ((LevelHandle)inputElement).attributesIterator();
                while (iterator.hasNext()) {
                    attribs.add((LevelAttributeHandle)iterator.next());
                }
                if (ExpressionBuilder.this.useSorting) {
                    Collections.sort(attribs, new Comparator<LevelAttributeHandle>(){

                        @Override
                        public int compare(LevelAttributeHandle o1, LevelAttributeHandle o2) {
                            return Collator.getInstance().compare(o1.getName(), o2.getName());
                        }
                    });
                }
                childrenList.addAll(attribs);
                return childrenList.toArray();
            }
            if (inputElement instanceof TabularMeasureHandle) {
                return new Object[]{inputElement};
            }
            if (ExpressionBuilder.this.useSorting && ExpressionBuilder.this.provider instanceof ISortableExpressionProvider) {
                return ((ISortableExpressionProvider)ExpressionBuilder.this.provider).getSortedChildren(inputElement);
            }
            return ExpressionBuilder.this.provider.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (viewer == ExpressionBuilder.this.subCategoryTable) {
                ExpressionBuilder.this.functionTable.setInput(null);
            }
        }
    }
}

