/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.api.olap.TabularHierarchyHandle;

public class BindingExpressionProvider
extends ExpressionProvider {
    private DataSetHandle dataSetHandle = null;

    public BindingExpressionProvider(DesignElementHandle handle, final ComputedColumnHandle computedColumnHandle) {
        super(handle);
        if (handle instanceof TabularCubeHandle) {
            this.dataSetHandle = ((TabularCubeHandle)handle).getDataSet();
        } else if (handle instanceof TabularHierarchyHandle) {
            this.dataSetHandle = ((TabularHierarchyHandle)handle).getDataSet();
            if (this.dataSetHandle == null && ((TabularHierarchyHandle)handle).getLevelCount() > 0) {
                this.dataSetHandle = ((TabularCubeHandle)((TabularHierarchyHandle)handle).getContainer().getContainer()).getDataSet();
            }
        }
        if (handle instanceof ReportItemHandle) {
            this.dataSetHandle = ((ReportItemHandle)handle).getDataSet();
        } else if (handle instanceof GroupHandle) {
            this.dataSetHandle = ((ReportItemHandle)((GroupHandle)handle).getContainer()).getDataSet();
        }
        if (computedColumnHandle != null) {
            this.addFilter(new ExpressionFilter(){

                public boolean select(Object parentElement, Object element) {
                    ComputedColumnHandle column;
                    return !(element instanceof ComputedColumnHandle) || !(column = (ComputedColumnHandle)element).getName().equals(computedColumnHandle.getName());
                }
            });
        }
    }

    protected List getCategoryList() {
        List<Object> categoryList = super.getCategoryList();
        if (this.dataSetHandle != null) {
            categoryList.add(0, DATASETS);
        }
        return categoryList;
    }

    protected List getChildrenList(Object parent) {
        if (DATASETS.equals(parent)) {
            ArrayList<DataSetHandle> dataSeList = new ArrayList<DataSetHandle>();
            dataSeList.add(this.dataSetHandle);
            return dataSeList;
        }
        if (parent instanceof DataSetHandle) {
            try {
                List columnList = DataUtil.getColumnList((DataSetHandle)parent);
                List outputList = this.getOutputList((DataSetHandle)parent);
                columnList.addAll(outputList);
                return columnList;
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                return Collections.EMPTY_LIST;
            }
        }
        return super.getChildrenList(parent);
    }

    private List getOutputList(DataSetHandle handle) {
        ArrayList outputList = new ArrayList();
        PropertyHandle parameters = handle.getPropertyHandle("parameters");
        Iterator iter = parameters.iterator();
        if (iter != null) {
            while (iter.hasNext()) {
                Object dataSetParameter = iter.next();
                if (!((DataSetParameterHandle)dataSetParameter).isOutput()) continue;
                outputList.add(dataSetParameter);
            }
        }
        return outputList;
    }

    public String getDisplayText(Object element) {
        if (element instanceof DataSetHandle) {
            return ((DataSetHandle)element).getName();
        }
        if (element instanceof ResultSetColumnHandle) {
            return ((ResultSetColumnHandle)element).getColumnName();
        }
        if (element instanceof DataSetParameterHandle) {
            return ((DataSetParameterHandle)element).getName();
        }
        return super.getDisplayText(element);
    }

    public String getInsertText(Object element) {
        if (element instanceof ResultSetColumnHandle || element instanceof DataSetParameterHandle) {
            return DEUtil.getExpression((Object)element);
        }
        return super.getInsertText(element);
    }
}

