/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.FigureCellEditorLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class FigureDirectEditManager
extends DirectEditManager {
    Font scaledFont;
    String initialText = "";

    public FigureDirectEditManager(GraphicalEditPart source) {
        super(source, TextCellEditor.class, (CellEditorLocator)new FigureCellEditorLocator(source.getFigure()));
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        IFigure figure = this.getEditPart().getFigure();
        String initialLabelText = this.initialText;
        this.getCellEditor().setValue((Object)initialLabelText);
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        figure.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    protected CellEditor createCellEditorOn(Composite composite) {
        return new TextCellEditor(composite, 66);
    }

    public String getInitialText() {
        return this.initialText;
    }

    public void setInitialText(String initialText) {
        this.initialText = initialText;
    }
}

