/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core.history;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mylyn.internal.bugzilla.core.history.AssignmentEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.AttachmentEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.ResolutionEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.StatusEvent;
import org.eclipse.mylyn.internal.bugzilla.core.history.TaskRevision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskHistory
implements Iterable<TaskRevision>,
Serializable {
    private static final long serialVersionUID = 1724420130243724426L;
    private final List<StatusEvent> statusEvents = new ArrayList<StatusEvent>();
    private final List<ResolutionEvent> resolutionEvents = new ArrayList<ResolutionEvent>();
    private final List<AssignmentEvent> assignmentEvents = new ArrayList<AssignmentEvent>();
    private final List<TaskRevision> otherEvents;
    private final List<AttachmentEvent> attachmentEvents = new ArrayList<AttachmentEvent>();

    public TaskHistory() {
        this.otherEvents = new ArrayList<TaskRevision>();
    }

    public void addEvent(TaskRevision event) {
        if (event instanceof StatusEvent) {
            this.statusEvents.add((StatusEvent)event);
            return;
        }
        if (event instanceof ResolutionEvent) {
            this.resolutionEvents.add((ResolutionEvent)event);
            return;
        }
        if (event instanceof AssignmentEvent) {
            this.assignmentEvents.add((AssignmentEvent)event);
            return;
        }
        if (event instanceof AttachmentEvent) {
            this.attachmentEvents.add((AttachmentEvent)event);
            return;
        }
        this.otherEvents.add(event);
    }

    private List<TaskRevision> getEvents() {
        ArrayList<TaskRevision> events = new ArrayList<TaskRevision>();
        events.addAll(this.statusEvents);
        events.addAll(this.resolutionEvents);
        events.addAll(this.assignmentEvents);
        events.addAll(this.attachmentEvents);
        events.addAll(this.otherEvents);
        Collections.sort(events);
        return events;
    }

    @Override
    public Iterator<TaskRevision> iterator() {
        return this.getEvents().iterator();
    }

    public int size() {
        return this.otherEvents.size() + this.statusEvents.size() + this.resolutionEvents.size() + this.assignmentEvents.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (TaskRevision event : this) {
            sb.append(event);
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<StatusEvent> getStatusEvents() {
        return this.statusEvents;
    }

    public List<ResolutionEvent> getResolutionEvents() {
        return this.resolutionEvents;
    }

    public List<TaskRevision> getOtherEvents() {
        return this.otherEvents;
    }

    public List<AttachmentEvent> getAttachmentEvents() {
        return this.attachmentEvents;
    }

    public List<AssignmentEvent> getAssignmentEvents() {
        return this.assignmentEvents;
    }
}

