/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.tasks.ui.util.bugzilla;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.QuoteAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class BugzillaQuoteBlock
extends Block {
    private static Pattern pattern = Pattern.compile("((\\s*>)|\\(In reply to comment #\\d{1,}\\)).*");
    private int blockLineCount = 0;

    public boolean canStart(String line, int lineOffset) {
        return lineOffset == 0 && line.length() > 0 && pattern.matcher(line).matches();
    }

    protected int processLineContent(String line, int offset) {
        if (!this.canStart(line, offset)) {
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount == 0) {
            this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, (Attributes)new QuoteAttributes());
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
        } else {
            this.builder.lineBreak();
        }
        ++this.blockLineCount;
        this.getMarkupLanguage().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.blockLineCount = 0;
            this.builder.endBlock();
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

