/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCView;
import org.eclipse.birt.report.engine.toc.ViewNodeList;

public class ViewNode
extends TOCNode {
    static final List<ViewNode> EMPTY_CHILDREN = Collections.unmodifiableList(new ArrayList(0));
    TOCView view;
    ITreeNode node;
    int level;

    ViewNode(ViewNode parent, ITreeNode node) {
        this(parent.view, parent, node);
    }

    ViewNode(TOCView view, ViewNode parent, ITreeNode node) {
        this.view = view;
        this.node = node;
        this.nodeId = node.getNodeId();
        this.bookmark = node.getBookmark();
        this.parent = parent;
        if (parent != null) {
            this.level = parent.level + 1;
            this.tocStyle = view.getTOCStyle(this.level - 1, node.getElementId());
            Object value = node.getTOCValue();
            if (value != null) {
                this.displayString = view.localizeValue(value, this.tocStyle);
            }
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public List getChildren() {
        if (this.children == null) {
            this.children = new ViewNodeList(this);
        }
        return this.children;
    }

    public Object getTOCValue() {
        return this.node.getTOCValue();
    }
}

