/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.executor.doc.AbstractReportReader;
import org.eclipse.birt.report.engine.internal.executor.doc.BodyReader;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.LongComparator;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;

public class ReportletReader
extends AbstractReportReader {
    Fragment reportletFragment = null;
    long offset;
    BodyReader bodyExecutor;

    public ReportletReader(ExecutionContext context, long offset) throws IOException, BirtException {
        super(context);
        Fragment fragment = this.loadFragment(offset);
        this.bodyExecutor = new BodyReader(this, fragment);
    }

    public IReportItemExecutor getNextChild() {
        return this.bodyExecutor.getNextChild();
    }

    public boolean hasNextChild() {
        return this.bodyExecutor.hasNextChild();
    }

    protected Fragment loadFragment(long offset) throws IOException {
        Object[] leftEdge = this.createEdges(offset);
        Object[] rightEdge = new Object[leftEdge.length + 1];
        System.arraycopy(leftEdge, 0, rightEdge, 0, leftEdge.length);
        rightEdge[leftEdge.length] = Segment.RIGHT_MOST_EDGE;
        Fragment fragment = new Fragment(new LongComparator());
        fragment.addSection(leftEdge, rightEdge);
        fragment.build();
        return fragment;
    }

    protected Long[] createEdges(long offset) throws IOException {
        LinkedList<Long> parents = new LinkedList<Long>();
        IContent content = this.reader.loadContent(offset);
        while (content != null) {
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            if (ext != null) {
                parents.addFirst(new Long(ext.getIndex()));
            }
            content = (IContent)content.getParent();
        }
        Long[] edges = new Long[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            Long value = (Long)iter.next();
            edges[length++] = value;
        }
        return edges;
    }
}

