/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;

public class DataIterator
implements IDataIterator {
    protected IExtractionResults results;
    protected IResultIterator iterator;
    protected int startRow = -1;
    protected int maxRows;
    protected int rowCount;
    private boolean beforeFirstRow = true;

    DataIterator(IExtractionResults results, IResultIterator iterator, int startRow, int maxRows) throws BirtException {
        this.results = results;
        this.iterator = iterator;
        this.startRow = startRow;
        this.maxRows = maxRows;
        this.rowCount = 0;
        this.beforeFirstRow = true;
        if (startRow > 0) {
            iterator.moveTo(startRow - 1);
        }
    }

    public IExtractionResults getQueryResults() {
        return this.results;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.results.getResultMetaData();
    }

    public boolean next() throws BirtException {
        if (this.beforeFirstRow) {
            this.beforeFirstRow = false;
        }
        ++this.rowCount;
        if (this.maxRows >= 0 && this.rowCount > this.maxRows) {
            return false;
        }
        return this.iterator.next();
    }

    public Object getValue(String columnName) throws BirtException {
        if (this.beforeFirstRow) {
            throw new EngineException("Error.ResultsetIteratorError");
        }
        return this.iterator.getValue(columnName);
    }

    public Object getValue(int index) throws BirtException {
        if (this.beforeFirstRow) {
            throw new EngineException("Error.ResultsetIteratorError");
        }
        IResultMetaData metaData = this.getResultMetaData();
        String columnName = metaData.getColumnName(index);
        return this.iterator.getValue(columnName);
    }

    public void close() {
        try {
            this.iterator.close();
        }
        catch (BirtException birtException) {}
    }

    public boolean isEmpty() throws BirtException {
        return this.iterator.isEmpty();
    }

    public IResultIterator getResultIterator() {
        return this.iterator;
    }
}

