/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.ISortDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryLocator;
import org.eclipse.birt.data.engine.olap.api.query.IBaseCubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataExtractionOption;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderContext;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IDataExtractionOption;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionOption;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.CubeDataExtractionOption;
import org.eclipse.birt.report.engine.api.impl.CubeExtractionResults;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.QueryTask;
import org.eclipse.birt.report.engine.api.impl.QueryUtil;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentReader;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.api.impl.SubqueryResultMetaData;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IDataExtractionExtension;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataExtractionTaskV1
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected ISortDefinition[] sortExpressions = null;
    protected int maxRows = -1;
    protected int startRow = 0;
    protected boolean distinct;
    protected boolean groupMode = true;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected HashMap query2QueryIdMapping = new HashMap();
    protected HashMap rssetIdMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    private boolean isCubeExportEnabled;
    private List cubeNameList = new ArrayList();
    private String cubeName;
    protected static Logger logger = Logger.getLogger(DteDataEngine.class.getName());
    private HashMap tmpQuery2QueryIdMapping = new HashMap();

    public DataExtractionTaskV1(ReportEngine engine, IReportDocument reader) throws EngineException {
        super(engine, 4);
        IReportRunnable runnable = this.getOnPreparedRunnable(reader);
        this.setReportRunnable(runnable);
        ReportDocumentReader reportDocReaderImpl = (ReportDocumentReader)reader;
        Report reportIR = reportDocReaderImpl.getReportIR(this.executionContext.getReportDesign());
        this.executionContext.setReport(reportIR);
        this.report = this.executionContext.getReport();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        ClassLoader classLoader = this.executionContext.getApplicationClassLoader();
        this.setParameters(reportDocReaderImpl.loadParameters(classLoader));
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(reportDocReaderImpl.loadVariables(classLoader));
    }

    private void prepareMetaData() throws EngineException {
        if (this.isMetaDataPrepared) {
            return;
        }
        Map appContext = this.executionContext.getAppContext();
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, appContext);
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        for (Map.Entry entry : queryIds.entrySet()) {
            ReportItemDesign item;
            IQueryDefinition query;
            IDataQueryDefinition baseQuery = (IDataQueryDefinition)entry.getKey();
            String queryId = (String)entry.getValue();
            if (baseQuery instanceof IQueryDefinition) {
                query = (IQueryDefinition)baseQuery;
                item = (ReportItemDesign)query2itemMapping.get(query);
                String queryName = item.getName();
                if (queryName == null) {
                    queryName = "ELEMENT_" + item.getID();
                }
                this.queryId2NameMapping.put(queryId, queryName);
            } else if (baseQuery instanceof IBaseCubeQueryDefinition) {
                query = (IBaseCubeQueryDefinition)baseQuery;
                item = (ReportItemDesign)query2itemMapping.get(query);
                DesignElementHandle cube = item.getHandle();
                String name = cube.getStringProperty("cube");
                this.cubeNameList.add(name);
                this.queryId2NameMapping.put(queryId, name);
            }
            this.queryId2QueryMapping.put(queryId, baseQuery);
            this.query2QueryIdMapping.put(baseQuery, queryId);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IDataQueryDefinition getQuery(String queryId) {
        return (IDataQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    private void loadResultSetMetaData() {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            IDocArchiveReader reader = this.reportDocReader.getArchive();
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
            if (result != null) {
                HashSet<String> dteMetaInfoSet = new HashSet<String>();
                int i = 0;
                while (i < result.size()) {
                    String[] rsetRelation = (String[])result.get(i);
                    this.rssetIdMapping.put(this.getDteMetaInfoString(rsetRelation), rsetRelation[3]);
                    String dteMetaInfoString = this.getDteMetaInfoString(rsetRelation);
                    if (!dteMetaInfoSet.contains(dteMetaInfoString)) {
                        ReportItemDesign design;
                        ReportItemHandle handle;
                        ResultMetaData metaData;
                        dteMetaInfoSet.add(dteMetaInfoString);
                        String queryId = rsetRelation[2];
                        String rsetId = rsetRelation[3];
                        IDataQueryDefinition query = this.getQuery(queryId);
                        int count = -1;
                        Integer countObj = (Integer)queryCounts.get(queryId);
                        if (countObj != null) {
                            count = countObj;
                        }
                        String rsetName = this.getQueryName(queryId);
                        if (++count > 0) {
                            rsetName = String.valueOf(rsetName) + "_" + count;
                        }
                        queryCounts.put(queryId, new Integer(count));
                        if (query2ResultMetaData != null && (metaData = (ResultMetaData)query2ResultMetaData.get(query)) != null && metaData.getColumnCount() > 0 && (handle = (ReportItemHandle)(design = (ReportItemDesign)this.report.getReportItemToQueryMap().get(query)).getHandle()).allowExport()) {
                            ResultSetItem resultItem = new ResultSetItem(rsetName, metaData, (DesignElementHandle)handle, this.executionContext.getLocale());
                            this.resultMetaList.add(resultItem);
                            this.rsetName2IdMapping.put(rsetName, rsetId);
                            this.rsetId2queryIdMapping.put(rsetId, queryId);
                        }
                    }
                    ++i;
                }
            }
            if (this.isCubeExportEnabled && !this.cubeNameList.isEmpty()) {
                for (String name : this.cubeNameList) {
                    this.resultMetaList.add(new ResultSetItem(name, null));
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
    }

    private String getDteMetaInfoString(String[] rsetRelation) {
        StringBuffer buffer = new StringBuffer();
        String pRsetId = rsetRelation[0];
        String rowId = rsetRelation[1];
        String queryId = rsetRelation[2];
        buffer.setLength(0);
        if (pRsetId == null) {
            buffer.append("null");
        } else {
            buffer.append(pRsetId);
        }
        buffer.append(".");
        buffer.append(rowId);
        buffer.append(".");
        buffer.append(queryId);
        return buffer.toString();
    }

    InstanceID[] getAncestors(InstanceID id) {
        LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
        while (id != null) {
            iids.addFirst(id);
            id = id.getParentID();
        }
        return iids.toArray(new InstanceID[0]);
    }

    protected String queryId2rsetId(String id) {
        for (Map.Entry entry : this.rsetId2queryIdMapping.entrySet()) {
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        for (Map.Entry entry : this.rsetName2IdMapping.entrySet()) {
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    @Override
    public void setInstanceID(InstanceID iid) {
        assert (iid != null);
        try {
            this.prepareMetaData();
        }
        catch (EngineException e) {
            this.executionContext.addException(e);
        }
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    @Override
    public void selectResultSet(String displayName) {
        assert (displayName != null);
        try {
            this.prepareMetaData();
        }
        catch (EngineException e) {
            this.executionContext.addException(e);
        }
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    @Override
    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    @Override
    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            IResultMetaData metaData = null;
            try {
                metaData = this.getMetaDateByInstanceID(this.instanceId);
            }
            catch (BirtException ex) {
                throw new EngineException(ex);
            }
            if (metaData != null) {
                rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId.toUniqueString(), metaData));
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        for (IResultSetItem rsetItem : this.resultMetaList) {
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    @Override
    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    @Override
    public IExtractionResults extract() throws EngineException {
        IExtractionResults results = null;
        try {
            this.prepareMetaData();
            if (this.isCubeExportEnabled && this.cubeName != null) {
                if (this.cubeNameList != null && this.cubeNameList.contains(this.cubeName)) {
                    results = new CubeExtractionResults(this.reportDocReader.getArchive());
                }
            } else {
                if (this.resultSetName != null) {
                    results = this.extractByResultSetName(this.resultSetName);
                }
                if (this.instanceId != null) {
                    results = this.extractByInstanceID(this.instanceId);
                }
            }
            IExtractionResults iExtractionResults = results;
            return iExtractionResults;
        }
        catch (BirtException ex) {
            throw new EngineException(ex);
        }
        finally {
            if (this.executionContext.isCanceled()) {
                return null;
            }
        }
    }

    private void updatePlan(ArrayList<QueryTask> plan, int index, IBaseQueryDefinition query) {
        if (index < 0 || plan == null || plan.size() < index + 1) {
            return;
        }
        QueryTask task = plan.get(index);
        task.setQuery((IDataQueryDefinition)query);
    }

    private void updatePlanFully(ArrayList<QueryTask> plan, IBaseQueryDefinition query) {
        int index = 0;
        while (query != null && index <= plan.size()) {
            this.updatePlan(plan, index, query);
            ++index;
            query = query.getParentQuery();
        }
    }

    private String getQueryId(IDataQueryDefinition query) {
        String id = (String)this.tmpQuery2QueryIdMapping.get(query);
        if (id == null) {
            return (String)this.query2QueryIdMapping.get(query);
        }
        return id;
    }

    private IExtractionResults extractByResultSetName(String rsetName) throws BirtException {
        if (!this.rsetName2IdMapping.containsKey(rsetName)) {
            throw new EngineException("Error.ResultsetExtractError");
        }
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        String rsetId = this.rsetName2Id(rsetName);
        if (rsetId != null) {
            IResultMetaData metaData;
            IQueryResults results = null;
            String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
            QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
            if (query == null) {
                return null;
            }
            QueryDefinition newQuery = null;
            if (this.groupMode) {
                newQuery = this.cloneQuery(query);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
                newQuery.setQueryResultsID(rsetId);
            } else {
                QueryDefinition cloned = this.cloneQuery(query);
                cloned.setQueryResultsID(rsetId);
                newQuery = new QueryDefinition();
                newQuery.setSourceQuery((IBaseQueryDefinition)cloned);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
                this.setupDistinct(newQuery);
            }
            ScriptContext scriptContext = this.executionContext.getScriptContext();
            DataExtractionTaskV1.processQueryExtensions((IDataQueryDefinition)newQuery, this.executionContext);
            if (dataSession == null) {
                return null;
            }
            IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
            if (preparedQuery == null) {
                return null;
            }
            results = (IQueryResults)dataSession.execute((IBasePreparedQuery)preparedQuery, null, scriptContext);
            if (results != null && (metaData = this.getResultMetaData(rsetName)) != null) {
                return new ExtractionResults(results, metaData, this.selectedColumns, this.startRow, this.maxRows);
            }
        }
        return null;
    }

    private IExtractionResults extractByInstanceID(InstanceID instanceId) throws BirtException {
        IResultMetaData metaData;
        QueryDefinition newQuery;
        assert (instanceId != null);
        ArrayList<QueryTask> plan = QueryUtil.createPlan(this.report, instanceId);
        if (plan.size() == 0) {
            return null;
        }
        this.tmpQuery2QueryIdMapping.clear();
        IQueryResults queryResults = null;
        QueryTask task = plan.get(0);
        IBaseQueryDefinition query = (IBaseQueryDefinition)task.getQuery();
        QueryUtil.IResultSetIDProvider resultsIDProvider = new QueryUtil.IResultSetIDProvider(){

            public String getResultsID(String parent, String rawId, IDataQueryDefinition query) {
                String queryId = DataExtractionTaskV1.this.getQueryId(query);
                return DataExtractionTaskV1.this.getResultsetID(parent, rawId, queryId);
            }
        };
        if (this.groupMode) {
            newQuery = null;
            newQuery = this.cloneQuery(query);
            this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
            this.updatePlanFully(plan, (IBaseQueryDefinition)newQuery);
            IBaseResultSet rset = QueryUtil.executePlan(plan, 0, this.executionContext, resultsIDProvider);
            if (rset == null || !(rset.getQueryResults() instanceof IQueryResults)) {
                return null;
            }
            queryResults = (IQueryResults)rset.getQueryResults();
        } else {
            newQuery = new QueryDefinition();
            if (query instanceof IQueryDefinition) {
                QueryDefinition cloned = this.cloneQuery((QueryDefinition)query);
                this.updatePlanFully(plan, (IBaseQueryDefinition)cloned);
                IBaseResultSet rset = QueryUtil.executePlan(plan, 0, this.executionContext, resultsIDProvider);
                if (!(rset instanceof QueryResultSet)) {
                    return null;
                }
                cloned.setQueryResultsID(((QueryResultSet)rset).getQueryResultsID());
                newQuery.setSourceQuery((IBaseQueryDefinition)cloned);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
                this.setupDistinct(newQuery);
            } else {
                SubqueryDefinition clonedSubquery = this.cloneQuery2((SubqueryDefinition)query, task.getInstanceID());
                this.updatePlanFully(plan, (IBaseQueryDefinition)clonedSubquery);
                int index = 1;
                SubqueryDefinition topSubquery = clonedSubquery;
                while (topSubquery != null) {
                    if (topSubquery.getParentQuery() instanceof IQueryDefinition) break;
                    topSubquery = (ISubqueryDefinition)topSubquery.getParentQuery();
                    ++index;
                }
                IBaseResultSet rset = QueryUtil.executePlan(plan, index, this.executionContext, resultsIDProvider);
                if (!(rset instanceof QueryResultSet)) {
                    return null;
                }
                QueryDefinition parentQuery = (QueryDefinition)topSubquery.getParentQuery();
                QueryResultSet queryResultSet = (QueryResultSet)rset;
                parentQuery.setQueryResultsID(queryResultSet.getQueryResultsID());
                newQuery.setSourceQuery((IBaseQueryDefinition)clonedSubquery);
                this.setupDistinct(newQuery);
                this.setupQueryWithFilterAndSort((IBaseQueryDefinition)newQuery);
            }
            DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
            if (dataSession == null) {
                return null;
            }
            ScriptContext scriptContext = this.executionContext.getScriptContext();
            DataExtractionTaskV1.processQueryExtensions((IDataQueryDefinition)newQuery, this.executionContext);
            IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
            if (preparedQuery == null) {
                return null;
            }
            queryResults = (IQueryResults)dataSession.execute((IBasePreparedQuery)preparedQuery, null, scriptContext);
        }
        if (queryResults != null && (metaData = this.getMetaDateByInstanceID(instanceId)) != null) {
            return new ExtractionResults(queryResults, metaData, this.selectedColumns, this.startRow, this.maxRows);
        }
        return null;
    }

    private void setupQueryWithFilterAndSort(IBaseQueryDefinition query) {
        int iNum;
        if (this.filterExpressions != null) {
            iNum = 0;
            while (iNum < this.filterExpressions.length) {
                query.getFilters().add(this.filterExpressions[iNum]);
                ++iNum;
            }
            this.filterExpressions = null;
        }
        if (this.sortExpressions != null) {
            iNum = 0;
            while (iNum < this.sortExpressions.length) {
                query.getSorts().add(this.sortExpressions[iNum]);
                ++iNum;
            }
            this.sortExpressions = null;
        }
    }

    private void setupDistinct(QueryDefinition query) throws BirtException {
        IBaseQueryDefinition srcQuery;
        Map bindings;
        query.setDistinctValue(this.distinct);
        if (this.distinct && this.selectedColumns != null && (bindings = (srcQuery = query.getSourceQuery()).getBindings()) != null) {
            int index = 0;
            while (index < this.selectedColumns.length) {
                IBinding binding = (IBinding)bindings.get(this.selectedColumns[index]);
                if (binding != null) {
                    this.addQueryBinding(query, binding);
                }
                ++index;
            }
        }
    }

    private void addQueryBinding(QueryDefinition query, IBinding binding) throws BirtException {
        Binding newBinding = new Binding(binding.getBindingName());
        newBinding.setDataType(binding.getDataType());
        newBinding.setDisplayName(binding.getDisplayName());
        newBinding.setExportable(binding.exportable());
        String expr = ExpressionUtil.createDataSetRowExpression((String)newBinding.getBindingName());
        ScriptExpression dbExpr = new ScriptExpression(expr, newBinding.getDataType());
        newBinding.setExpression((IBaseExpression)dbExpr);
        query.addBinding((IBinding)newBinding);
    }

    private String getResultsetID(String prset, String rowId, String queryId) {
        String parentRSet = prset == null ? "null" : prset;
        String rsmeta = String.valueOf(parentRSet) + "." + rowId + "." + queryId;
        return (String)this.rssetIdMapping.get(rsmeta);
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) throws BirtException {
        while (iid != null) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IDataQueryDefinition query = design.getQuery();
            if (query != null) {
                ReportItemHandle handle = (ReportItemHandle)design.getHandle();
                if (!handle.allowExport()) {
                    return null;
                }
                HashMap query2ResultMetaData = this.report.getResultMetaData();
                if (query2ResultMetaData != null) {
                    if (query instanceof ISubqueryDefinition) {
                        return new SubqueryResultMetaData((ISubqueryDefinition)query, query2ResultMetaData);
                    }
                    return (ResultMetaData)query2ResultMetaData.get(query);
                }
                return null;
            }
            iid = iid.getParentID();
        }
        return null;
    }

    private BaseQueryDefinition cloneQuery2(IBaseQueryDefinition query, InstanceID instanceID) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery2((SubqueryDefinition)query, instanceID);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery2(SubqueryDefinition query, InstanceID instanceID) {
        while (instanceID.getDataID() == null) {
            instanceID = instanceID.getParentID();
        }
        InstanceID currentID = instanceID;
        BaseQueryDefinition parent = this.cloneQuery2(query.getParentQuery(), instanceID.getParentID());
        SubqueryLocator locator = new SubqueryLocator((int)currentID.getDataID().getRowID(), query.getName(), (IBaseQueryDefinition)parent);
        locator.getBindings().putAll(query.getBindings());
        locator.getSorts().addAll(query.getSorts());
        locator.getFilters().addAll(query.getFilters());
        locator.getSubqueries().addAll(query.getSubqueries());
        locator.getGroups().addAll(query.getGroups());
        locator.setUsesDetails(query.usesDetails());
        return locator;
    }

    private BaseQueryDefinition cloneQuery(IBaseQueryDefinition query) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery((SubqueryDefinition)query);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery(SubqueryDefinition query) {
        BaseQueryDefinition parent = this.cloneQuery(query.getParentQuery());
        SubqueryDefinition newQuery = new SubqueryDefinition(query.getName(), (IBaseQueryDefinition)parent);
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setApplyOnGroupFlag(query.applyOnGroup());
        parent.getSubqueries().add(newQuery);
        return newQuery;
    }

    private QueryDefinition cloneQuery(QueryDefinition query) {
        QueryDefinition newQuery = new QueryDefinition((BaseQueryDefinition)query.getParentQuery());
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        newQuery.setName(query.getName());
        newQuery.setIsSummaryQuery(query.isSummaryQuery());
        String queryID = (String)this.query2QueryIdMapping.get(query);
        this.tmpQuery2QueryIdMapping.put(newQuery, queryID);
        return newQuery;
    }

    @Override
    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    @Override
    public void setSorts(ISortDefinition[] simpleSortExpression) {
        this.sortExpressions = simpleSortExpression;
    }

    @Override
    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void extract(IExtractionOption options) throws BirtException {
        DataExtractionOption option = null;
        option = options == null ? new DataExtractionOption() : new DataExtractionOption(options.getOptions());
        IDataExtractionOption extractOption = this.setupExtractOption(option);
        IDataExtractionExtension dataExtraction = this.getDataExtractionExtension(extractOption);
        try {
            dataExtraction.initialize(this.executionContext.getReportContext(), extractOption);
            IExtractionResults results = this.extract();
            if (this.executionContext.isCanceled()) {
                return;
            }
            dataExtraction.output(results);
        }
        finally {
            dataExtraction.release();
        }
    }

    private IDataExtractionExtension getDataExtractionExtension(IDataExtractionOption option) throws EngineException {
        IDataExtractionExtension dataExtraction = null;
        String extension = option.getExtension();
        ExtensionManager extensionManager = ExtensionManager.getInstance();
        if (extension != null && (dataExtraction = extensionManager.createDataExtractionExtensionById(extension)) == null) {
            logger.log(Level.WARNING, "Extension with id " + extension + " doesn't exist.");
        }
        String format = null;
        if (dataExtraction == null && (format = option.getOutputFormat()) != null && (dataExtraction = extensionManager.createDataExtractionExtensionByFormat(format)) == null) {
            logger.log(Level.WARNING, "Extension of format " + format + " doesn't exist.");
        }
        if (dataExtraction == null) {
            throw new EngineException("Error.InvalidExtensionError", new Object[]{extension, format});
        }
        return dataExtraction;
    }

    @Override
    public void setStartRow(int startRow) {
        this.startRow = startRow;
        if (startRow > 0) {
            this.groupMode = false;
        }
    }

    @Override
    public void setDistinctValuesOnly(boolean distinct) {
        this.distinct = distinct;
        if (distinct) {
            this.groupMode = false;
        }
    }

    protected static void processQueryExtensions(IDataQueryDefinition query, ExecutionContext executionContext) throws EngineException {
        String[] extensions = executionContext.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = executionContext.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    private IDataExtractionOption setupExtractOption(IDataExtractionOption options) {
        IRenderOption defaultHtmlOptions;
        HashMap allOptions = new HashMap();
        HashMap configs = this.engine.getConfig().getEmitterConfigs();
        IRenderOption defaultOptions = (IRenderOption)configs.get("org.eclipse.birt.report.engine.api.EngineConfig.defaultRenderOption");
        if (defaultOptions != null) {
            allOptions.putAll(defaultOptions.getOptions());
        }
        if ((defaultHtmlOptions = (IRenderOption)configs.get("html")) != null) {
            allOptions.putAll(defaultHtmlOptions.getOptions());
        }
        allOptions.putAll(options.getOptions());
        Map appContext = this.executionContext.getAppContext();
        Object renderContext = appContext.get("HTML_RENDER_CONTEXT");
        if (renderContext == null) {
            HTMLRenderContext htmlContext = new HTMLRenderContext();
            HTMLRenderOption htmlOptions = new HTMLRenderOption(allOptions);
            htmlContext.setBaseImageURL(htmlOptions.getBaseImageURL());
            htmlContext.setBaseURL(htmlOptions.getBaseURL());
            htmlContext.setImageDirectory(htmlOptions.getImageDirectory());
            htmlContext.setSupportedImageFormats(htmlOptions.getSupportedImageFormats());
            htmlContext.SetRenderOption(htmlOptions);
            appContext.put("HTML_RENDER_CONTEXT", htmlContext);
        }
        if (options instanceof CubeDataExtractionOption) {
            CubeDataExtractionOption cubeOption = (CubeDataExtractionOption)options;
            this.cubeName = cubeOption.getCubeName();
            return options;
        }
        this.cubeName = null;
        DataExtractionOption extractOption = new DataExtractionOption(allOptions);
        if (extractOption.getInstanceID() == null && this.instanceId != null) {
            extractOption.setInstanceID(this.instanceId);
        }
        return extractOption;
    }

    @Override
    public void setCubeExportEnabled(boolean isCubeExportEnabled) {
        this.isCubeExportEnabled = isCubeExportEnabled;
    }

    @Override
    public boolean isCubeExportEnabled() {
        return this.isCubeExportEnabled;
    }
}

