/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.cm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.facelet.core.internal.cm.CompositeTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.DocumentNamespaceCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.MetadataTagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.cm.NamespaceCMAdapter;
import org.eclipse.jst.jsf.facelet.core.internal.cm.TagInfo;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletRegistryManager;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.w3c.dom.Element;

public class FaceletDocumentFactory {
    private final IProject _project;
    private final Map<String, NamespaceCMAdapter> _cmDocuments;
    private final Map<String, TagInfo> _externalTagInfo;

    public FaceletDocumentFactory(IProject project) {
        this._project = project;
        this._cmDocuments = new HashMap<String, NamespaceCMAdapter>(8);
        this._externalTagInfo = new HashMap<String, TagInfo>(8);
    }

    public CMDocument createCMDocumentForContext(String uri, String prefix) {
        NamespaceCMAdapter cmDoc = this.getOrCreateCMDocument(this._project, uri);
        if (cmDoc != null) {
            return new DocumentNamespaceCMAdapter(cmDoc, prefix);
        }
        return null;
    }

    public CMElementDeclaration createCMElementDeclaration(Element element) {
        CMDocument cmDoc;
        String prefix = element.getPrefix();
        Map<String, ViewUtil.PrefixEntry> namespaces = ViewUtil.getDocumentNamespaces(element.getOwnerDocument());
        ViewUtil.PrefixEntry prefixEntry = namespaces.get(prefix);
        if (prefixEntry != null && (cmDoc = this.createCMDocumentForContext(prefixEntry.getUri(), prefixEntry.getPrefix())) != null) {
            return (CMElementDeclaration)cmDoc.getElements().getNamedItem(element.getLocalName());
        }
        return null;
    }

    public TagInfo getOrCreateExtraTagInfo(String ns) {
        TagInfo tagInfo = this._externalTagInfo.get(ns);
        if (tagInfo == null) {
            tagInfo = this.createExternalTagInfo(ns);
            this._externalTagInfo.put(ns, tagInfo);
        }
        return tagInfo;
    }

    private TagInfo createExternalTagInfo(String uri) {
        JSFVersion jsfVersion = JSFVersion.valueOfProject((IProject)this._project);
        CompositeTagInfo tldTagInfo = null;
        if (jsfVersion != null) {
            if (jsfVersion.compareTo((Enum)JSFVersion.V2_0) >= 0) {
                tldTagInfo = new FaceletTagInfo(this._project, uri);
            } else {
                ITaglibRecord[] tldrecs;
                ITaglibRecord[] iTaglibRecordArray = tldrecs = TaglibIndex.getAvailableTaglibRecords((IPath)this._project.getFullPath());
                int n = tldrecs.length;
                int n2 = 0;
                while (n2 < n) {
                    ITaglibRecord rec = iTaglibRecordArray[n2];
                    String matchUri = rec.getDescriptor().getURI();
                    if (uri.equals(matchUri)) {
                        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
                        tldTagInfo = new MetadataTagInfo(this._project, (TLDDocument)factory.createCMDocument(rec));
                        break;
                    }
                    ++n2;
                }
                if (tldTagInfo == null) {
                    tldTagInfo = new MetadataTagInfo(this._project, uri);
                }
            }
        }
        return tldTagInfo;
    }

    private NamespaceCMAdapter getOrCreateCMDocument(IProject project, String uri) {
        NamespaceCMAdapter adapter = this._cmDocuments.get(uri);
        if (adapter == null) {
            FaceletRegistryManager.MyRegistryFactory factory = new FaceletRegistryManager.MyRegistryFactory();
            try {
                Namespace ns;
                ITagRegistry registry = factory.createTagRegistry(project);
                if (registry != null && (ns = registry.getTagLibrary(uri)) != null) {
                    adapter = new NamespaceCMAdapter(ns, project);
                    this._cmDocuments.put(uri, adapter);
                }
            }
            catch (TagRegistryFactory.TagRegistryFactoryException tagRegistryFactoryException) {}
        }
        return adapter;
    }
}

