/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.Vector;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.business.BusinessEntity;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class WSI3007
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public WSI3007(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        BindingTemplate bindingTemplate = (BindingTemplate)entryContext.getEntry().getEntryDetail();
        boolean validService = false;
        boolean validBusiness = false;
        String serviceKey = null;
        String businessKey = null;
        try {
            serviceKey = bindingTemplate.getServiceKey();
            BusinessService service = UDDIUtils.getBusinessServiceByKey(this.validator.uddiProxy, serviceKey);
            businessKey = service.getBusinessKey();
            BusinessEntity business = UDDIUtils.getBusinessByKey(this.validator.uddiProxy, businessKey);
            validService = this.checkCategoryBag(this.validator.uddiProxy, service.getCategoryBag());
            validBusiness = this.checkCategoryBag(this.validator.uddiProxy, business.getCategoryBag());
            if (!validBusiness || !validService) {
                this.result = "failed";
                if (!validBusiness) {
                    this.failureDetailMessage = "The businessEntity key is: [" + businessKey + "].";
                }
                if (!validService) {
                    this.failureDetailMessage = !validBusiness ? String.valueOf(this.failureDetailMessage) + " " : "";
                    this.failureDetailMessage = String.valueOf(this.failureDetailMessage) + "The businessService key is: [" + serviceKey + "].";
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.result = "failed";
            this.failureDetailMessage = "The UDDI registry does not contain WSI conformance taxonomy tModel (\"ws-i-org:conformsTo:2002_12\").";
        }
        catch (Throwable e) {
            throw new WSIException("An exception occurred while processing the discovery test assertions.", e);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }

    private boolean checkCategoryBag(UDDIProxy proxy, CategoryBag bag) {
        String conformanceKey = null;
        try {
            conformanceKey = UDDIUtils.getWSIConformanceTModelKey(proxy);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        boolean result = true;
        if (bag != null) {
            Vector references = bag.getKeyedReferenceVector();
            int i = 0;
            while (i < references.size() && result) {
                KeyedReference ref = (KeyedReference)references.get(i);
                result = !ref.getTModelKey().equalsIgnoreCase(conformanceKey);
                ++i;
            }
        }
        return result;
    }
}

