/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.ui.uploaders;

import java.io.File;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.filtering.UsageDataEventFilter;
import org.eclipse.epp.usagedata.internal.recording.settings.UsageDataRecordingSettings;
import org.eclipse.epp.usagedata.internal.recording.uploading.AbstractUploader;
import org.eclipse.epp.usagedata.internal.recording.uploading.BasicUploader;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadListener;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadResult;
import org.eclipse.epp.usagedata.internal.ui.wizards.AskUserUploaderWizard;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AskUserUploader
extends AbstractUploader {
    public static final int UPLOAD_NOW = 0;
    public static final int UPLOAD_ALWAYS = 1;
    public static final int DONT_UPLOAD = 2;
    public static final int NEVER_UPLOAD = 3;
    private BasicUploader basicUploader;
    private WizardDialog dialog;
    private int action = 0;
    private boolean userAcceptedTermsOfUse;

    public void startUpload() {
        this.checkValues();
        if (this.needToOpenWizard()) {
            this.openUploadWizard();
        } else {
            this.startBasicUpload();
        }
    }

    protected boolean needToOpenWizard() {
        if (this.getSettings().shouldAskBeforeUploading()) {
            return true;
        }
        return !this.getSettings().hasUserAcceptedTermsOfUse();
    }

    private void openUploadWizard() {
        this.action = this.getDefaultAction();
        this.userAcceptedTermsOfUse = this.getSettings().hasUserAcceptedTermsOfUse();
        final AskUserUploaderWizard wizard = new AskUserUploaderWizard(this);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                AskUserUploader.this.dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                AskUserUploader.this.dialog.setBlockOnOpen(false);
                AskUserUploader.this.dialog.open();
            }

            private Shell getShell() {
                return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            }
        });
    }

    private int getDefaultAction() {
        if (this.getSettings().isEnabled()) {
            if (this.needToOpenWizard()) {
                return 0;
            }
            return 1;
        }
        return 3;
    }

    private UsageDataRecordingSettings getSettings() {
        return UsageDataRecordingActivator.getDefault().getSettings();
    }

    public synchronized boolean isUploadInProgress() {
        if (this.isWizardOpen()) {
            return true;
        }
        if (this.basicUploader != null) {
            return this.basicUploader.isUploadInProgress();
        }
        return false;
    }

    private boolean isWizardOpen() {
        if (this.dialog == null) {
            return false;
        }
        return this.dialog.getShell().isVisible();
    }

    public synchronized void cancel() {
        this.dialog = null;
        this.fireUploadComplete(new UploadResult(0));
    }

    public synchronized void execute() {
        this.dialog = null;
        this.getSettings().setAskBeforeUploading(this.action != 1);
        this.getSettings().setEnabled(this.action != 3);
        this.getSettings().setUserAcceptedTermsOfUse(this.userAcceptedTermsOfUse);
        if (this.action == 1 || this.action == 0) {
            this.startBasicUpload();
        } else {
            this.fireUploadComplete(new UploadResult(0));
        }
    }

    private void startBasicUpload() {
        this.basicUploader = new BasicUploader(this.getUploadParameters());
        this.basicUploader.addUploadListener(new UploadListener(){

            public void uploadComplete(UploadResult result) {
                AskUserUploader.this.fireUploadComplete(result);
                AskUserUploader.this.basicUploader = null;
            }
        });
        this.basicUploader.startUpload();
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public boolean hasUserAcceptedTermsOfUse() {
        return this.userAcceptedTermsOfUse;
    }

    public void setUserAcceptedTermsOfUse(boolean value) {
        this.userAcceptedTermsOfUse = value;
    }

    public boolean hasUploadAction() {
        if (this.action == 1) {
            return true;
        }
        return this.action == 0;
    }

    public File[] getFiles() {
        return this.getUploadParameters().getFiles();
    }

    public UsageDataEventFilter getFilter() {
        return this.getUploadParameters().getFilter();
    }
}

