/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.common.jdt.internal.javalite.IJavaProjectLite;
import org.eclipse.jst.common.jdt.internal.javalite.JavaCoreLite;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.classpathdep.IClasspathDependencyConstants;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.internal.ManifestUIResourceHandler;
import org.eclipse.jst.j2ee.internal.modulecore.util.DummyClasspathDependencyContainerVirtualComponent;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.ui.preferences.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IReferenceEditor;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.internal.ui.WTPUIPlugin;
import org.eclipse.wst.common.frameworks.internal.ui.WorkspaceModifyComposedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathDependencyWizardFragment
extends WizardFragment
implements IReferenceEditor {
    private CheckboxTreeViewer viewer;
    private IWizardHandle handle;
    private HashMap<IProject, WrappedClasspathEntry[]> map = new HashMap();
    private ArrayList<WrappedClasspathEntry> originallyChecked = new ArrayList();
    boolean isComplete = false;

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean hasComposite() {
        return true;
    }

    public boolean canEdit(IVirtualReference ref) {
        return ref.getReferencedComponent() instanceof DummyClasspathDependencyContainerVirtualComponent;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        handle.setTitle(Messages.ClasspathDependencyFragmentTitle);
        handle.setDescription(Messages.ClasspathDependencyFragmentDescription);
        this.viewer = new CheckboxTreeViewer(c);
        this.viewer.setContentProvider((IContentProvider)new ClasspathPushupContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ClasspathPushupLabelProvider());
        try {
            this.loadModel();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.viewer.setInput((Object)ResourcesPlugin.getPlugin());
        this.viewer.expandAll();
        this.viewer.setGrayedElements((Object[])this.getSuitableProjects());
        this.viewer.setCheckedElements((Object[])this.originallyChecked.toArray(new WrappedClasspathEntry[this.originallyChecked.size()]));
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ClasspathDependencyWizardFragment.this.handleCheckEvent(event);
            }
        });
        GridData data = new GridData(1808);
        data.widthHint = 390;
        data.heightHint = 185;
        this.viewer.getTree().setLayoutData((Object)data);
        return c;
    }

    protected void handleCheckEvent(CheckStateChangedEvent event) {
        if (event.getChecked() && event.getElement() instanceof IProject) {
            this.viewer.setChecked(event.getElement(), false);
        }
        if (event.getElement() instanceof WrappedClasspathEntry) {
            WrappedClasspathEntry wce = (WrappedClasspathEntry)event.getElement();
            wce.postStatus = event.getChecked();
        }
        Iterator<IProject> i = this.map.keySet().iterator();
        boolean hasChanged = false;
        while (i.hasNext()) {
            IProject p = i.next();
            WrappedClasspathEntry[] entries = this.map.get(p);
            int j = 0;
            while (j < entries.length) {
                if (entries[j].postStatus != entries[j].preStatus) {
                    hasChanged = true;
                    break;
                }
                ++j;
            }
            if (hasChanged) break;
        }
        if (this.isComplete != hasChanged) {
            this.isComplete = hasChanged;
            this.handle.update();
        }
    }

    private WrappedClasspathEntry[] wrapClasspathEntries(IClasspathEntry[] entries, IProject project, boolean preStatus) {
        WrappedClasspathEntry[] results = new WrappedClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            results[i] = new WrappedClasspathEntry(entries[i], project, preStatus, preStatus);
            ++i;
        }
        return results;
    }

    private WrappedClasspathEntry[] loadEntriesForProject(IProject parentElement) {
        ArrayList<WrappedClasspathEntry> ret = new ArrayList<WrappedClasspathEntry>();
        try {
            Map results = ClasspathDependencyUtil.getRawComponentClasspathDependencies((IJavaProjectLite)JavaCoreLite.create((IProject)parentElement), (IClasspathDependencyConstants.DependencyAttributeType)IClasspathDependencyConstants.DependencyAttributeType.CLASSPATH_COMPONENT_DEPENDENCY);
            Set setResult = results.keySet();
            IClasspathEntry[] setResultArray = setResult.toArray(new IClasspathEntry[setResult.size()]);
            WrappedClasspathEntry[] wrappedArray = this.wrapClasspathEntries(setResultArray, parentElement, true);
            this.originallyChecked.addAll(Arrays.asList(wrappedArray));
            ret.addAll(Arrays.asList(wrappedArray));
            List potentialList = ClasspathDependencyUtil.getPotentialComponentClasspathDependencies((IJavaProjectLite)JavaCoreLite.create((IProject)parentElement));
            IClasspathEntry[] potentials = potentialList.toArray(new IClasspathEntry[potentialList.size()]);
            ret.addAll(Arrays.asList(this.wrapClasspathEntries(potentials, parentElement, false)));
        }
        catch (CoreException coreException) {}
        return ret.toArray(new WrappedClasspathEntry[ret.size()]);
    }

    protected IProject[] getSuitableProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> projs = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].hasNature(JavaCoreLite.NATURE_ID) && ModuleCoreNature.isFlexibleProject((IProject)projects[i])) {
                    projs.add(projects[i]);
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return projs.toArray(new IProject[projs.size()]);
    }

    protected void loadModel() {
        IProject[] projects = this.getSuitableProjects();
        int i = 0;
        while (i < projects.length) {
            this.map.put(projects[i], this.loadEntriesForProject(projects[i]));
            ++i;
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        boolean anyChecked = false;
        Iterator<IProject> i = this.map.keySet().iterator();
        WorkspaceModifyComposedOperation composedOp = new WorkspaceModifyComposedOperation();
        while (i.hasNext()) {
            IProject p = i.next();
            WrappedClasspathEntry[] entries = this.map.get(p);
            ArrayList<WrappedClasspathEntry> changed = new ArrayList<WrappedClasspathEntry>();
            int j = 0;
            while (j < entries.length) {
                if (entries[j].postStatus) {
                    anyChecked = true;
                }
                if (entries[j].preStatus != entries[j].postStatus) {
                    changed.add(entries[j]);
                }
                ++j;
            }
            if (changed.isEmpty()) continue;
            this.prepareChanges(composedOp, changed, p);
        }
        try {
            composedOp.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            final InvocationTargetException ex2 = e;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    String title;
                    Shell shell = ((WizardPage)ClasspathDependencyWizardFragment.this.handle).getShell();
                    String msg = title = ManifestUIResourceHandler.An_internal_error_occurred_ERROR_;
                    if (ex2.getTargetException() != null && ex2.getTargetException().getMessage() != null) {
                        msg = ex2.getTargetException().getMessage();
                    }
                    MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                    Logger.getLogger().logError((Throwable)ex2);
                }
            });
        }
        catch (InterruptedException interruptedException) {}
        if (anyChecked) {
            IProject project = (IProject)this.getTaskModel().getObject("root.project");
            IVirtualComponent root = (IVirtualComponent)this.getTaskModel().getObject("root.component");
            DummyClasspathDependencyContainerVirtualComponent imported = new DummyClasspathDependencyContainerVirtualComponent(project, root);
            VirtualReference ref = new VirtualReference(root, (IVirtualComponent)imported);
            ref.setDerived(true);
            ref.setRuntimePath((IPath)new Path("/"));
            this.getTaskModel().putObject("dependency.reference.final", (Object)ref);
        } else {
            this.getTaskModel().putObject("dependency.reference.final", null);
        }
    }

    protected void prepareChanges(WorkspaceModifyComposedOperation composedOp, ArrayList<WrappedClasspathEntry> elements, IProject project) {
        HashMap<IClasspathEntry, IPath> selectedEntriesToRuntimePath = new HashMap<IClasspathEntry, IPath>();
        HashMap<IClasspathEntry, IPath> unselectedEntriesToRuntimePath = new HashMap<IClasspathEntry, IPath>();
        IPath runtimePath = IClasspathDependencyConstants.RUNTIME_MAPPING_INTO_CONTAINER_PATH;
        int i = 0;
        while (i < elements.size()) {
            WrappedClasspathEntry wrapped = elements.get(i);
            IClasspathEntry entry = wrapped.entry;
            if (!wrapped.preStatus && wrapped.postStatus) {
                selectedEntriesToRuntimePath.put(entry, runtimePath);
            } else if (wrapped.preStatus && !wrapped.postStatus) {
                unselectedEntriesToRuntimePath.put(entry, runtimePath);
            }
            ++i;
        }
        if (!selectedEntriesToRuntimePath.isEmpty()) {
            IDataModelOperation op = UpdateClasspathAttributeUtil.createAddDependencyAttributesOperation((String)project.getName(), selectedEntriesToRuntimePath);
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op));
        }
        if (!unselectedEntriesToRuntimePath.isEmpty()) {
            IDataModelOperation op = UpdateClasspathAttributeUtil.createRemoveDependencyAttributesOperation((String)project.getName(), unselectedEntriesToRuntimePath);
            composedOp.addRunnable((IRunnableWithProgress)WTPUIPlugin.getRunnableWithProgress((IUndoableOperation)op));
        }
    }

    private class ClasspathPushupContentProvider
    implements ITreeContentProvider {
        private ClasspathPushupContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProject) {
                Object[] ret = (Object[])ClasspathDependencyWizardFragment.this.map.get(parentElement);
                return ret == null ? new Object[]{} : ret;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return ClasspathDependencyWizardFragment.this.getSuitableProjects();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ClasspathPushupLabelProvider
    extends LabelProvider {
        private Image classpathImage = null;

        private ClasspathPushupLabelProvider() {
        }

        public void dispose() {
            super.dispose();
            if (this.classpathImage != null && !this.classpathImage.isDisposed()) {
                this.classpathImage.dispose();
            }
        }

        public Image getImage(Object element) {
            if (element instanceof IProject) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            if (this.classpathImage == null) {
                ImageDescriptor imageDescriptor = null;
                URL gifImageURL = (URL)J2EEPlugin.getPlugin().getImage("CPDep");
                imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
                this.classpathImage = imageDescriptor.createImage();
            }
            return this.classpathImage;
        }

        public String getText(Object element) {
            block6: {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                if (element instanceof WrappedClasspathEntry) {
                    try {
                        WrappedClasspathEntry entry = (WrappedClasspathEntry)element;
                        if (entry.entry.getEntryKind() == 5) {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.entry.getPath(), (IJavaProject)JavaCore.create((IProject)entry.project));
                            if (container != null) {
                                return container.getDescription();
                            }
                            break block6;
                        }
                        return entry.entry.getPath().toOSString();
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            return element == null ? "" : element.toString();
        }
    }

    private class WrappedClasspathEntry {
        public IClasspathEntry entry;
        public IProject project;
        boolean preStatus;
        boolean postStatus;

        public WrappedClasspathEntry(IClasspathEntry entry2, IProject project2, boolean preStatus2, boolean postStatus2) {
            this.entry = entry2;
            this.project = project2;
            this.preStatus = preStatus2;
            this.postStatus = postStatus2;
        }
    }
}

