/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ChoicePropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ChoicePropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.choice";

    public ChoicePropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, element, defn, (String)value);
        }
        logger.log(Level.SEVERE, "Invalid choice value type:" + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
    }

    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        IChoiceSet allowedChoices = defn.getAllowedChoices();
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(tmpValue);
        if (choice != null) {
            return choice.getName();
        }
        IChoiceSet propChoices = defn.getChoices();
        if (propChoices.contains(tmpValue)) {
            logger.log(Level.SEVERE, "Not allowed choice " + tmpValue);
            throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.CHOICE_NOT_ALLOWED", this.getTypeCode());
        }
        logger.log(Level.SEVERE, "Not found choice: " + tmpValue);
        throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.CHOICE_NOT_FOUND", this.getTypeCode());
    }

    public int getTypeCode() {
        return 5;
    }

    public String getName() {
        return "choice";
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        IChoiceSet propChoices = defn.getChoices();
        assert (propChoices != null);
        if (value == null) {
            return null;
        }
        IChoice choice = propChoices.findChoice((String)value);
        if (choice != null) {
            return choice.getName();
        }
        return value.toString();
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object name) {
        if (name == null) {
            return null;
        }
        IChoiceSet propChoices = defn.getChoices();
        assert (propChoices != null);
        IChoice choice = propChoices.findChoice(name.toString());
        if (choice != null) {
            return choice.getDisplayName();
        }
        assert (false);
        return null;
    }

    public Object validateInputString(Module module, DesignElement element, PropertyDefn defn, String name) throws PropertyValueException {
        if ((name = StringUtil.trimString(name)) == null) {
            return null;
        }
        IChoiceSet allowedChoices = defn.getAllowedChoices();
        assert (allowedChoices != null);
        IChoice choice = allowedChoices.findChoice(name);
        if (choice != null) {
            return choice.getName();
        }
        choice = null;
        choice = !allowedChoices.isUserDefined() ? allowedChoices.findChoiceByDisplayName(name) : allowedChoices.findUserChoiceByDisplayName(module, name);
        if (choice != null) {
            return choice.getName();
        }
        IChoiceSet propChoices = defn.getChoices();
        if (propChoices.contains(name)) {
            logger.log(Level.SEVERE, "Not allowed choice " + name);
            throw new PropertyValueException((Object)name, "Error.PropertyValueException.CHOICE_NOT_ALLOWED", this.getTypeCode());
        }
        logger.log(Level.SEVERE, "Invalid choice:" + name);
        throw new PropertyValueException((Object)name, "Error.PropertyValueException.CHOICE_NOT_FOUND", this.getTypeCode());
    }
}

