/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.SimpleIterator;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StructureIterator;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementRefPropertyType;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;
import org.eclipse.birt.report.model.util.ModelUtil;

public abstract class SimpleValueHandle
extends ValueHandle {
    public SimpleValueHandle(DesignElementHandle element) {
        super(element);
    }

    public abstract IPropertyDefn getDefn();

    protected abstract Object getRawValue();

    public final Object getValue() {
        Object rawValue = this.getRawValue();
        return ModelUtil.wrapPropertyValue(this.getModule(), (PropertyDefn)this.getDefn(), rawValue);
    }

    public int getIntValue() {
        return ((PropertyDefn)this.getDefn()).getIntValue(this.getModule(), this.getValue());
    }

    public String getStringValue() {
        return ((PropertyDefn)this.getDefn()).getStringValue(this.getModule(), this.getValue());
    }

    public double getFloatValue() {
        return ((PropertyDefn)this.getDefn()).getFloatValue(this.getModule(), this.getValue());
    }

    public BigDecimal getNumberValue() {
        return ((PropertyDefn)this.getDefn()).getNumberValue(this.getModule(), this.getValue());
    }

    public ArrayList getListValue() {
        Object value = this.getValue();
        if (value instanceof ArrayList) {
            ArrayList retValue = new ArrayList();
            retValue.addAll((ArrayList)value);
            return retValue;
        }
        return null;
    }

    public String getDisplayValue() {
        return ((PropertyDefn)this.getDefn()).getDisplayValue(this.getModule(), this.getValue());
    }

    public StructureHandle getAt(int n) {
        if (this.isList()) {
            return (StructureHandle)this.get(n);
        }
        return null;
    }

    public Object get(int n) {
        ArrayList values = this.getListValue();
        if (n < 0 || values == null || values.isEmpty() || n >= values.size()) {
            return null;
        }
        Object item = values.get(n);
        if (item instanceof Structure) {
            return ((Structure)item).getHandle(this, n);
        }
        if (item instanceof ElementRefValue) {
            ElementRefValue refValue = (ElementRefValue)item;
            if (refValue.isResolved()) {
                return refValue.getElement().getHandle(refValue.getElement().getRoot());
            }
            return refValue.getQualifiedReference();
        }
        return item;
    }

    public int indexOf(Object o) {
        Object rawValue = this.getRawValue();
        if (!(rawValue instanceof List)) {
            return -1;
        }
        List values = (List)rawValue;
        if (values.isEmpty()) {
            return -1;
        }
        if (this.getTypeCode() == 16) {
            if (o instanceof StructureHandle) {
                return values.indexOf(((StructureHandle)o).getStructure());
            }
            return values.indexOf(o);
        }
        if (this.getTypeCode() == 20) {
            PropertyDefn defn = (PropertyDefn)this.getDefn();
            if (defn.getSubTypeCode() == 15) {
                if (o instanceof DesignElementHandle) {
                    DesignElementHandle handle = (DesignElementHandle)o;
                    ElementRefValue value = new ElementRefValue(handle.getModule().getNamespace(), handle.getElement());
                    return values.indexOf(value);
                }
                if (o instanceof DesignElement) {
                    DesignElement e = (DesignElement)o;
                    String prefix = e.getRoot() == null ? null : e.getRoot().getNamespace();
                    ElementRefValue value = new ElementRefValue(prefix, e);
                    return values.indexOf(value);
                }
                if (o instanceof String) {
                    String stringValue = (String)o;
                    ElementRefValue value = new ElementRefValue(StringUtil.extractNamespace(stringValue), StringUtil.extractName(stringValue));
                    ElementRefPropertyType type = new ElementRefPropertyType();
                    type.resolve(this.getModule(), this.getElement(), defn, value);
                    return values.indexOf(value);
                }
                return values.indexOf(o);
            }
            return values.indexOf(o);
        }
        return values.indexOf(o);
    }

    public int getTypeCode() {
        return this.getDefn().getTypeCode();
    }

    public Iterator iterator() {
        if (this.isList()) {
            return new StructureIterator(this);
        }
        if (this.getTypeCode() == 20) {
            return new SimpleIterator(this);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void setIntValue(int value) throws SemanticException {
        this.setValue(value);
    }

    public void setStringValue(String value) throws SemanticException {
        this.setValue(value);
    }

    public void setFloatValue(double value) throws SemanticException {
        this.setValue(new Double(value));
    }

    public void setNumberValue(BigDecimal value) throws SemanticException {
        this.setValue(value);
    }

    public void clearValue() throws SemanticException {
        this.setValue(null);
    }

    public abstract void setValue(Object var1) throws SemanticException;

    public abstract void removeItem(int var1) throws PropertyValueException;

    public final void removeItem(Object item) throws PropertyValueException {
        int posn = this.indexOf(item);
        this.removeItem(posn);
    }

    public void removeItems(List items) throws PropertyValueException {
        if (items == null || items.isEmpty()) {
            return;
        }
        ActivityStack stack = this.getModule().getActivityStack();
        stack.startTrans(CommandLabelFactory.getCommandLabel("Message.RemoveItem"));
        try {
            int i = 0;
            while (i < items.size()) {
                int posn = this.indexOf(items.get(i));
                this.removeItem(posn);
                ++i;
            }
        }
        catch (PropertyValueException e) {
            stack.rollback();
            throw e;
        }
        stack.commit();
    }

    public void replaceItem(IStructure oldItem, IStructure newItem) throws SemanticException {
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.replaceItem(this.getContext(), oldItem, newItem);
    }

    public StructureHandle addItem(IStructure item) throws SemanticException {
        if (item == null) {
            return null;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        Object struct = cmd.addItem(this.getContext(), (Object)item);
        return ((Structure)struct).getHandle(this);
    }

    public abstract void addItem(Object var1) throws SemanticException;

    public StructureHandle insertItem(IStructure item, int posn) throws SemanticException {
        if (item == null) {
            return null;
        }
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        IStructure struct = cmd.insertItem(this.getContext(), item, posn);
        return ((Structure)struct).getHandle(this);
    }

    public void moveItem(int from, int to) throws PropertyValueException {
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.moveItem(this.getContext(), from, to);
    }

    public IChoice[] getChoices() {
        IPropertyDefn propDefn = this.getDefn();
        return propDefn.getChoices() == null ? null : propDefn.getChoices().getChoices();
    }

    protected boolean isList() {
        return this.getDefn().getTypeCode() == 16 && this.getDefn().isList();
    }

    public String getDefaultUnit() {
        if (this.getTypeCode() == 3) {
            PropertyDefn defn = (PropertyDefn)this.getDefn();
            String unit = defn.getDefaultUnit();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            unit = this.getModule().getUnits();
            if (!StringUtil.isBlank(unit)) {
                return unit;
            }
            if (this.getModule().getSession() != null) {
                return this.getModule().getSession().getUnits();
            }
        }
        return "";
    }

    public abstract boolean isVisible();

    public abstract boolean isReadOnly();
}

