/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAction;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnBandData;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableColumnBandAdapter;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.util.CommandLabelFactory;

class ColumnBandShiftAction
extends ColumnBandAction {
    public ColumnBandShiftAction(ColumnBandAdapter adapter) {
        super(adapter);
    }

    protected ColumnBandData getShiftData(int sourceIndex) throws SemanticException {
        ColumnBandData data;
        block6: {
            if (sourceIndex <= 0) {
                throw new IllegalArgumentException("wrong column to shift");
            }
            data = new ColumnBandData();
            TableColumn column = ColumnHelper.findColumn(this.adapter.getModule(), this.adapter.getColumns().getSlot(), sourceIndex);
            if (column != null) {
                try {
                    column = (TableColumn)column.clone();
                    column.setProperty("repeat", (Object)1);
                    data.setColumn(column);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
        }
        List cells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(sourceIndex));
        data.setCells(cells);
        if (!this.isRectangleArea(cells, 1)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceIndex), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        if (this.adapter.hasDroppingCell(cells)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceIndex), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_COPY_FORBIDDEN");
        }
        return data;
    }

    private int adjustDestPosn(int posn, int newPosn) {
        int columnCount = this.adapter.getColumnCount();
        if (newPosn > columnCount) {
            return columnCount;
        }
        if (posn == newPosn || newPosn + 1 == posn) {
            return -1;
        }
        return newPosn;
    }

    protected void shiftColumnBand(int sourceColumn, int destColumn) throws SemanticException {
        ColumnBandData data = this.getShiftData(sourceColumn);
        int newPosn = this.adjustDestPosn(sourceColumn, destColumn);
        if (newPosn == -1) {
            return;
        }
        if (!this.checkTargetColumn(sourceColumn, destColumn)) {
            throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{Integer.toString(sourceColumn), this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_PASTE_FORBIDDEN");
        }
        ActivityStack as = this.adapter.getModule().getActivityStack();
        try {
            if (this.adapter instanceof TableColumnBandAdapter) {
                as.startSilentTrans(CommandLabelFactory.getCommandLabel("Message.ShiftColumnBand"));
            } else {
                as.startTrans(CommandLabelFactory.getCommandLabel("Message.ShiftColumnBand"));
            }
            this.shiftColumn(data.getColumn(), sourceColumn, newPosn);
            this.shiftCells(data.getCells(), sourceColumn, newPosn);
        }
        catch (SemanticException e) {
            as.rollback();
            throw e;
        }
        as.commit();
    }

    private void shiftColumn(TableColumn column, int sourceIndex, int destIndex) throws SemanticException {
        if (column == null) {
            return;
        }
        SlotHandle columns = this.adapter.getColumns();
        TableColumn sourceColumn = ColumnHelper.findColumn(this.adapter.getModule(), columns.getSlot(), sourceIndex);
        ColumnHandle sourceCol = (ColumnHandle)sourceColumn.getHandle(this.adapter.getModule());
        this.pasteColumn(column, destIndex, true);
        int repeat = sourceCol.getRepeatCount();
        if (repeat == 1) {
            columns.drop(sourceCol);
        } else {
            sourceCol.setRepeatCount(repeat - 1);
        }
    }

    private void shiftCells(List cellInfos, int sourceIndex, int destIndex) throws SemanticException {
        int targetIndex = destIndex;
        int i = 0;
        while (i < cellInfos.size()) {
            CellContextInfo contextInfo = (CellContextInfo)cellInfos.get(i);
            RowHandle row = this.adapter.getRow(contextInfo.getSlotId(), contextInfo.getGroupId(), contextInfo.getRowIndex());
            assert (row != null);
            CellHandle cell = contextInfo.getCell().handle(this.adapter.getModule());
            cell.setColumn(0);
            int oldPosn = row.getCells().findPosn(cell);
            if (oldPosn < destIndex) {
                targetIndex = destIndex - 1;
            }
            row.getCells().shift(cell, targetIndex);
            this.clearsCellColumnProperties(row, oldPosn, targetIndex);
            ++i;
        }
    }

    protected void clearsCellColumnProperties(RowHandle row, int fromPosn, int toPosn) throws SemanticException {
        int fromIndex = fromPosn;
        int endIndex = toPosn;
        if (fromPosn > toPosn) {
            fromIndex = toPosn;
            endIndex = fromPosn;
        }
        if (row.getCells().getCount() <= endIndex) {
            endIndex = row.getCells().getCount() - 1;
        }
        int i = fromIndex;
        while (i <= endIndex) {
            CellHandle cell = (CellHandle)row.getCells().get(i);
            cell.setColumn(0);
            ++i;
        }
    }

    protected boolean checkTargetColumn(int sourceColumn, int destColumn) {
        if (this.adapter.hasParent()) {
            return false;
        }
        int newPosn = this.adjustDestPosn(sourceColumn, destColumn);
        if (newPosn == -1) {
            return true;
        }
        int columnCount = this.adapter.getColumnCount();
        if (newPosn == 0 || newPosn == columnCount) {
            return true;
        }
        List originalCells = this.getCellsContextInfo(this.adapter.getCellsUnderColumn(newPosn));
        return this.isRectangleArea(originalCells, 1);
    }
}

