/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.util.Comparator;
import org.eclipse.birt.data.engine.olap.data.util.IComparableStructure;
import org.eclipse.birt.data.engine.olap.data.util.IStructureCreator;
import org.eclipse.birt.data.engine.olap.data.util.IndexKeyObjectCreator;

public class IndexKey
implements IComparableStructure {
    private Object[] key;
    private int offset;
    private int dimensionPos;

    public Object[] getFieldValues() {
        Object[] fields = null;
        fields = new Object[this.getKey().length + 2];
        System.arraycopy(this.getKey(), 0, fields, 0, this.getKey().length);
        fields[fields.length - 2] = new Integer(this.getOffset());
        fields[fields.length - 1] = new Integer(this.getDimensionPos());
        return fields;
    }

    public int compareTo(Object o) {
        assert (o instanceof IndexKey);
        IndexKey target = (IndexKey)o;
        int i = 0;
        while (i < this.getKey().length) {
            if (this.getKey()[i] == null && target.getKey()[i] != null) {
                return -1;
            }
            if (this.getKey()[i] == null && target.getKey()[i] == null) {
                return 0;
            }
            if (this.getKey()[i] != null && target.getKey()[i] == null) {
                return 1;
            }
            int result = 0;
            result = this.getKey()[i] instanceof Comparable ? ((Comparable)this.getKey()[i]).compareTo(target.getKey()[i]) : this.getKey()[i].toString().compareTo(target.getKey()[i].toString());
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    public static Comparator getKeyComparator() {
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((IndexKey)obj1).compareTo(obj2);
            }
        };
    }

    public static Comparator getIndexComparator() {
        return new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int index2;
                int index1 = ((IndexKey)obj1).getDimensionPos();
                if (index1 < (index2 = ((IndexKey)obj2).getDimensionPos())) {
                    return -1;
                }
                if (index1 == index2) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public static IStructureCreator getCreator() {
        return new IndexKeyObjectCreator();
    }

    public void setKey(Object[] key) {
        this.key = key;
    }

    public Object[] getKey() {
        return this.key;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setDimensionPos(int dimensionPos) {
        this.dimensionPos = dimensionPos;
    }

    public int getDimensionPos() {
        return this.dimensionPos;
    }
}

