/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.odaconsumer.DataTypeUtil;
import org.eclipse.birt.data.engine.odaconsumer.LogHelper;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ColumnHint {
    private String m_name;
    private int m_position;
    private Class m_dataType;
    private int m_nativeDataType = 0;
    private String m_alias;
    private static final int UNKNOWN_NATIVE_TYPE = 0;
    private static String sm_className = ColumnHint.class.getName();
    private static String sm_loggerName = "org.eclipse.birt.data.engine.odaconsumer";
    private static LogHelper sm_logger = LogHelper.getInstance(sm_loggerName);

    public ColumnHint(String columnName) {
        sm_logger.entering(sm_className, "ColumnHint(String)", columnName);
        if (columnName == null || columnName.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnNameCannotBeEmptyOrNull");
            throw new IllegalArgumentException(localizedMessage);
        }
        this.m_name = columnName;
        sm_logger.exiting(sm_className, "ColumnHint(String)", this);
    }

    public String getName() {
        return this.m_name;
    }

    public void setPosition(int position) {
        if (position < 1) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnPositionIsOneBased");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, "setPosition(int)", "Invalid column position {0}.", new Integer(position));
            }
            throw ex;
        }
        this.m_position = position;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void setDataType(Class dataType) {
        assert (dataType == null || dataType == Integer.class || dataType == Double.class || dataType == String.class || dataType == BigDecimal.class || dataType == Date.class || dataType == java.sql.Date.class || dataType == Time.class || dataType == Timestamp.class || dataType == Blob.class || dataType == IBlob.class || dataType == Clob.class || dataType == IClob.class || dataType == Boolean.class || dataType == Object.class);
        this.m_dataType = dataType;
    }

    public Class getDataType() {
        return this.m_dataType;
    }

    public void setNativeDataType(int typeCode) {
        this.m_nativeDataType = typeCode;
    }

    public int getNativeDataType() {
        return this.m_nativeDataType;
    }

    public void setAlias(String alias) {
        if (alias != null && alias.length() == 0) {
            String localizedMessage = DataResourceHandle.getInstance().getMessage("odaconsumer.ColumnAliasCannotBeEmpty");
            IllegalArgumentException ex = new IllegalArgumentException(localizedMessage);
            if (sm_logger.isLoggable(Level.SEVERE)) {
                sm_logger.logp(Level.SEVERE, sm_className, "setAlias(String)", "The alias is empty; must be either null or non-empty value.");
            }
            throw ex;
        }
        this.m_alias = alias;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public Class getEffectiveDataType(String odaDataSourceId, String dataSetType) {
        Class effectiveType;
        if (this.getNativeDataType() != 0 && (effectiveType = DataTypeUtil.toTypeClass(DataTypeUtil.toOdaType(this.getNativeDataType(), odaDataSourceId, dataSetType))) != null) {
            return effectiveType;
        }
        return this.getDataType();
    }
}

