/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryProviderInstallOperationConfig;
import org.eclipse.jst.common.project.facet.core.libprov.user.UserLibraryValidator;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyClassesValidator
extends UserLibraryValidator {
    private final Set<String> classFileNames = new HashSet<String>();
    private final Map<String, String> classFileNameToClassName = new HashMap<String, String>();

    public void init(List<String> params) {
        for (String className : params) {
            String classFileName = String.valueOf(className.replace('.', '/')) + ".class";
            this.classFileNames.add(classFileName);
            this.classFileNameToClassName.put(classFileName, className);
        }
    }

    public IStatus validate(UserLibraryProviderInstallOperationConfig config) {
        HashMap<String, Integer> classAppearanceCounts = new HashMap<String, Integer>();
        for (String string : this.classFileNames) {
            classAppearanceCounts.put(string, 0);
        }
        for (IClasspathEntry iClasspathEntry : config.resolve()) {
            File file;
            if (iClasspathEntry.getEntryKind() != 1 || !(file = iClasspathEntry.getPath().toFile()).exists()) continue;
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(file);
                    Enumeration<? extends ZipEntry> itr = zip.entries();
                    while (itr.hasMoreElements()) {
                        ZipEntry zipEntry = itr.nextElement();
                        String name = zipEntry.getName();
                        Integer count = (Integer)classAppearanceCounts.get(name);
                        if (count == null) continue;
                        classAppearanceCounts.put(name, count + 1);
                    }
                }
                catch (IOException iOException) {
                    if (zip == null) continue;
                    try {
                        zip.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip == null) continue;
            try {
                zip.close();
            }
            catch (IOException iOException) {}
        }
        for (Map.Entry entry : classAppearanceCounts.entrySet()) {
            int count = (Integer)entry.getValue();
            if (count != 0) continue;
            String classFileName = (String)entry.getKey();
            String className = this.classFileNameToClassName.get(classFileName);
            String message = NLS.bind((String)JptCoreMessages.KEY_CLASSES_VALIDATOR__CLASS_NOT_FOUND, (Object)className);
            return new Status(4, "org.eclipse.jst.common.project.facet.core", message);
        }
        return Status.OK_STATUS;
    }
}

