/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jpa1.context.orm;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaResourceType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmXml;
import org.eclipse.jpt.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmXml
extends AbstractOrmXmlContextNode
implements OrmXml {
    protected final JpaXmlResource xmlResource;
    protected JpaResourceType resourceType;
    protected EntityMappings entityMappings;

    public GenericOrmXml(MappingFileRef parent, JpaXmlResource xmlResource) {
        super(parent);
        this.checkXmlResource(xmlResource);
        this.xmlResource = xmlResource;
        this.resourceType = xmlResource.getResourceType();
        XmlEntityMappings xmlEntityMappings = (XmlEntityMappings)xmlResource.getRootObject();
        if (xmlEntityMappings != null) {
            this.entityMappings = this.buildEntityMappings(xmlEntityMappings);
        }
    }

    protected void checkXmlResource(JpaXmlResource resource) {
        if (resource == null) {
            throw new NullPointerException();
        }
        if (!resource.getContentType().isKindOf(JptCorePlugin.MAPPING_FILE_CONTENT_TYPE)) {
            throw new IllegalArgumentException("Content type is not 'mapping file': " + resource);
        }
    }

    @Override
    public MappingFileRef getParent() {
        return (MappingFileRef)super.getParent();
    }

    @Override
    public IResource getResource() {
        return this.xmlResource.getFile();
    }

    @Override
    public JpaResourceType getResourceType() {
        return this.resourceType;
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        if (this.entityMappings != null && this.entityMappings.containsOffset(textOffset)) {
            return this.entityMappings.getStructureNode(textOffset);
        }
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void dispose() {
        JpaFile jpaFile;
        if (this.entityMappings != null) {
            this.entityMappings.dispose();
        }
        if ((jpaFile = this.getJpaFile()) != null) {
            jpaFile.removeRootStructureNode(this.xmlResource);
        }
    }

    @Override
    public JpaXmlResource getXmlResource() {
        return this.xmlResource;
    }

    @Override
    public MappingFileRoot getRoot() {
        return this.entityMappings;
    }

    @Override
    public OrmPersistentType getPersistentType(String name) {
        return this.entityMappings == null ? null : this.entityMappings.getPersistentType(name);
    }

    @Override
    public Iterable<? extends PersistentType> getPersistentTypes() {
        return this.entityMappings != null ? this.entityMappings.getPersistentTypes() : EmptyIterable.instance();
    }

    @Override
    public EntityMappings getEntityMappings() {
        return this.entityMappings;
    }

    protected void setEntityMappings(EntityMappings entityMappings) {
        EntityMappings old = this.entityMappings;
        this.entityMappings = entityMappings;
        this.firePropertyChanged("entityMappings", old, entityMappings);
    }

    protected EntityMappings buildEntityMappings(XmlEntityMappings xmlEntityMappings) {
        return this.getXmlContextNodeFactory().buildEntityMappings(this, xmlEntityMappings);
    }

    @Override
    public void update() {
        XmlEntityMappings oldXmlEntityMappings = this.entityMappings == null ? null : this.entityMappings.getXmlEntityMappings();
        XmlEntityMappings newXmlEntityMappings = (XmlEntityMappings)this.xmlResource.getRootObject();
        JpaResourceType newResourceType = this.xmlResource.getResourceType();
        if ((oldXmlEntityMappings != newXmlEntityMappings || newXmlEntityMappings == null || this.valuesAreDifferent(this.resourceType, newResourceType)) && this.entityMappings != null) {
            this.getJpaFile().removeRootStructureNode(this.xmlResource);
            this.entityMappings.dispose();
            this.setEntityMappings(null);
        }
        this.resourceType = newResourceType;
        if (newXmlEntityMappings != null) {
            if (this.entityMappings != null) {
                this.entityMappings.update();
            } else {
                this.setEntityMappings(this.buildEntityMappings(newXmlEntityMappings));
            }
            this.getJpaFile().addRootStructureNode(this.xmlResource, this.entityMappings);
        }
    }

    protected JpaFile getJpaFile() {
        return this.getJpaFile(this.xmlResource.getFile());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.entityMappings != null) {
            this.entityMappings.postUpdate();
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return TextRange.Empty.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.entityMappings != null) {
            this.entityMappings.validate(messages, reporter);
        }
    }
}

