/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.core.resource.orm.XmlMappedByMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmMappedByJoiningStrategy
extends AbstractOrmXmlContextNode
implements OrmMappedByJoiningStrategy {
    protected XmlMappedByMapping resource;
    protected String mappedByAttribute;

    public GenericOrmMappedByJoiningStrategy(OrmOwnableRelationshipReference parent, XmlMappedByMapping resource) {
        super(parent);
        this.resource = resource;
        this.mappedByAttribute = this.resource.getMappedBy();
    }

    @Override
    public OrmOwnableRelationshipReference getParent() {
        return (OrmOwnableRelationshipReference)super.getParent();
    }

    @Override
    public OrmOwnableRelationshipReference getRelationshipReference() {
        return this.getParent();
    }

    @Override
    public String getTableName() {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationshipReference().getPredominantJoiningStrategy().getTableName();
    }

    @Override
    public Table getDbTable(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? null : owner.getRelationshipReference().getPredominantJoiningStrategy().getDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        RelationshipMapping owner = this.getRelationshipOwner();
        return owner == null ? false : owner.getRelationshipReference().getPredominantJoiningStrategy().tableNameIsInvalid(tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return this.getRelationshipOwner().getRelationshipReference().getPredominantJoiningStrategy().getColumnTableNotValidDescription();
    }

    protected RelationshipMapping getRelationshipOwner() {
        return this.getRelationshipMapping().getRelationshipOwner();
    }

    @Override
    public boolean isOverridableAssociation() {
        return false;
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return this.getParent().getRelationshipMapping();
    }

    @Override
    public boolean relationshipIsOwnedBy(RelationshipMapping otherMapping) {
        String targetEntity;
        String thisEntity = this.getRelationshipReference().getEntity() == null ? null : this.getRelationshipReference().getEntity().getName();
        String string = targetEntity = otherMapping.getResolvedTargetEntity() == null ? null : otherMapping.getResolvedTargetEntity().getName();
        return StringTools.stringsAreEqual((String)thisEntity, (String)targetEntity) && StringTools.stringsAreEqual((String)this.getMappedByAttribute(), (String)otherMapping.getName());
    }

    @Override
    public String getMappedByAttribute() {
        return this.mappedByAttribute;
    }

    @Override
    public void setMappedByAttribute(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.resource.setMappedBy(newMappedByAttribute);
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    protected void setMappedByAttribute_(String newMappedByAttribute) {
        String oldMappedByAttribute = this.mappedByAttribute;
        this.mappedByAttribute = newMappedByAttribute;
        this.firePropertyChanged("mappedByAttribute", oldMappedByAttribute, newMappedByAttribute);
    }

    @Override
    public void addStrategy() {
        if (this.mappedByAttribute == null) {
            this.setMappedByAttribute("");
        }
    }

    @Override
    public void removeStrategy() {
        if (this.mappedByAttribute != null) {
            this.setMappedByAttribute(null);
        }
    }

    @Override
    public void update() {
        this.setMappedByAttribute_(this.resource.getMappedBy());
    }

    @Override
    public Iterator<String> candidateMappedByAttributeNames() {
        return this.getRelationshipMapping().allTargetEntityAttributeNames();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange mappedByTextRange = this.resource.getMappedByTextRange();
        return mappedByTextRange != null ? mappedByTextRange : this.getRelationshipReference().getValidationTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.getMappedByAttribute() == null) {
            return;
        }
        Entity targetEntity = this.getRelationshipMapping().getResolvedTargetEntity();
        if (targetEntity == null) {
            return;
        }
        AttributeMapping mappedByMapping = targetEntity.resolveAttributeMapping(this.mappedByAttribute);
        if (mappedByMapping == null) {
            messages.add(this.buildMessage("MAPPING_UNRESOLVED_MAPPED_BY", new String[]{this.mappedByAttribute}));
            return;
        }
        if (!this.getRelationshipReference().mayBeMappedBy(mappedByMapping)) {
            messages.add(this.buildMessage("MAPPING_INVALID_MAPPED_BY", new String[]{this.mappedByAttribute}));
            return;
        }
        if (!((RelationshipMapping)mappedByMapping).isRelationshipOwner()) {
            messages.add(this.buildMessage("MAPPING_MAPPED_BY_ON_BOTH_SIDES", new String[]{this.mappedByAttribute}));
        }
    }

    protected IMessage buildMessage(String msgID, String[] params) {
        OrmPersistentAttribute attribute = this.getRelationshipMapping().getPersistentAttribute();
        String attributeDescString = attribute.isVirtual() ? NLS.bind((String)JpaValidationDescriptionMessages.VIRTUAL_ATTRIBUTE_DESC, (Object)attribute.getName()) : NLS.bind((String)JpaValidationDescriptionMessages.ATTRIBUTE_DESC, (Object)attribute.getName());
        return DefaultJpaValidationMessages.buildMessage(1, msgID, (String[])ArrayTools.add((Object[])params, (int)0, (Object)attributeDescString), this, this.getValidationTextRange());
    }
}

