/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.math.BigDecimal;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.NumberDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.util.BigNumber;

public final class DifferenceEntry
extends NumberDataPointEntry {
    private double dPosValue;
    private double dNegValue;
    private BigNumber bnPosValue;
    private BigNumber bnNegValue;
    private boolean isBigNumber = false;
    private BigDecimal divisor;

    public DifferenceEntry(double dPositiveValue, double dNegativeValue) {
        this.dPosValue = dPositiveValue;
        this.dNegValue = dNegativeValue;
    }

    public DifferenceEntry(BigNumber bnPositiveValue, BigNumber bnNegativeValue) {
        this.init(bnPositiveValue, bnNegativeValue);
    }

    public DifferenceEntry(Object[] oaTwoComponents) {
        assert (oaTwoComponents.length == 2);
        if (oaTwoComponents[0] instanceof BigNumber) {
            this.init((BigNumber)oaTwoComponents[0], (BigNumber)oaTwoComponents[1]);
        } else {
            this.init(oaTwoComponents);
        }
    }

    protected void init(Object[] oaTwoComponents) {
        this.isBigNumber = false;
        this.dPosValue = oaTwoComponents[0] instanceof Number ? ((Number)oaTwoComponents[0]).doubleValue() : Double.NaN;
        this.dNegValue = oaTwoComponents[1] instanceof Number ? ((Number)oaTwoComponents[1]).doubleValue() : Double.NaN;
    }

    protected void init(BigNumber bnPositiveValue, BigNumber bnNegativeValue) {
        this.isBigNumber = true;
        this.bnPosValue = bnPositiveValue;
        this.bnNegValue = bnNegativeValue;
        this.divisor = this.bnPosValue.getDivisor();
        this.dPosValue = this.bnPosValue.doubleValue();
        this.dNegValue = this.bnNegValue.doubleValue();
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public final double getPositiveValue() {
        return this.dPosValue;
    }

    public final Number getPositiveValueNumber() {
        if (this.isBigNumber) {
            return this.bnPosValue;
        }
        return this.dPosValue;
    }

    public final void setPositiveValue(double value) {
        this.dPosValue = value;
    }

    public final void setPositiveValue(Number value) {
        if (this.isBigNumber && value instanceof BigNumber) {
            this.bnPosValue = (BigNumber)value;
        }
        this.setPositiveValue(value.doubleValue());
    }

    public final double getNegativeValue() {
        return this.dNegValue;
    }

    public final Number getNegativeValueNumber() {
        if (this.isBigNumber) {
            return this.bnNegValue;
        }
        return this.dNegValue;
    }

    public final void setNegativeValue(double value) {
        this.dNegValue = value;
    }

    public final void setNegativeValue(Number value) {
        if (this.isBigNumber && value instanceof BigNumber) {
            this.bnNegValue = (BigNumber)value;
        }
        this.setNegativeValue(value.doubleValue());
    }

    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = "";
        try {
            if ("difference_positive".equals(type)) {
                Object posValue = this.isBigNumber ? this.bnPosValue : Double.valueOf(this.dPosValue);
                str = ValueFormatter.format((Object)posValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            } else if ("difference_negative".equals(type)) {
                Object negValue = this.isBigNumber ? this.bnNegValue : Double.valueOf(this.dNegValue);
                str = ValueFormatter.format((Object)negValue, (FormatSpecifier)formatter, (ULocale)locale, null);
            }
        }
        catch (ChartException e) {
            Logger.getLogger((String)"org.eclipse.birt.chart.engine/exception").log((Exception)((Object)e));
        }
        return str;
    }

    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strPos = this.getFormattedString("difference_positive", formatter, locale);
        String strNeg = this.getFormattedString("difference_negative", formatter, locale);
        return "P" + strPos + " N" + strNeg;
    }

    public boolean isValid() {
        if (this.isBigNumber) {
            return true;
        }
        return !Double.isNaN(this.dNegValue) && !Double.isNaN(this.dPosValue);
    }

    public boolean isBigNumber() {
        return this.isBigNumber;
    }

    public BigDecimal getDivisor() {
        return this.divisor;
    }

    public void setNumberData(Number[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        if (data instanceof BigNumber[]) {
            this.init(((BigNumber[])data)[0], ((BigNumber[])data)[1]);
        } else {
            this.init(data);
        }
    }

    public Number[] getNumberData() {
        if (this.isBigNumber) {
            return new BigNumber[]{this.bnPosValue, this.bnNegValue};
        }
        return new Double[]{this.dPosValue, this.dNegValue};
    }
}

