/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageDescriptorRegistry {
    private Map fRegistry = Collections.synchronizedMap(new HashMap(10));
    private Display fDisplay;

    public ImageDescriptorRegistry() {
        this(DebugUIPlugin.getStandardDisplay());
    }

    public ImageDescriptorRegistry(Display display) {
        this.fDisplay = display;
        Assert.isNotNull((Object)this.fDisplay);
        this.hookDisplay();
    }

    public Image get(ImageDescriptor descriptor) {
        Image result;
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        if ((result = (Image)this.fRegistry.get(descriptor)) != null) {
            return result;
        }
        Assert.isTrue((this.fDisplay == DebugUIPlugin.getStandardDisplay() ? 1 : 0) != 0, (String)DebugUIMessages.ImageDescriptorRegistry_0);
        result = descriptor.createImage();
        if (result != null) {
            this.fRegistry.put(descriptor, result);
        }
        return result;
    }

    public void dispose() {
        Iterator iter = this.fRegistry.values().iterator();
        while (iter.hasNext()) {
            Image image = (Image)iter.next();
            image.dispose();
        }
        this.fRegistry.clear();
    }

    private void hookDisplay() {
        this.fDisplay.asyncExec(new Runnable(){

            public void run() {
                ImageDescriptorRegistry.this.fDisplay.disposeExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).dispose();
                    }
                });
            }

            static /* synthetic */ ImageDescriptorRegistry access$0(1 var0) {
                return var0.ImageDescriptorRegistry.this;
            }
        });
    }
}

