/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.lang.unittest.UnitTestHelper;
import org.eclipse.ease.lang.unittest.execution.ITestExecutionStrategy;
import org.eclipse.ease.lang.unittest.runtime.IMetadata;
import org.eclipse.ease.lang.unittest.runtime.IRuntimeFactory;
import org.eclipse.ease.lang.unittest.runtime.IRuntimePackage;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestResult;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class TestEntity
extends MinimalEObjectImpl.Container
implements ITestEntity {
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final TestStatus ENTITY_STATUS_EDEFAULT = TestStatus.NOT_RUN;
    protected TestStatus entityStatus = ENTITY_STATUS_EDEFAULT;
    protected static final long END_TIMESTAMP_EDEFAULT = 0L;
    protected long endTimestamp = 0L;
    protected static final long START_TIMESTAMP_EDEFAULT = 0L;
    protected long startTimestamp = 0L;
    protected EList<IMetadata> metadata;
    protected static final long DURATION_EDEFAULT = 0L;
    protected EList<ITestResult> results;
    protected static final long ESTIMATED_DURATION_EDEFAULT = -1L;
    protected long estimatedDuration = -1L;
    protected static final boolean TERMINATED_EDEFAULT = false;
    protected boolean terminated = false;

    protected TestEntity() {
        this.eAdapters().add((Object)new Adapter(){

            public void notifyChanged(Notification notification) {
                if (TestEntity.this.getEntityStatus() != TestStatus.RUNNING && TestEntity.this.getEntityStatus() != TestStatus.NOT_RUN && IRuntimePackage.Literals.TEST_ENTITY__ENTITY_STATUS.equals(notification.getFeature()) && !TestEntity.this.isDisabled()) {
                    for (ITestResult result : TestEntity.this.getResults()) {
                        UnitTestHelper.createWorkspaceMarker(result, TestEntity.this);
                    }
                }
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return true;
            }
        });
    }

    protected EClass eStaticClass() {
        return IRuntimePackage.Literals.TEST_ENTITY;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public TestStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatusGen(TestStatus newEntityStatus) {
        TestStatus oldEntityStatus = this.entityStatus;
        TestStatus testStatus = this.entityStatus = newEntityStatus == null ? ENTITY_STATUS_EDEFAULT : newEntityStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldEntityStatus, (Object)this.entityStatus));
        }
    }

    @Override
    public TestStatus getStatus() {
        int status = this.getEntityStatus().getValue();
        for (ITestResult result : this.getResults()) {
            if (TestStatus.DISABLED.equals((Object)result.getStatus())) {
                return TestStatus.DISABLED;
            }
            status = Math.max(status, result.getStatus().getValue());
        }
        return TestStatus.get(status);
    }

    @Override
    public ITestContainer getRoot() {
        if (this.getParent() != null) {
            return this.getParent().getRoot();
        }
        if (this instanceof ITestContainer) {
            return (ITestContainer)((Object)this);
        }
        return null;
    }

    @Override
    public boolean hasError() {
        for (ITestResult result : this.getResults()) {
            if (!TestStatus.ERROR.equals((Object)result.getStatus())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITestSuite getTestSuite() {
        ITestContainer parent = this.getParent();
        if (parent != null) {
            if (parent instanceof ITestSuite) {
                return (ITestSuite)parent;
            }
            return parent.getTestSuite();
        }
        return null;
    }

    @Override
    public Object getResource() {
        if (this.getParent() != null) {
            return this.getParent().getResource();
        }
        return null;
    }

    @Override
    public void reset() {
        this.getMetadata().clear();
        this.getResults().clear();
        this.setStartTimestamp(0L);
        this.setEndTimestamp(0L);
        this.setEntityStatus(TestStatus.NOT_RUN);
        this.setTerminated(false);
    }

    @Override
    public void run(ITestExecutionStrategy strategy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ITestResult getWorstResult() {
        ITestResult candidate = null;
        for (ITestResult result : this.getResults()) {
            if (candidate != null && candidate.getStatus().getValue() >= result.getStatus().getValue()) continue;
            candidate = result;
        }
        return candidate;
    }

    @Override
    public ITestResult addError(String message, IScriptEngine scriptEngine) {
        ITestResult result = IRuntimeFactory.eINSTANCE.createTestResult();
        result.setStatus(TestStatus.ERROR);
        result.setMessage(message);
        if (scriptEngine instanceof IDebugEngine) {
            result.setStackTrace(((IDebugEngine)scriptEngine).getExceptionStackTrace());
        }
        this.getResults().add((Object)result);
        return result;
    }

    @Override
    public EList<ITestResult> getResults(TestStatus status) {
        BasicEList results = new BasicEList();
        ITestResult[] iTestResultArray = (ITestResult[])this.getResults().toArray((Object[])new ITestResult[0]);
        int n = iTestResultArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestResult result = iTestResultArray[n2];
            if (result.getStatus().equals((Object)status)) {
                results.add((Object)result);
            }
            ++n2;
        }
        return results;
    }

    @Override
    public IPath getFullPath() {
        if (this.getParent() != null) {
            return this.getParent().getFullPath().append(this.getName());
        }
        return new Path(this.getName()).makeAbsolute();
    }

    @Override
    public void setDisabled(String message) {
        ITestResult testResult = IRuntimeFactory.eINSTANCE.createTestResult();
        testResult.setMessage(message);
        testResult.setStatus(TestStatus.DISABLED);
        this.getResults().add((Object)testResult);
    }

    @Override
    public boolean isDisabled() {
        for (ITestResult result : this.getResults()) {
            if (!TestStatus.DISABLED.equals((Object)result.getStatus())) continue;
            return true;
        }
        return TestStatus.DISABLED.equals((Object)this.getEntityStatus());
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParent((ITestContainer)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    @Override
    public void setStartTimestamp(long newStartTimestamp) {
        long oldStartTimestamp = this.startTimestamp;
        this.startTimestamp = newStartTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, oldStartTimestamp, this.startTimestamp));
        }
    }

    @Override
    public ITestContainer getParent() {
        if (this.eContainerFeatureID() != 5) {
            return null;
        }
        return (ITestContainer)this.eInternalContainer();
    }

    public NotificationChain basicSetParent(ITestContainer newParent, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParent, 5, msgs);
        return msgs;
    }

    @Override
    public void setParent(ITestContainer newParent) {
        if (newParent != this.eInternalContainer() || this.eContainerFeatureID() != 5 && newParent != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParent)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParent != null) {
                msgs = ((InternalEObject)newParent).eInverseAdd((InternalEObject)this, 11, ITestContainer.class, msgs);
            }
            if ((msgs = this.basicSetParent(newParent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newParent, (Object)newParent));
        }
    }

    @Override
    public EList<IMetadata> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new EObjectContainmentEList(IMetadata.class, (InternalEObject)this, 6);
        }
        return this.metadata;
    }

    @Override
    public long getDuration() {
        if (this.getEndTimestamp() > 0L) {
            return this.getEndTimestamp() - this.getStartTimestamp();
        }
        if (this.getStartTimestamp() > 0L) {
            return System.currentTimeMillis() - this.getStartTimestamp();
        }
        return 0L;
    }

    @Override
    public EList<ITestResult> getResults() {
        if (this.results == null) {
            this.results = new EObjectContainmentEList(ITestResult.class, (InternalEObject)this, 8);
        }
        return this.results;
    }

    @Override
    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    @Override
    public void setEstimatedDuration(long newEstimatedDuration) {
        long oldEstimatedDuration = this.estimatedDuration;
        this.estimatedDuration = newEstimatedDuration;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldEstimatedDuration, this.estimatedDuration));
        }
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void setTerminated(boolean newTerminated) {
        boolean oldTerminated = this.terminated;
        this.terminated = newTerminated;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldTerminated, this.terminated));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 5: {
                return this.basicSetParent(null, msgs);
            }
            case 6: {
                return ((InternalEList)this.getMetadata()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getResults()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 5: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 11, ITestContainer.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getDescription();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getEntityStatus();
            }
            case 3: {
                return this.getEndTimestamp();
            }
            case 4: {
                return this.getStartTimestamp();
            }
            case 5: {
                return this.getParent();
            }
            case 6: {
                return this.getMetadata();
            }
            case 7: {
                return this.getDuration();
            }
            case 8: {
                return this.getResults();
            }
            case 9: {
                return this.getEstimatedDuration();
            }
            case 10: {
                return this.isTerminated();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setDescription((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setEntityStatus((TestStatus)((Object)newValue));
                return;
            }
            case 3: {
                this.setEndTimestamp((Long)newValue);
                return;
            }
            case 4: {
                this.setStartTimestamp((Long)newValue);
                return;
            }
            case 5: {
                this.setParent((ITestContainer)newValue);
                return;
            }
            case 6: {
                this.getMetadata().clear();
                this.getMetadata().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getResults().clear();
                this.getResults().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setEstimatedDuration((Long)newValue);
                return;
            }
            case 10: {
                this.setTerminated((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setEntityStatus(ENTITY_STATUS_EDEFAULT);
                return;
            }
            case 3: {
                this.setEndTimestamp(0L);
                return;
            }
            case 4: {
                this.setStartTimestamp(0L);
                return;
            }
            case 5: {
                this.setParent(null);
                return;
            }
            case 6: {
                this.getMetadata().clear();
                return;
            }
            case 8: {
                this.getResults().clear();
                return;
            }
            case 9: {
                this.setEstimatedDuration(-1L);
                return;
            }
            case 10: {
                this.setTerminated(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.entityStatus != ENTITY_STATUS_EDEFAULT;
            }
            case 3: {
                return this.endTimestamp != 0L;
            }
            case 4: {
                return this.startTimestamp != 0L;
            }
            case 5: {
                return this.getParent() != null;
            }
            case 6: {
                return this.metadata != null && !this.metadata.isEmpty();
            }
            case 7: {
                return this.getDuration() != 0L;
            }
            case 8: {
                return this.results != null && !this.results.isEmpty();
            }
            case 9: {
                return this.estimatedDuration != -1L;
            }
            case 10: {
                return this.terminated;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getStatus();
            }
            case 1: {
                return this.getRoot();
            }
            case 2: {
                return this.hasError();
            }
            case 3: {
                return this.getTestSuite();
            }
            case 4: {
                return this.getResource();
            }
            case 5: {
                this.reset();
                return null;
            }
            case 6: {
                this.run((ITestExecutionStrategy)arguments.get(0));
                return null;
            }
            case 7: {
                return this.getWorstResult();
            }
            case 8: {
                return this.addError((String)arguments.get(0), (IScriptEngine)arguments.get(1));
            }
            case 9: {
                return this.getResults((TestStatus)((Object)arguments.get(0)));
            }
            case 10: {
                return this.getFullPath();
            }
            case 11: {
                this.setDisabled((String)arguments.get(0));
                return null;
            }
            case 12: {
                return this.isDisabled();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (description: ");
        result.append(this.description);
        result.append(", name: ");
        result.append(this.name);
        result.append(", entityStatus: ");
        result.append((Object)this.entityStatus);
        result.append(", endTimestamp: ");
        result.append(this.endTimestamp);
        result.append(", startTimestamp: ");
        result.append(this.startTimestamp);
        result.append(", estimatedDuration: ");
        result.append(this.estimatedDuration);
        result.append(", terminated: ");
        result.append(this.terminated);
        result.append(')');
        return result.toString();
    }

    @Override
    public void setEntityStatus(TestStatus value) {
        if (value == TestStatus.RUNNING) {
            this.setStartTimestamp(System.currentTimeMillis());
        } else {
            this.setEndTimestamp(System.currentTimeMillis());
        }
        this.setEntityStatusGen(value);
    }

    @Override
    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public void setEndTimestamp(long newEndTimestamp) {
        long oldEndTimestamp = this.endTimestamp;
        this.endTimestamp = newEndTimestamp;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldEndTimestamp, this.endTimestamp));
        }
    }
}

