/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion.provider;

import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.completion.AbstractCompletionProvider;
import org.eclipse.ease.ui.completion.IImageResolver;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.ui.PlatformUI;

public class LoadModuleCompletionProvider
extends AbstractCompletionProvider {
    @Override
    public boolean isActive(ICompletionContext context) {
        return context.getType() == ICompletionContext.Type.STRING_LITERAL && context.getCaller().endsWith("loadModule");
    }

    @Override
    protected void prepareProposals(ICompletionContext context) {
        Path filterPath = new Path(context.getFilter());
        Object searchPath = filterPath.segmentCount() > 1 ? filterPath.makeAbsolute().removeLastSegments(1) : (filterPath.hasTrailingSeparator() ? filterPath.makeAbsolute() : new Path("/"));
        HashSet<String> pathProposals = new HashSet<String>();
        IScriptService scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class);
        Map availableModules = scriptService.getAvailableModules();
        for (Map.Entry moduleEntry : availableModules.entrySet()) {
            Path modulePath = new Path((String)moduleEntry.getKey());
            if (!searchPath.isPrefixOf((IPath)modulePath)) continue;
            if (searchPath.segmentCount() + 1 == modulePath.segmentCount()) {
                if (!this.matchesFilterIgnoreCase((String)moduleEntry.getKey())) continue;
                StyledString displayString = new StyledString(modulePath.lastSegment());
                if (!((ModuleDefinition)moduleEntry.getValue()).isVisible()) {
                    displayString.append(" (hidden)", StyledString.DECORATIONS_STYLER);
                }
                this.addProposal(displayString, (String)moduleEntry.getKey(), (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(Activator.getImageDescriptor("org.eclipse.ease.ui", "/icons/eobj16/module.png")), 0, null);
                continue;
            }
            pathProposals.add(modulePath.removeLastSegments(1).toString());
        }
        for (String pathProposal : pathProposals) {
            if (!this.matchesFilterIgnoreCase(pathProposal)) continue;
            this.addProposal(pathProposal, String.valueOf(pathProposal) + "/", (IImageResolver)new AbstractCompletionProvider.DescriptorImageResolver(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER")), 10, null);
        }
    }
}

