/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.ease.modules.unittest.ui";
    private static final int MAX_RECENT_FILES = 5;
    public static final String ICON_TEST_SUITE = "/icons/eobj16/testsuite.png";
    public static final String ICON_ERROR = "/icons/eobj16/status_error.png";
    public static final String ICON_FAILURE = "/icons/eobj16/status_failure.png";
    public static final String ICON_PASS = "/icons/eobj16/status_pass.png";
    public static final String ICON_RUNNING = "/icons/eobj16/status_running.png";
    public static final String ICON_METADATA = "/icons/eobj16/metadata.png";
    private static Activator fInstance;
    private final List<IFile> fRecentFiles = new ArrayList<IFile>();

    public static Activator getDefault() {
        return fInstance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.loadRecentFiles();
        fInstance = this;
    }

    public void stop(BundleContext context) throws Exception {
        fInstance = null;
        this.saveRecentFiles();
        super.stop(context);
    }

    private void loadRecentFiles() {
        block17: {
            File file = this.getStateLocation().append("recentFiles.txt").toFile();
            if (file.exists()) {
                Reader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(file));
                        String data = ResourceTools.toString((Reader)reader);
                        String[] stringArray = data.split(";");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFile suiteFile;
                            String fileName = stringArray[n2];
                            if (!fileName.isEmpty() && (suiteFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName))) != null && suiteFile.exists()) {
                                this.fRecentFiles.add(suiteFile);
                            }
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException2) {}
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void saveRecentFiles() {
        block16: {
            Object file2;
            StringBuilder buffer = new StringBuilder();
            for (Object file2 : this.getRecentFiles()) {
                buffer.append(';');
                buffer.append(file2.getFullPath().toString());
            }
            if (buffer.length() > 0) {
                buffer.delete(0, 1);
            }
            file2 = this.getStateLocation().append("recentFiles.txt").toFile();
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter((File)file2);
                    writer.write(buffer.toString());
                }
                catch (IOException iOException) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void addRecentFile(IFile file) {
        this.fRecentFiles.remove(file);
        this.fRecentFiles.add(0, file);
        while (this.fRecentFiles.size() >= 5) {
            this.fRecentFiles.remove(4);
        }
    }

    public List<IFile> getRecentFiles() {
        return Collections.unmodifiableList(this.fRecentFiles);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

