/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.Future;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IEvaluationService;

public class PlatformModule {
    @WrapToScript
    public Object adapt(Object source, Class<?> target) {
        return Platform.getAdapterManager().getAdapter(source, target);
    }

    @WrapToScript
    public Object getService(Class<?> type) {
        return PlatformUI.getWorkbench().getService(type);
    }

    @WrapToScript
    public void executeCommand(String commandId, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Map<String, String> parameters) throws ExecutionException, NotDefinedException, NotEnabledException, NotHandledException {
        HashMap commandParameters = parameters != null ? parameters : new HashMap();
        ICommandService commandService = (ICommandService)this.getService(ICommandService.class);
        IEvaluationService evaluationService = (IEvaluationService)this.getService(IEvaluationService.class);
        Command command = commandService.getCommand(commandId);
        command.executeWithChecks(new ExecutionEvent(command, commandParameters, null, (Object)evaluationService.getCurrentState()));
    }

    @WrapToScript
    public String getSystemProperty(String key) {
        return System.getProperty(key);
    }

    @WrapToScript
    public Future runProcess(String name, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(name);
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                arguments.add(arg);
                ++n2;
            }
        }
        ProcessBuilder builder = new ProcessBuilder(arguments);
        try {
            return new Future(builder.start());
        }
        catch (IOException e) {
            return new Future(e);
        }
    }

    @WrapToScript
    public Object readPreferences(String node, String key, @ScriptParameter(defaultValue="") Object defaultValue) {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(node);
        if (root != null) {
            if (defaultValue instanceof Boolean) {
                return root.getBoolean(key, ((Boolean)defaultValue).booleanValue());
            }
            if (defaultValue instanceof Integer) {
                return root.getInt(key, ((Integer)defaultValue).intValue());
            }
            if (defaultValue instanceof Double) {
                return root.getDouble(key, ((Double)defaultValue).doubleValue());
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(root.getFloat(key, ((Float)defaultValue).floatValue()));
            }
            if (defaultValue instanceof Long) {
                return root.getLong(key, ((Long)defaultValue).longValue());
            }
            if (defaultValue instanceof byte[]) {
                return root.getByteArray(key, (byte[])defaultValue);
            }
            return root.get(key, defaultValue != null ? defaultValue.toString() : "");
        }
        return null;
    }

    @WrapToScript
    public void writePreferences(String node, String key, Object value) {
        IEclipsePreferences root = InstanceScope.INSTANCE.getNode(node);
        if (root != null) {
            if (value instanceof Boolean) {
                root.putBoolean(key, ((Boolean)value).booleanValue());
            } else if (value instanceof Integer) {
                root.putInt(key, ((Integer)value).intValue());
            } else if (value instanceof Double) {
                root.putDouble(key, ((Double)value).doubleValue());
            } else if (value instanceof Float) {
                root.putFloat(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                root.putLong(key, ((Long)value).longValue());
            } else if (value instanceof byte[]) {
                root.putByteArray(key, (byte[])value);
            } else {
                root.put(key, value != null ? value.toString() : "");
            }
        }
    }
}

