/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractScriptDebugger;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebugger
extends AbstractScriptDebugger
implements Debugger {
    private final Map<DebuggableScript, Script> mFrameToSource = new HashMap<DebuggableScript, Script>();
    private Script mLastScript = null;

    public RhinoDebugger(IScriptEngine engine, boolean showDynamicCode) {
        super(engine, showDynamicCode);
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        Script script = this.getScript(fnOrScript);
        if (script == null) {
            script = this.mLastScript;
        }
        if (script == null) {
            return null;
        }
        DebuggableScript parentScript = RhinoDebugger.getParentScript(fnOrScript);
        if (!this.mFrameToSource.containsKey(parentScript)) {
            this.mFrameToSource.put(parentScript, script);
        }
        RhinoDebugFrame debugFrame = new RhinoDebugFrame(fnOrScript);
        this.getStacktrace().add(0, debugFrame);
        return debugFrame;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 3: 
            case 5: {
                this.mLastScript = script;
                break;
            }
        }
        super.notify(engine, script, status);
    }

    private Script getScript(DebuggableScript rhinoScript) {
        return this.mFrameToSource.get(RhinoDebugger.getParentScript(rhinoScript));
    }

    private static DebuggableScript getParentScript(DebuggableScript rhinoScript) {
        while (rhinoScript.getParent() != null) {
            rhinoScript = rhinoScript.getParent();
        }
        return rhinoScript;
    }

    public class RhinoDebugFrame
    implements DebugFrame,
    IScriptDebugFrame {
        private int mLineNumber = 0;
        private final DebuggableScript mFnOrScript;

        public RhinoDebugFrame(DebuggableScript fnOrScript) {
            this.mFnOrScript = fnOrScript;
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        }

        public void onLineChange(Context cx, int lineNumber) {
            this.mLineNumber = lineNumber;
            if (RhinoDebugger.this.isTrackedScript(this.getScript())) {
                RhinoDebugger.this.processLine(this.getScript(), lineNumber);
            }
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            RhinoDebugger.this.setExceptionStacktrace();
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            RhinoDebugger.this.getStacktrace().remove(this);
        }

        public void onDebuggerStatement(Context cx) {
        }

        public int getLineNumber() {
            return this.mLineNumber;
        }

        public Script getScript() {
            return RhinoDebugger.this.getScript(this.mFnOrScript);
        }

        public int getType() {
            return this.mFnOrScript.isFunction() ? 2 : 1;
        }

        public String getName() {
            if (this.mFnOrScript.isFunction()) {
                return String.valueOf(this.mFnOrScript.getFunctionName()) + "()";
            }
            Object file = this.getScript().getFile();
            if (file != null) {
                if (file instanceof IFile) {
                    return ((IFile)file).getName();
                }
                if (file instanceof File) {
                    return ((File)file).getName();
                }
            } else {
                String title = this.getScript().getTitle();
                return title != null ? "Dynamic: " + title : "(Dynamic)";
            }
            return "(unknown source)";
        }

        public Map<String, Object> getVariables() {
            return RhinoDebugger.this.getEngine().getVariables();
        }
    }
}

