/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.modules.platform.FilesystemHandle;

public class ResourceHandle
extends FilesystemHandle {
    private final IFile fFile;

    public ResourceHandle(IFile file, int mode) {
        super(null, mode);
        this.fFile = file;
    }

    @Override
    protected BufferedReader createReader() throws Exception {
        return new BufferedReader(new InputStreamReader(this.fFile.getContents()));
    }

    @Override
    public boolean write(String data) {
        try {
            if ((this.getMode() & 4) == 4) {
                this.fFile.appendContents((InputStream)new ByteArrayInputStream(data.getBytes()), false, false, null);
            } else {
                this.fFile.setContents((InputStream)new ByteArrayInputStream(data.getBytes()), false, false, null);
                this.setMode(this.getMode() | 4);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean exists() {
        return this.fFile.exists();
    }

    @Override
    public boolean createFile(boolean createHierarchy) throws CoreException {
        if (createHierarchy) {
            ResourceHandle.createFolder(this.fFile.getParent());
        }
        this.fFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        return true;
    }

    public static boolean createFolder(IContainer container) throws CoreException {
        if (!container.isAccessible()) {
            IContainer parent = container.getParent();
            if (!parent.isAccessible()) {
                if (parent instanceof IFolder) {
                    ResourceHandle.createFolder(parent);
                } else if (parent instanceof IProject) {
                    ((IProject)parent).create(null);
                    ((IProject)parent).open(null);
                } else {
                    return false;
                }
            }
            if (container instanceof IFolder) {
                ((IFolder)container).create(0, true, null);
            } else if (container instanceof IProject) {
                ((IProject)container).create(null);
                ((IProject)parent).open(null);
            }
        }
        return true;
    }

    @Override
    public Object getFile() {
        return this.fFile;
    }
}

