/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorActionBarContributor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.extensions.IEditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.ISchemaObjectEditorExtensionsRegistryReader;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.SOEUIPlugin;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core.EditorDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.internal.core.EditorPageDescriptor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.ILogger;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.util.Images;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class SchemaObjectEditorExtensionsRegistryReader
implements ISchemaObjectEditorExtensionsRegistryReader {
    private List _editors;
    private static SchemaObjectEditorExtensionsRegistryReader _instance;
    private ILogger _logger = SOEUIPlugin.getLogger(null);
    Image _image = null;

    private SchemaObjectEditorExtensionsRegistryReader() {
    }

    public static synchronized SchemaObjectEditorExtensionsRegistryReader getInstance() {
        if (_instance == null) {
            _instance = new SchemaObjectEditorExtensionsRegistryReader();
        }
        return _instance;
    }

    public IEditorDescriptor[] getEditorDescriptors() {
        if (this._editors == null) {
            this.init();
        }
        return this._editors == null ? new IEditorDescriptor[]{} : this._editors.toArray(new IEditorDescriptor[this._editors.size()]);
    }

    private void init() {
        block28: {
            IExtension[] extensions;
            this._editors = new ArrayList();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint point = registry.getExtensionPoint("org.eclipse.datatools.sqltools.schemaobjecteditor.ui", "schemaObjectEditor");
            if (point == null || (extensions = point.getExtensions()) == null) break block28;
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                EditorDescriptor editor = null;
                int j = 0;
                while (j < elements.length) {
                    block29: {
                        block30: {
                            IConfigurationElement[] orders;
                            if (elements[j].getName().equals("EditorPage")) break block29;
                            String editorId = elements[j].getAttribute("EditorId");
                            String editorName = elements[j].getAttribute("EditorName");
                            String objectType = elements[j].getAttribute("ObjectTypeId");
                            String vendorName = elements[j].getAttribute("VendorName");
                            String version = elements[j].getAttribute("Version");
                            String iconLoc = elements[j].getAttribute("Icon");
                            String objectTypeName = elements[j].getAttribute("ObjectTypeName");
                            String pluginNamespace = extensions[i].getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)pluginNamespace);
                            Image icon = this.readImage(bundle, iconLoc);
                            String needGenPrefGrpString = elements[j].getAttribute("VisibilityConfigurable");
                            boolean needGenPrefGrp = true;
                            if (needGenPrefGrpString != null) {
                                needGenPrefGrp = needGenPrefGrpString.equals("true");
                            }
                            editor = new EditorDescriptor(editorId, editorName, vendorName, version, objectType, icon, needGenPrefGrp);
                            editor.setPluginId(elements[j].getDeclaringExtension().getNamespaceIdentifier());
                            editor.setObjectTypeName(objectTypeName);
                            String mandatoryFirstPage = "";
                            String mandatoryLastPage = "";
                            try {
                                ISchemaObjectEditorHandler handler = (ISchemaObjectEditorHandler)elements[j].createExecutableExtension("Handler");
                                ISchemaObjectEditorActionBarContributor contributor = null;
                                try {
                                    contributor = (ISchemaObjectEditorActionBarContributor)elements[j].createExecutableExtension("ContributorClass");
                                }
                                catch (Exception exception) {}
                                mandatoryFirstPage = elements[j].getAttribute("MustBeFirstWhenShown");
                                mandatoryLastPage = elements[j].getAttribute("MustBeLastWhenShown");
                                editor.setHandler(handler);
                                editor.setActionContributor(contributor);
                                editor.setConfigElement(elements[j]);
                                editor.setContributorElement(elements[j]);
                            }
                            catch (Exception e) {
                                this._logger.error("SchemaObjectEditorExtensionRegistryReader_error_reading_editor", (Throwable)e);
                            }
                            ArrayList<IEditorPageDescriptor> pages = new ArrayList<IEditorPageDescriptor>();
                            IConfigurationElement[] referencedEditors = elements[j].getChildren("ReferencedEditor");
                            int k = 0;
                            while (k < referencedEditors.length) {
                                int kk;
                                ArrayList<String> excludePages = new ArrayList<String>();
                                String id = referencedEditors[k].getAttribute("EditorId");
                                IConfigurationElement[] excludes = referencedEditors[k].getChildren("Excludes");
                                if (excludes != null && excludes.length > 0) {
                                    IConfigurationElement[] excludeElements = excludes[0].getChildren("ExcludePage");
                                    kk = 0;
                                    while (kk < excludeElements.length) {
                                        String excludeId = excludeElements[kk].getAttribute("PageId");
                                        excludePages.add(excludeId);
                                        ++kk;
                                    }
                                }
                                IEditorPageDescriptor[] selectedPages = this.resolveReferenceEditor(id, editor, extensions, excludePages);
                                kk = 0;
                                while (kk < selectedPages.length) {
                                    pages.add(selectedPages[kk]);
                                    ++kk;
                                }
                                ++k;
                            }
                            IConfigurationElement[] declaredPages = elements[j].getChildren("EditorPage");
                            int k2 = 0;
                            while (k2 < declaredPages.length) {
                                IEditorPageDescriptor page = this.readPage(declaredPages[k2], editor);
                                if (page != null) {
                                    pages.add(page);
                                }
                                ++k2;
                            }
                            IConfigurationElement[] referencedPages = elements[j].getChildren("ReferencedPage");
                            int k3 = 0;
                            while (k3 < referencedPages.length) {
                                try {
                                    String eId = referencedPages[k3].getAttribute("EditorId");
                                    String pId = referencedPages[k3].getAttribute("PageId");
                                    String pageExtensionId = referencedPages[k3].getAttribute("PageExtensionId");
                                    IEditorPageDescriptor page = this.resolveReferencedPage(eId, pId, extensions, editor);
                                    ((EditorPageDescriptor)page).setPageExtensionId(pageExtensionId);
                                    if (page != null) {
                                        pages.add(page);
                                    }
                                }
                                catch (Exception e) {
                                    System.out.println(e.getMessage());
                                }
                                ++k3;
                            }
                            editor.setPageDescriptors(pages.toArray(new IEditorPageDescriptor[pages.size()]));
                            if (mandatoryFirstPage != null && !mandatoryFirstPage.trim().equals("")) {
                                IEditorPageDescriptor[] p = editor.getPageDescriptors();
                                int l = 0;
                                while (l < p.length) {
                                    if (p[l].getPageId().equals(mandatoryFirstPage.trim())) {
                                        editor.setMandatoryFirstPage(p[l]);
                                    }
                                    ++l;
                                }
                            }
                            if (mandatoryLastPage != null && !mandatoryLastPage.trim().equals("")) {
                                IEditorPageDescriptor[] p = editor.getPageDescriptors();
                                int l = 0;
                                while (l < p.length) {
                                    if (p[l].getPageId().equals(mandatoryLastPage.trim())) {
                                        editor.setMandatoryLastPage(p[l]);
                                    }
                                    ++l;
                                }
                            }
                            if ((orders = elements[j].getChildren("DefaultPagesOrder")) == null || orders.length <= 0) break block30;
                            IConfigurationElement[] orderItems = orders[0].getChildren("OrderItem");
                            int kk = 0;
                            while (kk < orderItems.length) {
                                block31: {
                                    String pId = orderItems[kk].getAttribute("PageId");
                                    String orderNum = orderItems[kk].getAttribute("OrderNum");
                                    int order = -1;
                                    try {
                                        order = Integer.parseInt(orderNum);
                                        if (order < 1) {
                                        }
                                    }
                                    catch (Exception exception) {}
                                    break block31;
                                    IEditorPageDescriptor page = this.getPageById(pages, pId);
                                    if (page != null) {
                                        editor.getDefaultPagesOrder().put(page, new Integer(order));
                                    }
                                }
                                ++kk;
                            }
                        }
                        this._editors.add(editor);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private IEditorPageDescriptor getPageById(List pages, String pId) {
        for (IEditorPageDescriptor page : pages) {
            if (!page.getPageId().equals(pId)) continue;
            return page;
        }
        return null;
    }

    private IEditorPageDescriptor resolveReferencedPage(String editorId, String pageId, IExtension[] extensions, IEditorDescriptor editor) {
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j].getName().equals("EditorPage")) {
                    String pId;
                    if ((editorId == null || editorId.trim().length() == 0) && (pId = elements[j].getAttribute("PageId")).equals(pageId)) {
                        IEditorPageDescriptor page = this.readPage(elements[j], editor);
                        return page;
                    }
                } else {
                    String eId = elements[j].getAttribute("EditorId");
                    if (eId.equals(editorId)) {
                        IConfigurationElement[] pages = elements[j].getChildren("EditorPage");
                        int k = 0;
                        while (k < pages.length) {
                            String pId = pages[k].getAttribute("PageId");
                            if (pId.equals(pageId)) {
                                IEditorPageDescriptor page = this.readPage(pages[k], editor);
                                return page;
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private IEditorPageDescriptor readPage(IConfigurationElement element, IEditorDescriptor editor) {
        EditorPageDescriptor page = null;
        String pageId = element.getAttribute("PageId");
        String pageName = element.getAttribute("PageName");
        String requiredStr = element.getAttribute("Required");
        String visibleByDefaultStr = element.getAttribute("VisibleByDefault");
        String contextHelpId = element.getAttribute("ContextHelpId");
        String objectClassType = element.getAttribute("ObjectClassType");
        ISchemaObjectEditorPage pageClass = null;
        try {
            pageClass = (ISchemaObjectEditorPage)element.createExecutableExtension("Class");
            boolean isRequired = false;
            if (requiredStr != null) {
                isRequired = requiredStr.equals("true");
            }
            boolean isVisibleByDefault = false;
            if (visibleByDefaultStr != null) {
                isVisibleByDefault = visibleByDefaultStr.equals("true");
            }
            page = new EditorPageDescriptor(editor.getEditorId(), pageId, pageName, isRequired, isVisibleByDefault, pageClass, editor, element, null, contextHelpId, objectClassType);
            return page;
        }
        catch (Exception e) {
            this._logger.error("SchemaObjectEditorExtensionRegistryReader_error_reading_page", (Throwable)e);
            return null;
        }
    }

    private IEditorPageDescriptor[] resolveReferenceEditor(String editorId, IEditorDescriptor editor, IExtension[] extensions, List excludes) {
        ArrayList<IEditorPageDescriptor> selectedPages = new ArrayList<IEditorPageDescriptor>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String eId;
                if (!elements[j].getName().equals("EditorPage") && (eId = elements[j].getAttribute("EditorId")).equals(editorId)) {
                    IConfigurationElement[] pages = elements[j].getChildren("EditorPage");
                    int k = 0;
                    while (k < pages.length) {
                        IEditorPageDescriptor page;
                        String pageId = pages[k].getAttribute("PageId");
                        if (!excludes.contains(pageId) && (page = this.readPage(pages[k], editor)) != null) {
                            selectedPages.add(page);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return selectedPages.toArray(new IEditorPageDescriptor[selectedPages.size()]);
    }

    private Image readImage(final Bundle bundle, final String iconLoc) {
        SOEUIPlugin.getActiveWorkbenchShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                if (bundle == null || iconLoc == null || bundle.getEntry(iconLoc) == null) {
                    SchemaObjectEditorExtensionsRegistryReader.this._image = null;
                    return;
                }
                String key = String.valueOf(bundle.getBundleId()) + "_" + iconLoc;
                Image img = Images.getImageRegistry().get(key);
                if (img == null) {
                    try {
                        ImageDescriptor desp = ImageDescriptor.createFromURL((URL)bundle.getEntry(iconLoc));
                        Images.getImageRegistry().put(key, desp);
                    }
                    catch (Exception ex) {
                        SchemaObjectEditorExtensionsRegistryReader.this._logger.error("SchemaObjectEditorExtensionsRegistryRead_error_read_image", (Throwable)ex);
                        SchemaObjectEditorExtensionsRegistryReader.this._image = null;
                        return;
                    }
                }
                SchemaObjectEditorExtensionsRegistryReader.this._image = Images.getImageRegistry().get(key);
            }
        });
        return this._image;
    }
}

