/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.lsp4e.ContentTypeToLSPLaunchConfigEntry;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LoggingStreamConnectionProviderProxy;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;

public class LoggingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer languageServerViewer;
    private TableViewer launchConfigurationViewer;
    private Map<String, Boolean> serverEnableLoggingToFile = new HashMap<String, Boolean>();
    private Map<String, Boolean> serverEnableLoggingToConsole = new HashMap<String, Boolean>();
    private IPreferenceStore store = LanguageServerPlugin.getDefault().getPreferenceStore();
    private boolean hasLoggingBeenChanged = false;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite res = new Composite(parent, 0);
        res.setLayout((Layout)new GridLayout(1, false));
        this.createStaticServersTable(res);
        this.createLaunchConfigurationServersTable(res);
        this.createLoggingContents(res);
        this.updateInputs();
        return res;
    }

    private void createStaticServersTable(Composite res) {
        this.languageServerViewer = new TableViewer(res, 65536);
        this.languageServerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.languageServerViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.languageServerViewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_languageServer);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).label;
            }
        });
        this.addLoggingColumnsToViewer(this.languageServerViewer);
        this.languageServerViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.languageServerViewer.getTable().setHeaderVisible(true);
        this.languageServerViewer.getTable().setLinesVisible(true);
    }

    private void createLaunchConfigurationServersTable(Composite res) {
        this.launchConfigurationViewer = new TableViewer(res, 65536);
        this.launchConfigurationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.launchConfigurationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn launchConfigColumn = new TableViewerColumn(this.launchConfigurationViewer, 0);
        launchConfigColumn.getColumn().setText(Messages.PreferencesPage_LaunchConfiguration);
        launchConfigColumn.getColumn().setWidth(300);
        launchConfigColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ContentTypeToLSPLaunchConfigEntry)element).getLaunchConfiguration().getName();
            }
        });
        this.addLoggingColumnsToViewer(this.launchConfigurationViewer);
        this.launchConfigurationViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.launchConfigurationViewer.getTable().setHeaderVisible(true);
        this.languageServerViewer.getTable().setLinesVisible(true);
    }

    private void addLoggingColumnsToViewer(TableViewer viewer) {
        TableViewerColumn logToFileColumn = new TableViewerColumn(viewer, 0);
        logToFileColumn.getColumn().setText(Messages.PreferencesPage_logging_toFile_title);
        logToFileColumn.getColumn().setWidth(100);
        logToFileColumn.setLabelProvider((CellLabelProvider)new BooleanMapLabelProvider(this.serverEnableLoggingToFile));
        logToFileColumn.setEditingSupport((EditingSupport)new BooleanMapEditingSupport(viewer, this.serverEnableLoggingToFile));
        TableViewerColumn logToConsoleColumn = new TableViewerColumn(viewer, 0);
        logToConsoleColumn.getColumn().setText(Messages.PreferencesPage_logging_toConsole_title);
        logToConsoleColumn.getColumn().setWidth(125);
        logToConsoleColumn.setLabelProvider((CellLabelProvider)new BooleanMapLabelProvider(this.serverEnableLoggingToConsole));
        logToConsoleColumn.setEditingSupport((EditingSupport)new BooleanMapEditingSupport(viewer, this.serverEnableLoggingToConsole));
    }

    private void createLoggingContents(Composite res) {
        Composite loggingComposite = new Composite(res, 0);
        loggingComposite.setLayout((Layout)new GridLayout(3, false));
        loggingComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label infoLabel = new Label(loggingComposite, 0);
        infoLabel.setText(Messages.preferencesPage_logging_info);
        infoLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Link logFolderLabel = new Link(loggingComposite, 0);
        logFolderLabel.setText(NLS.bind((String)Messages.preferencesPage_logging_fileLogsLocation, (Object)LoggingStreamConnectionProviderProxy.getLogDirectory()));
        logFolderLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        logFolderLabel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            SmartImportWizard importWizard = new SmartImportWizard();
            importWizard.setInitialImportSource(LoggingStreamConnectionProviderProxy.getLogDirectory());
            WizardDialog dialog = new WizardDialog(logFolderLabel.getShell(), (IWizard)importWizard);
            dialog.open();
        }));
        Label fileLoggingLabel = new Label(loggingComposite, 0);
        fileLoggingLabel.setText(Messages.PreferencesPage_logging_toFile_description);
        Button disableFileLogging = new Button(loggingComposite, 0);
        disableFileLogging.setText(Messages.PreferencePage_enablementCondition_disableAll);
        disableFileLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToFile.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToFile.put((String)s, false);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Button enableFileLogging = new Button(loggingComposite, 0);
        enableFileLogging.setText(Messages.PreferencePage_enablementCondition_enableAll);
        enableFileLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToFile.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToFile.put((String)s, true);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Label consoleLoggingLabel = new Label(loggingComposite, 0);
        consoleLoggingLabel.setText(Messages.PreferencesPage_logging_toConsole_description);
        Button disableConsoleLogging = new Button(loggingComposite, 0);
        disableConsoleLogging.setText(Messages.PreferencePage_enablementCondition_disableAll);
        disableConsoleLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToConsole.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToConsole.put((String)s, false);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
        Button enableConsoleLogging = new Button(loggingComposite, 0);
        enableConsoleLogging.setText(Messages.PreferencePage_enablementCondition_enableAll);
        enableConsoleLogging.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.serverEnableLoggingToConsole.forEach((s, b) -> {
                Boolean bl = this.serverEnableLoggingToConsole.put((String)s, true);
            });
            this.hasLoggingBeenChanged = true;
            this.languageServerViewer.refresh();
            this.launchConfigurationViewer.refresh();
        }));
    }

    protected void performDefaults() {
        this.serverEnableLoggingToFile.forEach((s, b) -> {
            Boolean bl = this.serverEnableLoggingToFile.put((String)s, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(s)));
        });
        this.serverEnableLoggingToConsole.forEach((s, b) -> {
            Boolean bl = this.serverEnableLoggingToConsole.put((String)s, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(s)));
        });
        this.launchConfigurationViewer.refresh();
        this.languageServerViewer.refresh();
        super.performDefaults();
    }

    private void applyLoggingEnablment() {
        this.serverEnableLoggingToFile.forEach((s, b) -> this.store.setValue(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(s), b.booleanValue()));
        this.serverEnableLoggingToConsole.forEach((s, b) -> this.store.setValue(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(s), b.booleanValue()));
        this.hasLoggingBeenChanged = false;
    }

    public boolean performOk() {
        if (this.hasLoggingBeenChanged) {
            this.applyLoggingEnablment();
            MessageDialog dialog = new MessageDialog(this.getShell(), Messages.PreferencesPage_restartWarning_title, null, Messages.PreferencesPage_restartWarning_message, 4, new String[]{IDialogConstants.NO_LABEL, Messages.PreferencesPage_restartWarning_restart}, 1);
            if (dialog.open() == 1) {
                PlatformUI.getWorkbench().restart();
            }
        }
        return super.performOk();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.updateInputs();
    }

    private void updateInputs() {
        HashSet languageServerIDs = new HashSet();
        ArrayList contentTypeToLSPLaunchConfigEntries = new ArrayList();
        LanguageServersRegistry.getInstance().getContentTypeToLSPLaunches().forEach(o -> {
            String id = ((LanguageServersRegistry.LanguageServerDefinition)o.getValue()).id;
            if (languageServerIDs.add(id)) {
                contentTypeToLSPLaunchConfigEntries.add(o);
                this.serverEnableLoggingToFile.put(id, this.serverEnableLoggingToFile.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(id))));
                this.serverEnableLoggingToConsole.put(id, this.serverEnableLoggingToConsole.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(id))));
            }
        });
        this.launchConfigurationViewer.setInput(contentTypeToLSPLaunchConfigEntries);
        this.launchConfigurationViewer.refresh();
        languageServerIDs.clear();
        ArrayList contentTypeToLanguageServerDefinitions = new ArrayList();
        LanguageServersRegistry.getInstance().getContentTypeToLSPExtensions().forEach(o -> {
            String id = ((LanguageServersRegistry.LanguageServerDefinition)o.getValue()).id;
            if (languageServerIDs.add(id)) {
                contentTypeToLanguageServerDefinitions.add(o);
                this.serverEnableLoggingToFile.put(id, this.serverEnableLoggingToFile.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToFileLoggingId(id))));
                this.serverEnableLoggingToConsole.put(id, this.serverEnableLoggingToConsole.getOrDefault(id, this.store.getBoolean(LoggingStreamConnectionProviderProxy.lsToConsoleLoggingId(id))));
            }
        });
        this.languageServerViewer.setInput(contentTypeToLanguageServerDefinitions);
        this.launchConfigurationViewer.refresh();
    }

    private final class BooleanMapEditingSupport
    extends EditingSupport {
        private final Map<String, Boolean> map;

        private BooleanMapEditingSupport(TableViewer viewer, Map<String, Boolean> map) {
            super((ColumnViewer)viewer);
            this.map = map;
        }

        protected void setValue(Object element, Object value) {
            ContentTypeToLanguageServerDefinition server = (ContentTypeToLanguageServerDefinition)element;
            this.map.put(((LanguageServersRegistry.LanguageServerDefinition)server.getValue()).id, (Boolean)value);
            LoggingPreferencePage.this.hasLoggingBeenChanged = true;
            this.getViewer().refresh(element);
        }

        protected Object getValue(Object element) {
            ContentTypeToLanguageServerDefinition server = (ContentTypeToLanguageServerDefinition)element;
            return this.map.get(((LanguageServersRegistry.LanguageServerDefinition)server.getValue()).id);
        }

        protected CellEditor getCellEditor(Object element) {
            return new CheckboxCellEditor();
        }

        protected boolean canEdit(Object element) {
            return true;
        }
    }

    private final class BooleanMapLabelProvider
    extends ColumnLabelProvider {
        private final Map<String, Boolean> map;

        private BooleanMapLabelProvider(Map<String, Boolean> map) {
            this.map = map;
        }

        public String getText(Object element) {
            return this.map.getOrDefault(((LanguageServersRegistry.LanguageServerDefinition)((ContentTypeToLanguageServerDefinition)element).getValue()).id, false) != false ? Messages.PreferencePage_enablementCondition_true : Messages.PreferencePage_enablementCondition_false;
        }
    }
}

