/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.petrinet;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionWithVars;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.CommandReplyWithVars;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.EventWithVars;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.component.component.StateBasedFunctionalConstraint;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAddition;
import org.eclipse.comma.expressions.expression.ExpressionAnd;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionBracket;
import org.eclipse.comma.expressions.expression.ExpressionBulkData;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionConstantInt;
import org.eclipse.comma.expressions.expression.ExpressionConstantReal;
import org.eclipse.comma.expressions.expression.ExpressionConstantString;
import org.eclipse.comma.expressions.expression.ExpressionDivision;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionEqual;
import org.eclipse.comma.expressions.expression.ExpressionFunctionCall;
import org.eclipse.comma.expressions.expression.ExpressionGeq;
import org.eclipse.comma.expressions.expression.ExpressionGreater;
import org.eclipse.comma.expressions.expression.ExpressionLeq;
import org.eclipse.comma.expressions.expression.ExpressionLess;
import org.eclipse.comma.expressions.expression.ExpressionMap;
import org.eclipse.comma.expressions.expression.ExpressionMapRW;
import org.eclipse.comma.expressions.expression.ExpressionMaximum;
import org.eclipse.comma.expressions.expression.ExpressionMinimum;
import org.eclipse.comma.expressions.expression.ExpressionMinus;
import org.eclipse.comma.expressions.expression.ExpressionModulo;
import org.eclipse.comma.expressions.expression.ExpressionMultiply;
import org.eclipse.comma.expressions.expression.ExpressionNEqual;
import org.eclipse.comma.expressions.expression.ExpressionNot;
import org.eclipse.comma.expressions.expression.ExpressionOr;
import org.eclipse.comma.expressions.expression.ExpressionPlus;
import org.eclipse.comma.expressions.expression.ExpressionPower;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.ExpressionRecord;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionSubtraction;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.ExpressionVector;
import org.eclipse.comma.expressions.expression.MapRWContext;
import org.eclipse.comma.expressions.expression.QUANTIFIER;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.expressions.validation.ExpressionValidator;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.MapTypeConstructor;
import org.eclipse.comma.types.types.MapTypeDecl;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

class PythonHelper {
    PythonHelper() {
    }

    static String defaultValue(TypeObject type) {
        if (type instanceof VectorTypeConstructor) {
            return "[]";
        }
        if (type instanceof MapTypeConstructor) {
            return "{}";
        }
        if (type instanceof SimpleTypeDecl) {
            SimpleTypeDecl t = (SimpleTypeDecl)type;
            if (t.getBase() != null) {
                return PythonHelper.defaultValue((TypeObject)t.getBase());
            }
            if (t.getName().equals("int")) {
                return "0";
            }
            if (t.getName().equals("real")) {
                return "0.0";
            }
            if (t.getName().equals("bool")) {
                return "True";
            }
            if (t.getName().equals("string")) {
                return "\"\"";
            }
            return "\"\"";
        }
        if (type instanceof VectorTypeDecl) {
            return "[]";
        }
        if (type instanceof EnumTypeDecl) {
            EnumTypeDecl t = (EnumTypeDecl)type;
            return String.format("\"%s:%s\"", t.getName(), ((EnumElement)t.getLiterals().get(0)).getName());
        }
        if (type instanceof MapTypeDecl) {
            return "{}";
        }
        if (type instanceof RecordTypeDecl) {
            String value = TypeUtilities.getAllFields((RecordTypeDecl)((RecordTypeDecl)type)).stream().map(f -> String.format("\"%s\": %s", f.getName(), PythonHelper.defaultValue(TypeUtilities.getTypeObject((Type)f.getType())))).collect(Collectors.joining(", "));
            return String.format("{%s}", value);
        }
        throw new RuntimeException("Not supported");
    }

    static String expression(Expression expression, Function<String, String> variablePrefix) {
        return PythonHelper.expression(expression, variablePrefix, null);
    }

    static String expression(Expression expression, Function<String, String> variablePrefix, Function<Expression, String> handleUnsupported) {
        if (expression instanceof ExpressionConstantInt) {
            return Long.toString(((ExpressionConstantInt)expression).getValue());
        }
        if (expression instanceof ExpressionConstantString) {
            return String.format("\"%s\"", ((ExpressionConstantString)expression).getValue());
        }
        if (expression instanceof ExpressionNot) {
            return String.format("not (%s)", PythonHelper.expression(((ExpressionNot)expression).getSub(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionConstantReal) {
            return Double.toString(((ExpressionConstantReal)expression).getValue());
        }
        if (expression instanceof ExpressionConstantBool) {
            return ((ExpressionConstantBool)expression).isValue() ? "True" : "False";
        }
        if (expression instanceof ExpressionAny) {
            return "'ANY()'";
        }
        if (expression instanceof ExpressionAddition) {
            ExpressionAddition e = (ExpressionAddition)expression;
            return String.format("(%s) + (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionSubtraction) {
            ExpressionSubtraction e = (ExpressionSubtraction)expression;
            return String.format("(%s) - (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionMultiply) {
            ExpressionMultiply e = (ExpressionMultiply)expression;
            return String.format("(%s) * (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionDivision) {
            ExpressionDivision e = (ExpressionDivision)expression;
            return String.format("(%s) / (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionModulo) {
            ExpressionModulo e = (ExpressionModulo)expression;
            return String.format("(%s) % (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionMinimum) {
            ExpressionMinimum e = (ExpressionMinimum)expression;
            return String.format("min((%s), (%s))", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionMaximum) {
            ExpressionMaximum e = (ExpressionMaximum)expression;
            return String.format("max((%s), (%s))", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionPower) {
            ExpressionPower e = (ExpressionPower)expression;
            return String.format("pow((%s), (%s))", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionVariable) {
            String prefix;
            ExpressionVariable v = (ExpressionVariable)expression;
            Variable variableDef = v.getVariable();
            String varName = variableDef.getName();
            String string = prefix = variablePrefix != null ? variablePrefix.apply(varName) : "gl.";
            if (variableDef.eContainer() instanceof Interface) {
                if (EcoreUtil2.getContainerOfType((EObject)v, StateMachine.class) == null) {
                    return "v_" + varName;
                }
                if (prefix.endsWith("g.")) {
                    return String.valueOf(prefix) + varName;
                }
                return String.valueOf(prefix) + "g." + varName;
            }
            if (variableDef.eContainer() instanceof ExpressionQuantifier || variableDef.eContainer() instanceof MapRWContext) {
                return varName;
            }
            if (variableDef.eContainer() instanceof Parameters) {
                return "p_" + varName;
            }
            if (EcoreUtil2.getContainerOfType((EObject)variableDef, StateBasedFunctionalConstraint.class) != null) {
                return "v." + varName;
            }
            if (prefix.startsWith("p[")) {
                return prefix;
            }
            if (prefix.endsWith(".l.")) {
                return String.valueOf(prefix) + v.getVariable().getName();
            }
            return String.valueOf(prefix) + "l." + v.getVariable().getName();
        }
        if (expression instanceof ExpressionGreater) {
            ExpressionGreater e = (ExpressionGreater)expression;
            return String.format("(%s) > (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionLess) {
            ExpressionLess e = (ExpressionLess)expression;
            return String.format("(%s) < (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionLeq) {
            ExpressionLeq e = (ExpressionLeq)expression;
            return String.format("(%s) <= (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionGeq) {
            ExpressionGeq e = (ExpressionGeq)expression;
            return String.format("(%s) >= (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionEqual) {
            ExpressionEqual e = (ExpressionEqual)expression;
            return String.format("(%s) == (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionNEqual) {
            ExpressionNEqual e = (ExpressionNEqual)expression;
            return String.format("(%s) != (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionAnd) {
            ExpressionAnd e = (ExpressionAnd)expression;
            return String.format("(%s) and (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionOr) {
            ExpressionOr e = (ExpressionOr)expression;
            return String.format("(%s) or (%s)", PythonHelper.expression(e.getLeft(), variablePrefix, handleUnsupported), PythonHelper.expression(e.getRight(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionEnumLiteral) {
            ExpressionEnumLiteral e = (ExpressionEnumLiteral)expression;
            return String.format("\"%s:%s\"", e.getType().getName(), e.getLiteral().getName());
        }
        if (expression instanceof ExpressionVector) {
            ExpressionVector e = (ExpressionVector)expression;
            return String.format("[%s]", e.getElements().stream().map(ee -> PythonHelper.expression(ee, variablePrefix, handleUnsupported)).collect(Collectors.joining(", ")));
        }
        if (expression instanceof ExpressionMinus) {
            ExpressionMinus e = (ExpressionMinus)expression;
            return String.format("(%s) * -1", PythonHelper.expression(e.getSub(), variablePrefix, handleUnsupported));
        }
        if (expression instanceof ExpressionPlus) {
            ExpressionPlus e = (ExpressionPlus)expression;
            return PythonHelper.expression(e.getSub(), variablePrefix, handleUnsupported);
        }
        if (expression instanceof ExpressionBracket) {
            ExpressionBracket e = (ExpressionBracket)expression;
            return PythonHelper.expression(e.getSub(), variablePrefix, handleUnsupported);
        }
        if (expression instanceof ExpressionFunctionCall) {
            ExpressionFunctionCall e = (ExpressionFunctionCall)expression;
            if (e.getFunctionName().equals("add")) {
                return String.format("%s + [%s]", PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported), PythonHelper.expression((Expression)e.getArgs().get(1), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("size")) {
                return String.format("len(%s)", PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("isEmpty")) {
                return String.format("len(%s) == 0", PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("contains")) {
                return String.format("%s in %s", PythonHelper.expression((Expression)e.getArgs().get(1), variablePrefix, handleUnsupported), PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("abs")) {
                return String.format("abs(%s)", PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("asReal")) {
                return String.format("float(%s)", PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported));
            }
            if (e.getFunctionName().equals("hasKey")) {
                String map = PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported);
                String key = PythonHelper.expression((Expression)e.getArgs().get(1), variablePrefix, handleUnsupported);
                return String.format("(str(%s) in %s)", key, map);
            }
            if (e.getFunctionName().equals("deleteKey")) {
                String map = PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported);
                String key = PythonHelper.expression((Expression)e.getArgs().get(1), variablePrefix, handleUnsupported);
                ExpressionValidator validator = new ExpressionValidator();
                TypeObject keyType = validator.typeOf((Expression)e.getArgs().get(1));
                if (TypeUtilities.isVectorType((TypeObject)keyType)) {
                    return String.format("{_k: _v for _k, _v in %s.items() if not(_k in [str(__k) for __k in %s])}", map, key);
                }
                return String.format("{_k: _v for _k, _v in %s.items() if _k != str(%s)}", map, key);
            }
            if (e.getFunctionName().equals("matches")) {
                String arg = PythonHelper.expression((Expression)e.getArgs().get(0), variablePrefix, handleUnsupported);
                String regex = PythonHelper.expression((Expression)e.getArgs().get(1), variablePrefix, handleUnsupported);
                if (EcoreUtil2.getContainerOfType((EObject)e, Interface.class) != null) {
                    String prefix = String.valueOf(variablePrefix != null ? variablePrefix.apply("") : "gl.") + "g";
                    return String.format("%s.match(%s, %s)", prefix, regex, arg);
                }
                return String.format("re.match(%s, %s)", regex, arg);
            }
        } else if (expression instanceof ExpressionQuantifier) {
            ExpressionQuantifier e = (ExpressionQuantifier)expression;
            String collection = PythonHelper.expression(e.getCollection(), variablePrefix, handleUnsupported);
            String it = e.getIterator().getName();
            String condition = PythonHelper.expression(e.getCondition(), variablePrefix, handleUnsupported);
            if (e.getQuantifier() == QUANTIFIER.EXISTS) {
                return String.format("len([%s for %s in %s if %s]) != 0", it, it, collection, condition);
            }
            if (e.getQuantifier() == QUANTIFIER.DELETE) {
                return String.format("[%s for %s in %s if not (%s)]", it, it, collection, condition);
            }
            if (e.getQuantifier() == QUANTIFIER.FORALL) {
                return String.format("len([%s for %s in %s if %s]) == len(%s)", it, it, collection, condition, collection);
            }
        } else {
            if (expression instanceof ExpressionMap) {
                ExpressionMap e = (ExpressionMap)expression;
                return String.format("{%s}", e.getPairs().stream().map(p -> {
                    String key = PythonHelper.expression(p.getKey(), variablePrefix, handleUnsupported);
                    String value = PythonHelper.expression(p.getValue(), variablePrefix, handleUnsupported);
                    return String.format("%s: %s", key, value);
                }).collect(Collectors.joining(", ")));
            }
            if (expression instanceof ExpressionMapRW) {
                ExpressionMapRW e = (ExpressionMapRW)expression;
                String map = PythonHelper.expression(e.getMap(), variablePrefix, handleUnsupported);
                String key = PythonHelper.expression(e.getKey(), variablePrefix, handleUnsupported);
                if (e.getValue() == null) {
                    if (e.getContext() == null) {
                        return String.format("%s[str(%s)]", map, key);
                    }
                    String collection = PythonHelper.expression(e.getContext().getCollection(), variablePrefix, handleUnsupported);
                    return String.format("[%s[str(%s)] for %s in %s]", map, key, e.getContext().getIterator().getName(), collection);
                }
                String value = PythonHelper.expression(e.getValue(), variablePrefix, handleUnsupported);
                if (e.getContext() == null) {
                    return String.format("{**%s, **{str(%s): %s}}", map, key, value);
                }
                String collection = PythonHelper.expression(e.getContext().getCollection(), variablePrefix, handleUnsupported);
                return String.format("{**%s, **{str(%s): %s for %s in %s}}", map, key, value, e.getContext().getIterator().getName(), collection);
            }
            if (expression instanceof ExpressionRecord) {
                ExpressionRecord e = (ExpressionRecord)expression;
                return String.format("{%s}", e.getFields().stream().map(p -> {
                    String key = p.getRecordField().getName();
                    String value = PythonHelper.expression(p.getExp(), variablePrefix, handleUnsupported);
                    return String.format("\"%s\": %s", key, value);
                }).collect(Collectors.joining(", ")));
            }
            if (expression instanceof ExpressionRecordAccess) {
                ExpressionRecordAccess e = (ExpressionRecordAccess)expression;
                String map = PythonHelper.expression(e.getRecord(), variablePrefix, handleUnsupported);
                return String.format("%s[\"%s\"]", map, e.getField().getName());
            }
            if (expression instanceof ExpressionBulkData) {
                return "[]";
            }
            if (handleUnsupported != null) {
                return handleUnsupported.apply(expression);
            }
        }
        throw new RuntimeException("Not supported");
    }

    static String type(Object type) {
        if (type instanceof VectorTypeConstructor) {
            VectorTypeConstructor v = (VectorTypeConstructor)type;
            return String.format("{'type':'vector','dimensions':%d,'typeElem':%s}", v.getDimensions().size(), PythonHelper.type(v.getType()));
        }
        if (type instanceof MapTypeConstructor) {
            MapTypeConstructor m = (MapTypeConstructor)type;
            return String.format("{'type':'map','typeKey':%s,'typeValue':%s}", PythonHelper.type(m.getType()), PythonHelper.type(m.getValueType()));
        }
        if (type instanceof RecordTypeDecl) {
            RecordTypeDecl r = (RecordTypeDecl)type;
            String fields = r.getFields().stream().map(f -> String.format("{'name':'%s','type':%s}", f.getName(), PythonHelper.type(f.getType()))).collect(Collectors.joining(","));
            return String.format("{'type':'record','record':'%s','fields':[%s]}", r.getName(), fields);
        }
        if (type instanceof SimpleTypeDecl) {
            return String.format("'%s'", ((SimpleTypeDecl)type).getName());
        }
        if (type instanceof MapTypeDecl) {
            return PythonHelper.type(((MapTypeDecl)type).getConstructor());
        }
        if (type instanceof TypeReference) {
            return PythonHelper.type(((TypeReference)type).getType());
        }
        if (type instanceof EnumTypeDecl) {
            return "'enum'";
        }
        if (type instanceof VectorTypeDecl) {
            return PythonHelper.type(((VectorTypeDecl)type).getConstructor());
        }
        throw new RuntimeException("Not supported");
    }

    static String parameter(Type type, Object expression, int index, Function<String, String> variablePrefix) {
        String expressionStr = expression instanceof Variable ? String.format("p[%d]", index) : (expression instanceof ExpressionAny && EcoreUtil2.getContainerOfType((EObject)((EObject)expression), StateBasedFunctionalConstraint.class) == null ? String.format("p[%d]", index) : PythonHelper.expression((Expression)expression, variablePrefix));
        if (variablePrefix != null && EcoreUtil2.getContainerOfType((EObject)((EObject)expression), StateBasedFunctionalConstraint.class) != null && !expressionStr.startsWith("\"") && !expressionStr.endsWith("\"")) {
            return String.format("Parameter(%s, str(%s))", PythonHelper.type(type), expressionStr);
        }
        return String.format("Parameter(%s, '%s')", PythonHelper.type(type), expressionStr);
    }

    static List<String> parameters(Object event, TriggeredTransition trigger, Function<String, String> variablePrefix) {
        if (event instanceof TriggeredTransition) {
            TriggeredTransition e = (TriggeredTransition)event;
            AtomicInteger counter = new AtomicInteger(0);
            return e.getTrigger().getParameters().stream().filter(p -> p.getDirection() != DIRECTION.OUT).map(p -> {
                int index = e.getTrigger().getParameters().indexOf(p);
                Variable parameter = (Variable)e.getParameters().get(index);
                return PythonHelper.parameter(p.getType(), parameter, counter.getAndIncrement(), variablePrefix);
            }).collect(Collectors.toList());
        }
        if (event instanceof CommandReply) {
            CommandReply e = (CommandReply)event;
            Command cmd = (Command)trigger.getTrigger();
            List triggerParameters = cmd.getParameters().stream().filter(p -> p.getDirection() != DIRECTION.IN).collect(Collectors.toList());
            List types = triggerParameters.stream().map(p -> p.getType()).collect(Collectors.toList());
            types.add(cmd.getType());
            return e.getParameters().stream().map(expr -> {
                int index = e.getParameters().indexOf(expr);
                Type type = (Type)types.get(index);
                return PythonHelper.parameter(type, expr, index, variablePrefix);
            }).collect(Collectors.toList());
        }
        if (event instanceof CommandReplyWithVars) {
            ActionWithVars e = (ActionWithVars)event;
            TriggeredTransition tr = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)((EObject)event), TriggeredTransition.class);
            Command cmd = (Command)tr.getTrigger();
            List triggerParameters = cmd.getParameters().stream().filter(p -> p.getDirection() != DIRECTION.IN).collect(Collectors.toList());
            List types = triggerParameters.stream().map(p -> p.getType()).collect(Collectors.toList());
            types.add(cmd.getType());
            return e.getParameters().stream().map(expr -> {
                int index = e.getParameters().indexOf(expr);
                Type type = (Type)types.get(index);
                return PythonHelper.parameter(type, expr, index, variablePrefix);
            }).collect(Collectors.toList());
        }
        if (event instanceof EventCall) {
            EventCall e = (EventCall)event;
            return e.getEvent().getParameters().stream().map(p -> {
                int index = e.getEvent().getParameters().indexOf(p);
                return PythonHelper.parameter(p.getType(), e.getParameters().get(index), index, variablePrefix);
            }).collect(Collectors.toList());
        }
        if (event instanceof EventWithVars) {
            EventWithVars e = (EventWithVars)event;
            return e.getParameters().stream().map(p -> {
                int index = e.getParameters().indexOf(p);
                return PythonHelper.parameter(p.getType(), e.getParameters().get(index), index, variablePrefix);
            }).collect(Collectors.toList());
        }
        throw new RuntimeException("Not supported");
    }

    static String action(Action action, Function<String, String> variablePrefix, boolean init, boolean isPN) {
        Function<String, String> vp = variable -> "";
        if (action instanceof AssignmentAction) {
            AssignmentAction a = (AssignmentAction)action;
            String variable2 = String.format("%s%s", variablePrefix.apply(a.getAssignment().getName()), a.getAssignment().getName());
            String exp = PythonHelper.expression(a.getExp(), vp);
            if (init && exp.startsWith("\"") && exp.endsWith("\"")) {
                return String.format("%s = '%s'", variable2, exp);
            }
            if (isPN) {
                return String.format("%s = (lambda g, l: (%s))(g, l)", variable2, exp);
            }
            return String.format("%s = %s", variable2, exp);
        }
        if (action instanceof RecordFieldAssignmentAction) {
            RecordFieldAssignmentAction a = (RecordFieldAssignmentAction)action;
            ExpressionRecordAccess access = (ExpressionRecordAccess)a.getFieldAccess();
            String record = PythonHelper.expression(access.getRecord(), variablePrefix);
            String field = access.getField().getName();
            String value = PythonHelper.expression(a.getExp(), variablePrefix);
            if (init && value.startsWith("\"") && value.endsWith("\"")) {
                return String.format("%s[\"%s\"] = '%s'", record, field, value);
            }
            if (isPN) {
                return String.format("%s[\"%s\"] = (lambda g, l: (%s))(g, l)", record, field, value);
            }
            return String.format("%s[\"%s\"] = %s", record, field, value);
        }
        throw new RuntimeException("Not supported");
    }
}

